/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import lombok.Generated;
import net.risesoft.api.itemadmin.ActRuDetailApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.enums.ActRuDetailSignStatusEnum;
import net.risesoft.enums.ActRuDetailStatusEnum;
import net.risesoft.model.itemadmin.ActRuDetailModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="task4ActRuDetaillService")
public class Task4ActRuDetaillService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Task4ActRuDetaillService.class);
    private final ActRuDetailApi actRuDetailApi;
    private final OrgUnitApi orgUnitApi;
    @Resource(name="jdbcTemplate4Tenant")
    private JdbcTemplate jdbcTemplate;

    public Task4ActRuDetaillService(ActRuDetailApi actRuDetailApi, OrgUnitApi orgUnitApi) {
        this.actRuDetailApi = actRuDetailApi;
        this.orgUnitApi = orgUnitApi;
    }

    public void todo2doing(DelegateTask taskEntity) {
        try {
            String tenantId = (String)taskEntity.getVariable("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                Y9LoginUserHolder.setTenantId((String)tenantId);
                FlowableTenantInfoHolder.setTenantId(tenantId);
                this.actRuDetailApi.todo2doing(tenantId, taskEntity.getId(), taskEntity.getAssignee());
            }
        }
        catch (Exception e) {
            LOGGER.warn("##########################Task4ActRuDetaillService:todo2doing\u5f85\u529e-->\u5728\u529e\u5931\u8d25-taskId:{}##########################", (Object)taskEntity.getId(), (Object)e);
        }
    }

    public void createTodo(DelegateTask taskEntity) {
        try {
            String tenantId = (String)taskEntity.getVariable("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                Y9LoginUserHolder.setTenantId((String)tenantId);
                FlowableTenantInfoHolder.setTenantId(tenantId);
                String processSerialNumber = (String)taskEntity.getVariable("processSerialNumber");
                this.actRuDetailApi.saveOrUpdate(tenantId, this.getModel(tenantId, processSerialNumber, taskEntity, taskEntity.getAssignee()));
            }
        }
        catch (Exception e) {
            LOGGER.warn("##########################Task4ActRuDetaillService:createTodo\u4fdd\u5b58\u5f85\u529e\u4fe1\u606f\u5931\u8d25-taskId:{}##########################", (Object)taskEntity.getId(), (Object)e);
        }
    }

    private ActRuDetailModel getModel(String tenantId, String processSerialNumber, DelegateTask taskEntity, String assignee) {
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, assignee).getData();
        ActRuDetailModel model = new ActRuDetailModel();
        model.setCreateTime(taskEntity.getCreateTime());
        model.setAssignee(assignee);
        model.setAssigneeName(orgUnit.getName());
        model.setDeptId(orgUnit.getParentId());
        model.setLastTime(new Date());
        model.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        model.setTaskDefKey(taskEntity.getTaskDefinitionKey());
        model.setTaskDefName(taskEntity.getName());
        model.setExecutionId(taskEntity.getExecutionId());
        model.setProcessDefinitionKey(taskEntity.getProcessDefinitionId().split(":")[0]);
        model.setProcessInstanceId(taskEntity.getProcessInstanceId());
        model.setProcessSerialNumber(processSerialNumber);
        model.setStatus(ActRuDetailStatusEnum.TODO.getValue());
        model.setTaskId(taskEntity.getId());
        model.setStarted(true);
        model.setEnded(false);
        model.setDeleted(false);
        model.setStartTime(this.getStartTime(taskEntity.getProcessInstanceId()));
        model.setSignStatus(ActRuDetailSignStatusEnum.NONE.getValue());
        String taskSenderId = (String)taskEntity.getVariable("taskSenderId");
        OrgUnit sendUser = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, taskSenderId).getData();
        model.setSendUserId(taskSenderId);
        model.setSendUserName(sendUser.getName());
        model.setSendDeptId(sendUser.getParentId());
        return model;
    }

    private String getStartTime(String processInstanceId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sql0 = "SELECT SUBSTRING(P.START_TIME_,1,19) as START_TIME_ FROM  ACT_HI_PROCINST P WHERE P.PROC_INST_ID_ = '" + processInstanceId + "'";
        List list = this.jdbcTemplate.queryForList(sql0);
        return list.isEmpty() ? sdf.format(new Date()) : ((Map)list.get(0)).get("START_TIME_").toString();
    }

    public void claim(DelegateTask taskEntity) {
        try {
            String tenantId = (String)taskEntity.getVariable("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                Y9LoginUserHolder.setTenantId((String)tenantId);
                FlowableTenantInfoHolder.setTenantId(tenantId);
                this.actRuDetailApi.claim(tenantId, taskEntity.getId(), taskEntity.getAssignee());
            }
        }
        catch (Exception e) {
            LOGGER.warn("##########################saveOrUpdate4DoSign\u62a2\u5360\u5f0f\u8282\u70b9-\u4fdd\u5b58\u6d41\u7a0b\u6d41\u8f6c\u4fe1\u606f\u5931\u8d25-taskId:{}##########################", (Object)taskEntity.getId(), (Object)e);
        }
    }

    public void todo2doing4Jump(DelegateTask taskEntity) {
        try {
            String tenantId = (String)taskEntity.getVariable("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                Y9LoginUserHolder.setTenantId((String)tenantId);
                FlowableTenantInfoHolder.setTenantId(tenantId);
                Set linkSet = taskEntity.getCandidates();
                for (IdentityLink link : linkSet) {
                    this.actRuDetailApi.todo2doing(tenantId, taskEntity.getId(), link.getUserId());
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("##########################saveOrUpdate4Reposition\u62a2\u5360\u5f0f\u8282\u70b9-\u4fdd\u5b58\u6d41\u7a0b\u6d41\u8f6c\u4fe1\u606f\u5931\u8d25-taskId:{}##########################", (Object)taskEntity.getId());
        }
    }

    public void unClaim(DelegateTask taskEntity) {
        try {
            String tenantId = (String)taskEntity.getVariable("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                Y9LoginUserHolder.setTenantId((String)tenantId);
                FlowableTenantInfoHolder.setTenantId(tenantId);
                this.actRuDetailApi.unClaim(tenantId, taskEntity.getId());
            }
        }
        catch (Exception e) {
            LOGGER.warn("##########################unClaim\u62a2\u5360\u5f0f\u8282\u70b9-\u4fdd\u5b58\u6d41\u7a0b\u6d41\u8f6c\u4fe1\u606f\u5931\u8d25-taskId:{}##########################", (Object)taskEntity.getId());
        }
    }

    public void createTodo4Claim(DelegateTask taskEntity) {
        try {
            String tenantId = (String)taskEntity.getVariable("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                Y9LoginUserHolder.setTenantId((String)tenantId);
                FlowableTenantInfoHolder.setTenantId(tenantId);
                String processSerialNumber = (String)taskEntity.getVariable("processSerialNumber");
                StringBuffer names = new StringBuffer();
                taskEntity.getCandidates().forEach(link -> {
                    OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, link.getUserId()).getData();
                    if (StringUtils.isBlank((CharSequence)names)) {
                        names.append(orgUnit.getName());
                    } else {
                        names.append("\u3001").append(orgUnit.getName());
                    }
                });
                taskEntity.getCandidates().forEach(link -> {
                    ActRuDetailModel model = this.getModel(tenantId, processSerialNumber, taskEntity, link.getUserId());
                    model.setSignStatus(ActRuDetailSignStatusEnum.TODO.getValue());
                    model.setAssigneeName(names.toString());
                    this.actRuDetailApi.saveOrUpdate(tenantId, model);
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("##########################createTodo4Claim\u62a2\u5360\u5f0f\u8282\u70b9-\u4fdd\u5b58\u5f85\u529e\u5931\u8d25-taskId:{}##########################", (Object)taskEntity.getId());
            e.printStackTrace();
        }
    }
}

