/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.OfficeDoneInfoApi;
import net.risesoft.api.itemadmin.ProcessParamApi;
import net.risesoft.api.itemadmin.RemindInstanceApi;
import net.risesoft.api.itemadmin.extend.ItemMsgRemindApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.itemadmin.ItemMsgRemindModel;
import net.risesoft.model.itemadmin.OfficeDoneInfoModel;
import net.risesoft.model.itemadmin.ProcessParamModel;
import net.risesoft.model.itemadmin.RemindInstanceModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.app.y9processadmin.Y9ProcessAdminProperties;
import net.risesoft.y9.util.Y9Util;
import org.apache.commons.lang3.StringUtils;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="process4MsgRemindService")
public class Process4MsgRemindService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Process4MsgRemindService.class);
    private final ItemMsgRemindApi itemMsgRemindApi;
    private final ProcessParamApi processParamApi;
    private final OrgUnitApi orgUnitApi;
    private final RemindInstanceApi remindInstanceApi;
    private final OfficeDoneInfoApi officeDoneInfoApi;
    private final Y9ProcessAdminProperties y9ProcessAdminProperties;

    public void processComplete(ProcessParamModel processParamModel, String personName) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Boolean msgSwitch = this.y9ProcessAdminProperties.getMsgSwitch();
        if (msgSwitch == null || !msgSwitch.booleanValue()) {
            return;
        }
        String tenantId = Y9LoginUserHolder.getTenantId();
        String processInstanceId = processParamModel.getProcessInstanceId();
        Date date = new Date();
        String allUserId = "";
        List list = (List)this.remindInstanceApi.findRemindInstanceByProcessInstanceIdAndRemindType(tenantId, processInstanceId, RemindInstanceModel.processComplete).getData();
        if (!list.isEmpty()) {
            for (RemindInstanceModel remind : list) {
                if (allUserId.contains(remind.getUserId())) continue;
                allUserId = Y9Util.genCustomStr((String)allUserId, (String)remind.getUserId());
            }
            String itemId = processParamModel.getItemId();
            String todoTaskUrlPrefix = processParamModel.getTodoTaskUrlPrefix();
            String url = todoTaskUrlPrefix + "?itemId=" + itemId + "&processInstanceId=" + processInstanceId + "&type=fromCplane";
            String title = processParamModel.getTitle();
            String content = "\u3010" + title + "\u3011";
            ItemMsgRemindModel info = new ItemMsgRemindModel();
            info.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
            info.setItemId(processParamModel.getItemId());
            info.setMsgType("y9_processComplete");
            info.setProcessInstanceId(processInstanceId);
            info.setStartTime(sdf.format(date));
            info.setSystemName(processParamModel.getSystemName());
            info.setTitle(title);
            info.setTenantId(tenantId);
            info.setUrl(url);
            info.setUserName(personName);
            info.setTime(date.getTime());
            info.setReadUserId("");
            info.setAllUserId(allUserId);
            info.setContent(content);
            this.itemMsgRemindApi.saveMsgRemindInfo(tenantId, info);
        }
    }

    public void taskAssignment(DelegateTask task, Map<String, Object> variables) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String tenantId = (String)variables.get("tenantId");
        String processSerialNumber = (String)variables.get("processSerialNumber");
        Y9LoginUserHolder.setTenantId((String)tenantId);
        try {
            Boolean msgSwitch = this.y9ProcessAdminProperties.getMsgSwitch();
            if (msgSwitch == null || !msgSwitch.booleanValue()) {
                return;
            }
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
            String assignee = task.getAssignee();
            String taskKey = task.getTaskDefinitionKey();
            String taskName = task.getName();
            String processInstanceId = task.getProcessInstanceId();
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, assignee).getData();
            String userName = orgUnit.getName();
            Date date = new Date();
            String allUserId = "";
            List list = (List)this.remindInstanceApi.findRemindInstanceByProcessInstanceIdAndArriveTaskKey(tenantId, processInstanceId, taskKey + ":" + taskName).getData();
            if (!list.isEmpty()) {
                for (RemindInstanceModel remind : list) {
                    if (allUserId.contains(remind.getUserId())) continue;
                    allUserId = Y9Util.genCustomStr((String)allUserId, (String)remind.getUserId());
                }
                String itemId = processParamModel.getItemId();
                String todoTaskUrlPrefix = processParamModel.getTodoTaskUrlPrefix();
                String url = todoTaskUrlPrefix + "?itemId=" + itemId + "&processInstanceId=" + processInstanceId + "&type=fromCplane";
                String title = processParamModel.getTitle();
                ItemMsgRemindModel info = new ItemMsgRemindModel();
                info.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                info.setItemId(processParamModel.getItemId());
                info.setMsgType("y9_nodeArrive");
                info.setProcessInstanceId(processInstanceId);
                info.setStartTime(sdf.format(date));
                info.setSystemName(processParamModel.getSystemName());
                info.setTitle(title);
                info.setTenantId(tenantId);
                info.setUrl(url);
                info.setUserName(userName);
                info.setTime(date.getTime());
                info.setReadUserId("");
                info.setAllUserId(allUserId);
                info.setContent(taskName);
                this.itemMsgRemindApi.saveMsgRemindInfo(tenantId, info);
            }
        }
        catch (Exception e) {
            LOGGER.error("taskAssignment error", (Throwable)e);
        }
    }

    public void taskComplete(DelegateTask task, Map<String, Object> variables) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String tenantId = (String)variables.get("tenantId");
        String processSerialNumber = (String)variables.get("processSerialNumber");
        Y9LoginUserHolder.setTenantId((String)tenantId);
        try {
            Boolean msgSwitch = this.y9ProcessAdminProperties.getMsgSwitch();
            if (msgSwitch == null || !msgSwitch.booleanValue()) {
                return;
            }
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
            String assignee = task.getAssignee();
            String taskId = task.getId();
            String taskKey = task.getTaskDefinitionKey();
            String taskName = task.getName();
            String processInstanceId = task.getProcessInstanceId();
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, assignee).getData();
            String userName = orgUnit.getName();
            Date date = new Date();
            String allUserId = "";
            String title = processParamModel.getTitle();
            String itemId = processParamModel.getItemId();
            String todoTaskUrlPrefix = processParamModel.getTodoTaskUrlPrefix();
            String url = todoTaskUrlPrefix + "?itemId=" + itemId + "&processInstanceId=" + processInstanceId + "&type=fromCplane";
            List list = (List)this.remindInstanceApi.findRemindInstanceByProcessInstanceIdAndTaskId(tenantId, processInstanceId, taskId).getData();
            if (!list.isEmpty()) {
                for (RemindInstanceModel remind : list) {
                    if (allUserId.contains(remind.getUserId())) continue;
                    allUserId = Y9Util.genCustomStr((String)allUserId, (String)remind.getUserId());
                }
                String content = "\u3010" + title + "\u3011";
                ItemMsgRemindModel info = new ItemMsgRemindModel();
                info.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                info.setItemId(processParamModel.getItemId());
                info.setMsgType("y9_taskComplete");
                info.setProcessInstanceId(processInstanceId);
                info.setStartTime(sdf.format(date));
                info.setSystemName(processParamModel.getSystemName());
                info.setTitle(title);
                info.setTenantId(tenantId);
                info.setUrl(url);
                info.setUserName(userName);
                info.setTime(date.getTime());
                info.setReadUserId("");
                info.setAllUserId(allUserId);
                info.setContent(content);
                this.itemMsgRemindApi.saveMsgRemindInfo(tenantId, info);
            }
            try {
                String personIds = (String)this.itemMsgRemindApi.getRemindConfig(tenantId, assignee, "taskRemind").getData();
                if (StringUtils.isNotBlank((CharSequence)personIds)) {
                    String newPersonIds = "";
                    String[] ids = personIds.split(",");
                    OfficeDoneInfoModel officeDoneInfoModel = (OfficeDoneInfoModel)this.officeDoneInfoApi.findByProcessInstanceId(tenantId, processInstanceId).getData();
                    for (String id : ids) {
                        if (officeDoneInfoModel == null || !officeDoneInfoModel.getAllUserId().contains(id)) continue;
                        newPersonIds = Y9Util.genCustomStr((String)newPersonIds, (String)id);
                    }
                    if (StringUtils.isNotBlank((CharSequence)newPersonIds)) {
                        ItemMsgRemindModel info = new ItemMsgRemindModel();
                        info.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                        info.setItemId(processParamModel.getItemId());
                        info.setMsgType("y9_taskComplete");
                        info.setProcessInstanceId(processInstanceId);
                        info.setStartTime(sdf.format(date));
                        info.setSystemName(processParamModel.getSystemName());
                        info.setTitle(title);
                        info.setTenantId(tenantId);
                        info.setUrl(url);
                        info.setUserName(userName);
                        info.setTime(date.getTime());
                        info.setReadUserId("");
                        info.setAllUserId(personIds);
                        info.setContent("");
                        this.itemMsgRemindApi.saveMsgRemindInfo(tenantId, info);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("taskComplete error", (Throwable)e);
            }
            list = (List)this.remindInstanceApi.findRemindInstanceByProcessInstanceIdAndCompleteTaskKey(tenantId, processInstanceId, taskKey + ":" + taskName).getData();
            if (!list.isEmpty()) {
                for (RemindInstanceModel remind : list) {
                    if (allUserId.contains(remind.getUserId())) continue;
                    allUserId = Y9Util.genCustomStr((String)allUserId, (String)remind.getUserId());
                }
                date = new Date();
                ItemMsgRemindModel info = new ItemMsgRemindModel();
                info.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                info.setItemId(processParamModel.getItemId());
                info.setMsgType("y9_nodeComplete");
                info.setProcessInstanceId(processInstanceId);
                info.setStartTime(sdf.format(date));
                info.setSystemName(processParamModel.getSystemName());
                info.setTitle(title);
                info.setTenantId(tenantId);
                info.setUrl(url);
                info.setUserName(userName);
                info.setTime(date.getTime());
                info.setReadUserId("");
                info.setAllUserId(allUserId);
                info.setContent(taskName);
                this.itemMsgRemindApi.saveMsgRemindInfo(tenantId, info);
            }
        }
        catch (Exception e) {
            LOGGER.error("taskComplete error", (Throwable)e);
        }
    }

    @Generated
    public Process4MsgRemindService(ItemMsgRemindApi itemMsgRemindApi, ProcessParamApi processParamApi, OrgUnitApi orgUnitApi, RemindInstanceApi remindInstanceApi, OfficeDoneInfoApi officeDoneInfoApi, Y9ProcessAdminProperties y9ProcessAdminProperties) {
        this.itemMsgRemindApi = itemMsgRemindApi;
        this.processParamApi = processParamApi;
        this.orgUnitApi = orgUnitApi;
        this.remindInstanceApi = remindInstanceApi;
        this.officeDoneInfoApi = officeDoneInfoApi;
        this.y9ProcessAdminProperties = y9ProcessAdminProperties;
    }
}

