/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.ItemInterfaceApi;
import net.risesoft.api.itemadmin.ProcessParamApi;
import net.risesoft.enums.ItemInterfaceTypeEnum;
import net.risesoft.model.itemadmin.InterfaceModel;
import net.risesoft.model.itemadmin.ProcessParamModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.AsyncUtilService;
import net.risesoft.service.InterfaceMethodService;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.app.y9processadmin.Y9ProcessAdminProperties;
import org.flowable.engine.delegate.event.impl.FlowableSequenceFlowTakenEventImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="interfaceUtilService")
public class InterfaceUtilService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InterfaceUtilService.class);
    private final ProcessParamApi processParamApi;
    private final ItemInterfaceApi itemInterfaceApi;
    private final AsyncUtilService asyncUtilService;
    private final InterfaceMethodService interfaceMethodService;
    private final Y9ProcessAdminProperties y9ProcessAdminProperties;

    public void interfaceCallByProcess(ExecutionEntityImpl executionEntity, Map<String, Object> variables, String condition) throws Exception {
        String processDefinitionId = executionEntity.getProcessDefinitionId();
        String taskDefinitionKey = "";
        String tenantId = "";
        String processSerialNumber = "";
        String processInstanceId = executionEntity.getProcessInstanceId();
        String itemId = "";
        String orgUnitId = Y9LoginUserHolder.getOrgUnitId();
        Y9Result y9Result = null;
        Boolean interfaceSwitch = this.y9ProcessAdminProperties.getInterfaceSwitch();
        if (!interfaceSwitch.booleanValue()) {
            return;
        }
        try {
            tenantId = FlowableTenantInfoHolder.getTenantId();
            processSerialNumber = (String)variables.get("processSerialNumber");
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
            itemId = processParamModel.getItemId();
            y9Result = this.itemInterfaceApi.getInterface(tenantId, itemId, taskDefinitionKey, processDefinitionId, condition);
        }
        catch (Exception e) {
            StringWriter result = new StringWriter();
            PrintWriter print = new PrintWriter(result);
            e.printStackTrace(print);
            String msg = ((Object)result).toString();
            this.interfaceMethodService.saveErrorLog(tenantId, processInstanceId, "", "", "interfaceCallByProcess", msg);
        }
        if (y9Result != null && y9Result.isSuccess() && y9Result.getData() != null && !((List)y9Result.getData()).isEmpty()) {
            for (InterfaceModel info : (List)y9Result.getData()) {
                if (info.getAsyn().equals("1")) {
                    this.asyncUtilService.asynInterface(tenantId, orgUnitId, processSerialNumber, itemId, info, processInstanceId, processDefinitionId, "", "", null);
                    continue;
                }
                if (!info.getAsyn().equals("0")) continue;
                this.syncInterface(processSerialNumber, itemId, info, processInstanceId, processDefinitionId, "", "", null);
            }
        }
    }

    public void interfaceCallBySequenceFlow(FlowableSequenceFlowTakenEventImpl flow, String condition) throws Exception {
        String processDefinitionId = flow.getProcessDefinitionId();
        String taskDefinitionKey = flow.getId();
        String tenantId = "";
        String processInstanceId = "";
        String processSerialNumber = "";
        String itemId = "";
        Y9Result y9Result = null;
        String orgUnitId = Y9LoginUserHolder.getOrgUnitId();
        Boolean interfaceSwitch = this.y9ProcessAdminProperties.getInterfaceSwitch();
        if (!interfaceSwitch.booleanValue()) {
            return;
        }
        try {
            tenantId = FlowableTenantInfoHolder.getTenantId();
            processInstanceId = flow.getProcessInstanceId();
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessInstanceId(tenantId, processInstanceId).getData();
            if (processParamModel == null) {
                LOGGER.info("*********************\u6d41\u7a0b\u5b9e\u4f8bID:{}", (Object)processInstanceId);
                return;
            }
            itemId = processParamModel.getItemId();
            processSerialNumber = processParamModel.getProcessSerialNumber();
            y9Result = this.itemInterfaceApi.getInterface(tenantId, itemId, taskDefinitionKey, processDefinitionId, condition);
        }
        catch (Exception e) {
            StringWriter result = new StringWriter();
            PrintWriter print = new PrintWriter(result);
            e.printStackTrace(print);
            String msg = ((Object)result).toString();
            this.interfaceMethodService.saveErrorLog(tenantId, processInstanceId, flow.getId(), flow.getId(), "interfaceCallBySequenceFlow", msg);
        }
        if (y9Result != null && y9Result.isSuccess() && y9Result.getData() != null && !((List)y9Result.getData()).isEmpty()) {
            for (InterfaceModel info : (List)y9Result.getData()) {
                if (info.getAsyn().equals("1")) {
                    this.asyncUtilService.asynInterface(tenantId, orgUnitId, processSerialNumber, itemId, info, processInstanceId, processDefinitionId, flow.getId(), taskDefinitionKey, null);
                    continue;
                }
                if (!info.getAsyn().equals("0")) continue;
                this.syncInterface(processSerialNumber, itemId, info, processInstanceId, processDefinitionId, flow.getId(), taskDefinitionKey, null);
            }
        }
    }

    public void interfaceCallByTask(DelegateTask task, Map<String, Object> variables, String condition) throws Exception {
        String processDefinitionId = task.getProcessDefinitionId();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        String tenantId = "";
        String processSerialNumber = "";
        String itemId = "";
        Integer loopCounter = null;
        String orgUnitId = task.getAssignee();
        Y9Result y9Result = null;
        Boolean interfaceSwitch = this.y9ProcessAdminProperties.getInterfaceSwitch();
        if (!interfaceSwitch.booleanValue()) {
            return;
        }
        try {
            tenantId = FlowableTenantInfoHolder.getTenantId();
            processSerialNumber = (String)variables.get("processSerialNumber");
            loopCounter = variables.get("loopCounter") != null ? (Integer)variables.get("loopCounter") : null;
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
            itemId = processParamModel.getItemId();
            y9Result = this.itemInterfaceApi.getInterface(tenantId, itemId, taskDefinitionKey, processDefinitionId, condition);
        }
        catch (Exception e) {
            StringWriter result = new StringWriter();
            PrintWriter print = new PrintWriter(result);
            e.printStackTrace(print);
            String msg = ((Object)result).toString();
            this.interfaceMethodService.saveErrorLog(tenantId, task.getProcessInstanceId(), task.getId(), task.getTaskDefinitionKey(), "interfaceCallByTask", msg);
        }
        if (y9Result != null && y9Result.isSuccess() && y9Result.getData() != null && !((List)y9Result.getData()).isEmpty()) {
            for (InterfaceModel info : (List)y9Result.getData()) {
                if (info.getAsyn().equals("1")) {
                    this.asyncUtilService.asynInterface(tenantId, orgUnitId, processSerialNumber, itemId, info, task.getProcessInstanceId(), processDefinitionId, task.getId(), task.getTaskDefinitionKey(), loopCounter);
                    continue;
                }
                if (!info.getAsyn().equals("0")) continue;
                this.syncInterface(processSerialNumber, itemId, info, task.getProcessInstanceId(), processDefinitionId, task.getId(), task.getTaskDefinitionKey(), loopCounter);
            }
        }
    }

    public void syncInterface(String processSerialNumber, String itemId, InterfaceModel info, String processInstanceId, String processDefinitionId, String taskId, String taskKey, Integer loopCounter) throws Exception {
        if (info.getRequestType().equals(ItemInterfaceTypeEnum.METHOD_GET.getValue())) {
            this.interfaceMethodService.getMethod(processSerialNumber, itemId, info, processInstanceId, processDefinitionId, taskId, taskKey, loopCounter);
        } else if (info.getRequestType().equals(ItemInterfaceTypeEnum.METHOD_POST.getValue())) {
            this.interfaceMethodService.postMethod(processSerialNumber, itemId, info, processInstanceId, processDefinitionId, taskId, taskKey, loopCounter);
        }
    }

    @Generated
    public InterfaceUtilService(ProcessParamApi processParamApi, ItemInterfaceApi itemInterfaceApi, AsyncUtilService asyncUtilService, InterfaceMethodService interfaceMethodService, Y9ProcessAdminProperties y9ProcessAdminProperties) {
        this.processParamApi = processParamApi;
        this.itemInterfaceApi = itemInterfaceApi;
        this.asyncUtilService = asyncUtilService;
        this.interfaceMethodService = interfaceMethodService;
        this.y9ProcessAdminProperties = y9ProcessAdminProperties;
    }
}

