/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.sql.DataSource;
import lombok.Generated;
import net.risesoft.api.itemadmin.ErrorLogApi;
import net.risesoft.api.itemadmin.ItemInterfaceApi;
import net.risesoft.enums.ItemInterfaceTypeEnum;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.itemadmin.ErrorLogModel;
import net.risesoft.model.itemadmin.InterfaceModel;
import net.risesoft.model.itemadmin.InterfaceParamsModel;
import net.risesoft.model.itemadmin.TaskTimeConfModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.Y9Properties;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.sqlddl.DbMetaDataUtil;
import net.risesoft.y9public.entity.Y9FileStore;
import net.risesoft.y9public.service.Y9FileStoreService;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;

@Service(value="interfaceMethodService")
public class InterfaceMethodService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InterfaceMethodService.class);
    private final ErrorLogApi errorLogApi;
    private final ItemInterfaceApi itemInterfaceApi;
    private final Y9FileStoreService y9FileStoreService;
    private final Y9Properties y9Config;
    @Resource(name="jdbcTemplate4Tenant")
    private JdbcTemplate jdbcTemplate;

    public InterfaceMethodService(ItemInterfaceApi itemInterfaceApi, Y9FileStoreService y9FileStoreService, Y9Properties y9Config, ErrorLogApi errorLogApi) {
        this.itemInterfaceApi = itemInterfaceApi;
        this.y9FileStoreService = y9FileStoreService;
        this.y9Config = y9Config;
        this.errorLogApi = errorLogApi;
    }

    public void dataHandling(String processSerialNumber, String processInstanceId, Map<String, Object> map, List<InterfaceParamsModel> paramsList, InterfaceModel info, Integer loopCounter) throws Exception {
        block19: {
            if (map != null && paramsList != null && !paramsList.isEmpty()) {
                try {
                    ArrayList tableList = new ArrayList();
                    for (InterfaceParamsModel model : paramsList) {
                        if (!model.getBindType().equals(ItemInterfaceTypeEnum.INTERFACE_RESPONSE.getValue())) continue;
                        HashMap<String, String> tableMap = new HashMap<String, String>();
                        tableMap.put("tableName", model.getTableName());
                        tableMap.put("tableType", model.getTableType());
                        if (tableList.contains(tableMap)) continue;
                        tableList.add(tableMap);
                    }
                    DataSource database = Objects.requireNonNull(this.jdbcTemplate.getDataSource());
                    String dialect = DbMetaDataUtil.getDatabaseDialectName((DataSource)database);
                    Object guid = "";
                    for (Map map2 : tableList) {
                        StringBuilder sqlStr;
                        String tableType;
                        String tableName = (String)map2.get("tableName");
                        String string = tableType = map2.get("tableType") != null ? (String)map2.get("tableType") : "1";
                        if (tableType.equals("2")) {
                            guid = (String)processSerialNumber + "_loopCounter_" + loopCounter;
                            sqlStr = this.getSqlStr(dialect, tableName);
                            List res_list = this.jdbcTemplate.queryForList(sqlStr.toString(), new Object[]{guid});
                            if (res_list.size() == 0) {
                                this.insertData(tableName, (String)processSerialNumber, map, paramsList, (String)guid);
                                continue;
                            }
                        }
                        sqlStr = new StringBuilder();
                        if ("oracle".equals(dialect)) {
                            sqlStr.append("update \"").append(tableName).append("\" set ");
                        } else if ("dm".equals(dialect)) {
                            sqlStr.append("update \"").append(tableName).append("\" set ");
                        } else if ("mysql".equals(dialect)) {
                            sqlStr.append("update ").append(tableName).append(" set ");
                        } else if ("kingbase".equals(dialect)) {
                            sqlStr.append("update \"").append(tableName).append("\" set ");
                        }
                        boolean isHaveField = false;
                        for (InterfaceParamsModel model : paramsList) {
                            if (!model.getBindType().equals(ItemInterfaceTypeEnum.INTERFACE_RESPONSE.getValue()) || !model.getTableName().equals(tableName)) continue;
                            String fieldName = model.getColumnName();
                            String parameterName = model.getParameterName();
                            String value = "";
                            if (map.get(parameterName) != null) {
                                value = map.get(parameterName) instanceof ArrayList ? Y9JsonUtil.writeValueAsString((Object)map.get(parameterName)) : String.valueOf(map.get(parameterName));
                            }
                            if (StringUtils.isNotBlank((CharSequence)model.getFileType()) && StringUtils.isNotBlank((CharSequence)value)) {
                                String downloadUrl;
                                LOGGER.info("********************\u6587\u4ef6\u5b57\u6bb5\u5904\u7406:" + model.getParameterName());
                                value = downloadUrl = this.saveFile((String)processSerialNumber, value, model.getFileType());
                            }
                            if (isHaveField) {
                                sqlStr.append(",");
                            }
                            sqlStr.append(fieldName).append("=");
                            sqlStr.append((String)(StringUtils.isNotBlank((CharSequence)value) ? "'" + value + "'" : "''"));
                            isHaveField = true;
                        }
                        if (tableType.equals("2")) {
                            processSerialNumber = guid;
                        }
                        sqlStr.append(" where guid ='").append((String)processSerialNumber).append("'");
                        String sql = sqlStr.toString();
                        this.jdbcTemplate.execute(sql);
                    }
                }
                catch (Exception e) {
                    StringWriter msgResult = new StringWriter();
                    PrintWriter print = new PrintWriter(msgResult);
                    e.printStackTrace(print);
                    String msg = ((Object)msgResult).toString();
                    this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, "dataHandling", "", info.getInterfaceAddress(), msg);
                    if (!info.getAbnormalStop().equals("1")) break block19;
                    throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_dataHandling\uff1a" + info.getInterfaceAddress());
                }
            }
        }
    }

    public void getMethod(String processSerialNumber, String itemId, InterfaceModel info, String processInstanceId, String processDefinitionId, String taskId, String taskKey, Integer loopCounter) throws Exception {
        block20: {
            try {
                HttpClient client = new HttpClient();
                GetMethod method = new GetMethod();
                method.setPath(info.getInterfaceAddress());
                method.addRequestHeader("auth-positionId", Y9LoginUserHolder.getOrgUnitId());
                method.addRequestHeader("auth-tenantId", Y9LoginUserHolder.getTenantId());
                Y9Result y9Result = this.itemInterfaceApi.getInterfaceParams(Y9LoginUserHolder.getTenantId(), itemId, info.getId());
                ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
                if (y9Result.isSuccess() && y9Result.getData() != null && !((List)y9Result.getData()).isEmpty()) {
                    List<Map<String, Object>> list = this.getRequestParams((List)y9Result.getData(), processSerialNumber, processInstanceId, info, loopCounter);
                    for (InterfaceParamsModel model : (List)y9Result.getData()) {
                        String tableName;
                        String parameterValue;
                        if (!model.getBindType().equals(ItemInterfaceTypeEnum.INTERFACE_REQUEST.getValue())) continue;
                        if (model.getParameterType().equals(ItemInterfaceTypeEnum.PARAMS.getValue()) || model.getParameterType().equals(ItemInterfaceTypeEnum.BODY.getValue())) {
                            parameterValue = "";
                            block5: for (Map<String, Object> map : list) {
                                tableName = map.get("tableName").toString();
                                String tableType = map.get("tableType") != null ? map.get("tableType").toString() : "1";
                                List paramsList = (List)map.get("paramsList");
                                if (!model.getTableName().equals(tableName)) continue;
                                for (Map paramMap : paramsList) {
                                    if (!paramMap.containsKey(model.getColumnName())) continue;
                                    parameterValue = paramMap.get(model.getColumnName()) instanceof ArrayList ? Y9JsonUtil.writeValueAsString(paramMap.get(model.getColumnName())) : (String)paramMap.get(model.getColumnName());
                                    if (tableType.equals("2") || loopCounter == null) continue block5;
                                    try {
                                        JSONArray array = JSON.parseArray((String)((String)map.get(model.getColumnName())));
                                        parameterValue = array.size() > loopCounter ? array.get(loopCounter.intValue()).toString() : "";
                                        LOGGER.info("*****************" + model.getColumnName() + "\u662f\u6570\u7ec4:" + Y9JsonUtil.writeValueAsString((Object)map.get(model.getColumnName())));
                                    }
                                    catch (Exception exception) {}
                                    continue block5;
                                }
                            }
                            nameValuePairs.add(new NameValuePair(model.getParameterName(), parameterValue));
                        }
                        if (!model.getParameterType().equals(ItemInterfaceTypeEnum.HEADERS.getValue())) continue;
                        parameterValue = "";
                        for (Map<String, Object> map : list) {
                            tableName = map.get("tableName").toString();
                            List paramsList = (List)map.get("paramsList");
                            if (!model.getTableName().equals(tableName)) continue;
                            for (Map paramMap : paramsList) {
                                if (!paramMap.containsKey(model.getColumnName())) continue;
                                if (paramMap.get(model.getColumnName()) instanceof ArrayList) {
                                    parameterValue = Y9JsonUtil.writeValueAsString(paramMap.get(model.getColumnName()));
                                    continue;
                                }
                                parameterValue = (String)paramMap.get(model.getColumnName());
                            }
                        }
                        method.addRequestHeader(model.getParameterName(), parameterValue);
                    }
                }
                if (!nameValuePairs.isEmpty()) {
                    method.setQueryString(nameValuePairs.toArray(new NameValuePair[nameValuePairs.size()]));
                }
                int time = 10000;
                TaskTimeConfModel taskTimeConf = (TaskTimeConfModel)this.itemInterfaceApi.getTaskTimeConf(Y9LoginUserHolder.getTenantId(), processDefinitionId, itemId, taskKey).getData();
                if (taskTimeConf != null && taskTimeConf.getTimeoutInterrupt() != null && taskTimeConf.getTimeoutInterrupt() > 0) {
                    time = taskTimeConf.getTimeoutInterrupt();
                }
                LOGGER.info("*********************\u8bbe\u7f6e\u8bf7\u6c42\u8d85\u65f6\u53c2\u6570:" + time);
                client.getHttpConnectionManager().getParams().setConnectionTimeout(time);
                client.getHttpConnectionManager().getParams().setSoTimeout(time);
                int httpCode = client.executeMethod((HttpMethod)method);
                if (httpCode == 200) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    String response = new String(method.getResponseBodyAsString().getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
                    Y9Result result = (Y9Result)objectMapper.readValue(response, Y9Result.class);
                    if (!result.isSuccess()) {
                        if (info.getAbnormalStop().equals("1")) {
                            this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, taskId, taskKey, info.getInterfaceAddress(), response);
                            throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_\u8fd4\u56de\u7ed3\u679c\uff1a" + response + "|" + info.getInterfaceAddress());
                        }
                    } else {
                        this.dataHandling(processSerialNumber, processInstanceId, (Map)result.getData(), (List)y9Result.getData(), info, loopCounter);
                    }
                } else {
                    this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, taskId, taskKey, info.getInterfaceAddress(), "httpCode:" + httpCode);
                    if (info.getAbnormalStop().equals("1")) {
                        throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_\u8fd4\u56de\u72b6\u6001\uff1a" + httpCode + "|" + info.getInterfaceAddress());
                    }
                }
            }
            catch (Exception e) {
                StringWriter msgResult = new StringWriter();
                PrintWriter print = new PrintWriter(msgResult);
                e.printStackTrace(print);
                String msg = ((Object)msgResult).toString();
                this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, taskId, taskKey, info.getInterfaceAddress(), msg);
                if (!info.getAbnormalStop().equals("1")) break block20;
                throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_getMethod\uff1a" + info.getInterfaceAddress());
            }
        }
    }

    public List<Map<String, Object>> getRequestParams(List<InterfaceParamsModel> list, String processSerialNumber, String processInstanceId, InterfaceModel info, Integer loopCounter) throws Exception {
        try {
            ArrayList<Map<String, Object>> tableList = new ArrayList<Map<String, Object>>();
            for (InterfaceParamsModel interfaceParamsModel : list) {
                if (!interfaceParamsModel.getBindType().equals(ItemInterfaceTypeEnum.INTERFACE_REQUEST.getValue())) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("tableName", interfaceParamsModel.getTableName());
                map.put("tableType", interfaceParamsModel.getTableType());
                map.put("paramsList", new ArrayList());
                if (tableList.contains(map)) continue;
                tableList.add(map);
            }
            for (Map map : tableList) {
                String tableName = (String)map.get("tableName");
                DataSource dataSource = Objects.requireNonNull(this.jdbcTemplate.getDataSource());
                String dialect = DbMetaDataUtil.getDatabaseDialectName((DataSource)dataSource);
                StringBuilder sqlStr = this.getSqlStr(dialect, tableName);
                Object guid = processSerialNumber;
                if (map.get("tableType") != null && map.get("tableType").equals("2") && loopCounter != null) {
                    guid = processSerialNumber + "_loopCounter_" + loopCounter;
                }
                List res_list = this.jdbcTemplate.queryForList(sqlStr.toString(), new Object[]{guid});
                map.put("paramsList", res_list);
            }
            LOGGER.info("*********************\u8bf7\u6c42\u53c2\u6570\u8fd4\u56de\u7ed3\u679c:listmap={}", (Object)Y9JsonUtil.writeValueAsString(tableList));
            return tableList;
        }
        catch (Exception e) {
            StringWriter msgResult = new StringWriter();
            PrintWriter printWriter = new PrintWriter(msgResult);
            e.printStackTrace(printWriter);
            String msg = ((Object)msgResult).toString();
            this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, "getRequestParams", "", info.getInterfaceAddress(), msg);
            if (info.getAbnormalStop().equals("1")) {
                throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_getRequestParams\uff1a" + info.getInterfaceAddress());
            }
            return new ArrayList<Map<String, Object>>();
        }
    }

    private StringBuilder getSqlStr(String dialect, String tableName) {
        StringBuilder sqlStr = new StringBuilder();
        if ("oracle".equals(dialect)) {
            sqlStr = new StringBuilder("SELECT * FROM \"" + tableName + "\" where guid =?");
        } else if ("dm".equals(dialect)) {
            sqlStr = new StringBuilder("SELECT * FROM \"" + tableName + "\" where guid =?");
        } else if ("kingbase".equals(dialect)) {
            sqlStr = new StringBuilder("SELECT * FROM \"" + tableName + "\" where guid =?");
        } else if ("mysql".equals(dialect)) {
            sqlStr = new StringBuilder("SELECT * FROM " + tableName + " where guid =?");
        }
        return sqlStr;
    }

    public void insertData(String tableName, String parentProcessSerialNumber, Map<String, Object> map, List<InterfaceParamsModel> paramsList, String guid) throws Exception {
        DataSource database = Objects.requireNonNull(this.jdbcTemplate.getDataSource());
        String dialect = DbMetaDataUtil.getDatabaseDialectName((DataSource)database);
        StringBuilder sqlStr = new StringBuilder();
        if ("oracle".equals(dialect)) {
            sqlStr.append("insert into \"" + tableName + "\" (");
        }
        if ("dm".equals(dialect)) {
            sqlStr.append("insert into \"" + tableName + "\" (");
        } else if ("mysql".equals(dialect)) {
            sqlStr.append("insert into " + tableName + " (");
        } else if ("kingbase".equals(dialect)) {
            sqlStr.append("insert into \"" + tableName + "\" (");
        }
        StringBuilder sqlStr1 = new StringBuilder(") values (");
        boolean isHaveField = false;
        for (InterfaceParamsModel model : paramsList) {
            if (!model.getBindType().equals(ItemInterfaceTypeEnum.INTERFACE_RESPONSE.getValue())) continue;
            String fieldName = model.getColumnName();
            String parameterName = model.getParameterName();
            String value = "";
            if (map.get(parameterName) != null) {
                value = map.get(parameterName) instanceof ArrayList ? Y9JsonUtil.writeValueAsString((Object)map.get(parameterName)) : String.valueOf(map.get(parameterName));
            }
            if (StringUtils.isNotBlank((CharSequence)model.getFileType()) && StringUtils.isNotBlank((CharSequence)value)) {
                String downloadUrl;
                LOGGER.info("********************\u6587\u4ef6\u5b57\u6bb5\u5904\u7406:" + model.getParameterName());
                value = downloadUrl = this.saveFile(parentProcessSerialNumber, value, model.getFileType());
            }
            if (isHaveField) {
                sqlStr.append(",");
            }
            sqlStr.append(fieldName);
            if (isHaveField) {
                sqlStr1.append(",");
            }
            sqlStr1.append("'" + value + "'");
            isHaveField = true;
        }
        sqlStr.append(",");
        sqlStr.append("guid");
        sqlStr1.append(",");
        sqlStr1.append("'" + guid + "'");
        sqlStr.append(",");
        sqlStr.append("parentProcessSerialNumber");
        sqlStr1.append(",");
        sqlStr1.append("'" + parentProcessSerialNumber + "'");
        sqlStr.append(",");
        sqlStr.append("y9_userId");
        sqlStr1.append(",");
        sqlStr1.append("'" + Y9LoginUserHolder.getOrgUnitId() + "'");
        sqlStr1.append(")");
        sqlStr.append((CharSequence)sqlStr1);
        String sql = sqlStr.toString();
        this.jdbcTemplate.execute(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMethod(String processSerialNumber, String itemId, InterfaceModel info, String processInstanceId, String processDefinitionId, String taskId, String taskKey, Integer loopCounter) throws Exception {
        CloseableHttpClient httpclient = null;
        try {
            httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(info.getInterfaceAddress());
            httpPost.addHeader("Content-Type", "application/json;charset=utf-8");
            httpPost.addHeader("auth-positionId", Y9LoginUserHolder.getOrgUnitId());
            httpPost.addHeader("auth-tenantId", Y9LoginUserHolder.getTenantId());
            Y9Result y9Result = this.itemInterfaceApi.getInterfaceParams(Y9LoginUserHolder.getTenantId(), itemId, info.getId());
            if (y9Result.isSuccess() && y9Result.getData() != null && !((List)y9Result.getData()).isEmpty()) {
                List<Map<String, Object>> list = this.getRequestParams((List)y9Result.getData(), processSerialNumber, processInstanceId, info, loopCounter);
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                for (InterfaceParamsModel model : (List)y9Result.getData()) {
                    String tableName;
                    String parameterValue;
                    if (!model.getBindType().equals(ItemInterfaceTypeEnum.INTERFACE_REQUEST.getValue())) continue;
                    if (model.getParameterType().equals(ItemInterfaceTypeEnum.PARAMS.getValue()) || model.getParameterType().equals(ItemInterfaceTypeEnum.BODY.getValue())) {
                        parameterValue = "";
                        block14: for (Map<String, Object> map : list) {
                            tableName = map.get("tableName").toString();
                            String tableType = map.get("tableType") != null ? map.get("tableType").toString() : "";
                            List paramsList = (List)map.get("paramsList");
                            if (!model.getTableName().equals(tableName)) continue;
                            for (Map paramMap : paramsList) {
                                if (!paramMap.containsKey(model.getColumnName())) continue;
                                parameterValue = paramMap.get(model.getColumnName()) instanceof ArrayList ? Y9JsonUtil.writeValueAsString(paramMap.get(model.getColumnName())) : (String)paramMap.get(model.getColumnName());
                                if (tableType.equals("2") || loopCounter == null) continue block14;
                                try {
                                    JSONArray array = JSON.parseArray((String)((String)map.get(model.getColumnName())));
                                    parameterValue = array.size() > loopCounter ? array.get(loopCounter.intValue()).toString() : "";
                                    LOGGER.info("*****************" + model.getColumnName() + "\u662f\u6570\u7ec4:" + Y9JsonUtil.writeValueAsString((Object)map.get(model.getColumnName())));
                                }
                                catch (Exception exception) {}
                                continue block14;
                            }
                        }
                        paramsMap.put(model.getParameterName(), parameterValue);
                    }
                    if (!model.getParameterType().equals(ItemInterfaceTypeEnum.HEADERS.getValue())) continue;
                    parameterValue = "";
                    for (Map<String, Object> map : list) {
                        tableName = map.get("tableName").toString();
                        List paramsList = (List)map.get("paramsList");
                        if (!model.getTableName().equals(tableName)) continue;
                        for (Map paramMap : paramsList) {
                            if (!paramMap.containsKey(model.getColumnName())) continue;
                            if (paramMap.get(model.getColumnName()) instanceof ArrayList) {
                                parameterValue = Y9JsonUtil.writeValueAsString(paramMap.get(model.getColumnName()));
                                continue;
                            }
                            parameterValue = (String)paramMap.get(model.getColumnName());
                        }
                    }
                    httpPost.addHeader(model.getParameterName(), parameterValue);
                }
                JSONObject jsonString = new JSONObject(paramsMap);
                StringEntity entity = new StringEntity(jsonString.toString(), Consts.UTF_8);
                httpPost.setEntity((HttpEntity)entity);
            }
            int time = 10000;
            TaskTimeConfModel taskTimeConf = (TaskTimeConfModel)this.itemInterfaceApi.getTaskTimeConf(Y9LoginUserHolder.getTenantId(), processDefinitionId, itemId, taskKey).getData();
            if (taskTimeConf != null && taskTimeConf.getTimeoutInterrupt() != null && taskTimeConf.getTimeoutInterrupt() > 0) {
                time = taskTimeConf.getTimeoutInterrupt();
            }
            String urlStr = httpPost.getURI().toString();
            httpPost.setURI(new URI(urlStr));
            LOGGER.info("*********************\u8bbe\u7f6e\u8bf7\u6c42\u8d85\u65f6\u53c2\u6570:" + time);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(time).setConnectionRequestTimeout(time).setSocketTimeout(time).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int httpCode = response.getStatusLine().getStatusCode();
            if (httpCode == 200) {
                ObjectMapper objectMapper = new ObjectMapper();
                String resp = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                Y9Result result = (Y9Result)objectMapper.readValue(resp, Y9Result.class);
                if (!result.isSuccess()) {
                    this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, taskId, taskKey, info.getInterfaceAddress(), resp);
                    if (info.getAbnormalStop().equals("1")) {
                        throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_\u8fd4\u56de\u7ed3\u679c\uff1a" + resp + "|" + info.getInterfaceAddress());
                    }
                } else {
                    this.dataHandling(processSerialNumber, processInstanceId, (Map)result.getData(), (List)y9Result.getData(), info, loopCounter);
                }
            } else {
                this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, taskId, taskKey, info.getInterfaceAddress(), "httpCode:" + httpCode);
                if (info.getAbnormalStop().equals("1")) {
                    throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_\u8fd4\u56de\u72b6\u6001\uff1a" + httpCode + "|" + info.getInterfaceAddress());
                }
            }
        }
        catch (Exception e) {
            StringWriter msgResult = new StringWriter();
            PrintWriter print = new PrintWriter(msgResult);
            e.printStackTrace(print);
            String msg = ((Object)msgResult).toString();
            this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, taskId, taskKey, info.getInterfaceAddress(), msg);
            if (info.getAbnormalStop().equals("1")) {
                throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_postMethod\uff1a" + info.getInterfaceAddress());
            }
        }
        finally {
            if (httpclient != null) {
                try {
                    httpclient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Future<Boolean> saveErrorLog(String tenantId, String processInstanceId, String taskId, String taskKey, String interfaceAddress, String msg) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = sdf.format(new Date());
            ErrorLogModel errorLogModel = new ErrorLogModel();
            errorLogModel.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
            errorLogModel.setCreateTime(time);
            errorLogModel.setErrorFlag("InterfaceCall");
            errorLogModel.setErrorType("processInstanceError");
            errorLogModel.setExtendField("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:\u4efb\u52a1key\u3010" + taskKey + "\u3011,\u63a5\u53e3\u5730\u5740:" + interfaceAddress);
            errorLogModel.setProcessInstanceId(processInstanceId);
            errorLogModel.setTaskId(taskId);
            errorLogModel.setText(msg);
            errorLogModel.setUpdateTime(time);
            this.errorLogApi.saveErrorLog(tenantId, errorLogModel);
            return new AsyncResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9519\u8bef\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            return new AsyncResult((Object)false);
        }
    }

    private String saveFile(String processSerialNumber, String fileStr, String fileType) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fullPath = "/" + Y9Context.getSystemName() + "/" + processSerialNumber;
        byte[] file = Base64.getDecoder().decode(fileStr);
        Y9FileStore y9FileStore = this.y9FileStoreService.uploadFile(file, fullPath, processSerialNumber + sdf.format(new Date()) + "." + fileType);
        Object downloadUrl = "";
        if (y9FileStore != null) {
            downloadUrl = this.y9Config.getCommon().getProcessAdminBaseUrl() + "/s/" + y9FileStore.getId() + "." + fileType;
        }
        return downloadUrl;
    }
}

