/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.command;

import java.util.Date;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.identitylink.service.IdentityLinkService;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.VariableService;

public class DeleteTaskCommand
implements Command<Void> {
    protected String taskId;
    protected String reason;

    public DeleteTaskCommand(String taskId, String reason) {
        this.taskId = taskId;
        this.reason = reason;
    }

    public Void execute(CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        TaskService taskService = CommandContextUtil.getTaskService();
        IdentityLinkService identityLinkService = CommandContextUtil.getIdentityLinkService();
        VariableService variableService = CommandContextUtil.getVariableService();
        TaskEntity taskEntity = taskService.getTask(this.taskId);
        String executionId = taskEntity.getExecutionId();
        ExecutionEntity executionEntity = (ExecutionEntity)executionEntityManager.findById(executionId);
        Process process = ProcessDefinitionUtil.getProcess((String)executionEntity.getProcessDefinitionId());
        Activity flowElement = (Activity)process.getFlowElement(taskEntity.getTaskDefinitionKey());
        Object currentBehavior = flowElement.getBehavior();
        if (currentBehavior instanceof MultiInstanceActivityBehavior) {
            ExecutionEntity parentExecutionEntity = executionEntity.getParent();
            executionEntityManager.deleteChildExecutions(parentExecutionEntity, this.reason, false);
        } else {
            identityLinkService.deleteIdentityLinksByTaskId(this.taskId);
            variableService.deleteVariablesByExecutionId(executionId);
            taskService.deleteTask(taskEntity, true);
            CommandContextUtil.getHistoryManager().recordTaskEnd(taskEntity, executionEntity, this.reason, new Date());
            CommandContextUtil.getActivityInstanceEntityManager().recordActivityEnd(executionEntity, this.reason);
        }
        return null;
    }
}

