/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.processadmin.RuntimeApi;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.processadmin.ExecutionModel;
import net.risesoft.model.processadmin.ProcessInstanceModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomRuntimeService;
import net.risesoft.service.CustomTaskService;
import net.risesoft.util.FlowableModelConvertUtil;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.HistoricProcessInstanceQueryProperty;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.engine.runtime.ActivityInstanceQuery;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/runtime"}, produces={"application/json"})
public class RuntimeApiImpl
implements RuntimeApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeApiImpl.class);
    private final CustomRuntimeService customRuntimeService;
    private final RuntimeService runtimeService;
    private final CustomTaskService customTaskService;
    private final OrgUnitApi orgUnitApi;

    public Y9Result<Object> addMultiInstanceExecution(@RequestParam String tenantId, @RequestParam String activityId, @RequestParam String parentExecutionId, @RequestBody Map<String, Object> map) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customRuntimeService.addMultiInstanceExecution(activityId, parentExecutionId, map);
        return Y9Result.success();
    }

    public Y9Result<Object> complete(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestParam String processInstanceId, @RequestParam String taskId) throws Exception {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        this.customTaskService.complete(processInstanceId, taskId);
        return Y9Result.success();
    }

    public Y9Result<Object> completeSub(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestParam String taskId, List<String> userList) throws Exception {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        this.customTaskService.completeSub(taskId, userList);
        return Y9Result.success();
    }

    public Y9Result<Object> deleteMultiInstanceExecution(@RequestParam String tenantId, @RequestParam String executionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customRuntimeService.deleteMultiInstanceExecution(executionId);
        return Y9Result.success();
    }

    public Y9Result<List<String>> getActiveActivityIds(@RequestParam String tenantId, @RequestParam String executionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success(this.customRuntimeService.getActiveActivityIds(executionId));
    }

    public Y9Result<ExecutionModel> getExecutionById(@RequestParam String tenantId, @RequestParam String executionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Execution execution = this.customRuntimeService.getExecutionById(executionId);
        if (null == execution) {
            return Y9Result.failure((String)"\u672a\u627e\u5230\u6267\u884c\u5b9e\u4f8b");
        }
        return Y9Result.success((Object)FlowableModelConvertUtil.execution2Model(execution));
    }

    public Y9Result<List<ProcessInstanceModel>> getListBySuperProcessInstanceId(@RequestParam String tenantId, @RequestParam String superProcessInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<ProcessInstance> list = this.customRuntimeService.listBySuperProcessInstanceId(superProcessInstanceId);
        return Y9Result.success(FlowableModelConvertUtil.processInstanceList2ModelList(list));
    }

    public Y9Result<ProcessInstanceModel> getProcessInstance(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        ProcessInstance pi = this.customRuntimeService.getProcessInstance(processInstanceId);
        if (null == pi) {
            return Y9Result.failure((String)"\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        }
        return Y9Result.success((Object)FlowableModelConvertUtil.processInstance2Model(pi));
    }

    public Y9Page<ProcessInstanceModel> getProcessInstancesByDefId(@RequestParam String tenantId, @RequestParam String processDefinitionId, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        long totalCount = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinitionId).count();
        List list = ((ProcessInstanceQuery)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinitionId).orderBy((QueryProperty)HistoricProcessInstanceQueryProperty.START_TIME)).desc()).listPage((page - 1) * rows, rows.intValue());
        List<ProcessInstanceModel> hpiModelList = FlowableModelConvertUtil.processInstanceList2ModelList(list);
        return Y9Page.success((int)page, (int)((int)(totalCount + (long)rows.intValue() - 1L) / rows), (long)totalCount, hpiModelList);
    }

    public Y9Result<List<ProcessInstanceModel>> getProcessInstancesByKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<ProcessInstance> list = this.customRuntimeService.listProcessInstancesByKey(processDefinitionKey);
        return Y9Result.success(FlowableModelConvertUtil.processInstanceList2ModelList(list));
    }

    public Y9Result<Object> recovery4Completed(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestParam String processInstanceId, @RequestParam String year) throws Exception {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        this.customRuntimeService.recoveryCompleted(processInstanceId, year);
        return Y9Result.success();
    }

    public Y9Result<Object> recovery4SetUpCompleted(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customRuntimeService.recovery4SetUpCompleted(processInstanceId);
        return Y9Result.success();
    }

    public Y9Page<ProcessInstanceModel> runningList(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam int page, @RequestParam int rows) {
        List processInstanceList;
        long totalCount;
        FlowableTenantInfoHolder.setTenantId(tenantId);
        ArrayList<ProcessInstanceModel> items = new ArrayList<ProcessInstanceModel>();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            totalCount = this.runtimeService.createProcessInstanceQuery().count();
            processInstanceList = ((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByStartTime().desc()).listPage((page - 1) * rows, rows);
        } else {
            totalCount = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).count();
            processInstanceList = ((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).orderByStartTime().desc()).listPage((page - 1) * rows, rows);
        }
        for (ProcessInstance processInstance : processInstanceList) {
            processInstanceId = processInstance.getId();
            ProcessInstanceModel piModel = new ProcessInstanceModel();
            piModel.setId(processInstanceId);
            piModel.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            piModel.setProcessDefinitionName(processInstance.getProcessDefinitionName());
            piModel.setStartTime(processInstance.getStartTime());
            try {
                piModel.setActivityName(((ActivityInstance)((ActivityInstanceQuery)this.runtimeService.createActivityInstanceQuery().processInstanceId(processInstanceId).orderByActivityInstanceStartTime().desc()).list().get(0)).getActivityName());
                piModel.setSuspended(processInstance.isSuspended());
                piModel.setStartUserName("\u65e0");
                if (StringUtils.isNotBlank((CharSequence)processInstance.getStartUserId())) {
                    OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, processInstance.getStartUserId()).getData();
                    OrgUnit parent = (OrgUnit)this.orgUnitApi.getParent(tenantId, orgUnit.getId()).getData();
                    piModel.setStartUserName(orgUnit.getName() + "(" + parent.getName() + ")");
                }
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b[" + processInstanceId + "]\u7684\u6d3b\u52a8\u8282\u70b9\u540d\u79f0\u5931\u8d25", (Throwable)e);
            }
            items.add(piModel);
        }
        return Y9Page.success((int)page, (int)((int)totalCount / rows + 1), (long)totalCount, items, (String)"\u83b7\u53d6\u5217\u8868\u6210\u529f");
    }

    public Y9Result<Object> setUpCompleted(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customRuntimeService.setUpCompleted(processInstanceId);
        return Y9Result.success();
    }

    public Y9Result<Object> setVariable(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String key, @RequestBody Map<String, Object> map) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.customRuntimeService.setVariable(processInstanceId, key, map.get("val"));
        return Y9Result.success();
    }

    public Y9Result<Object> setVariables(@RequestParam String tenantId, @RequestParam String executionId, @RequestBody Map<String, Object> map) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.customRuntimeService.setVariables(executionId, map);
        return Y9Result.success();
    }

    public Y9Result<ProcessInstanceModel> startProcessInstanceByKey(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestParam String processDefinitionKey, @RequestParam String systemName, @RequestBody Map<String, Object> map) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        ProcessInstance pi = this.customRuntimeService.startProcessInstanceByKey(processDefinitionKey, systemName, map);
        return Y9Result.success((Object)FlowableModelConvertUtil.processInstance2Model(pi));
    }

    public Y9Result<Boolean> suspendedByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).isSuspended());
    }

    public Y9Result<Object> switchSuspendOrActive(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String state) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customRuntimeService.switchSuspendOrActive(processInstanceId, state);
        return Y9Result.success();
    }

    @Generated
    public RuntimeApiImpl(CustomRuntimeService customRuntimeService, RuntimeService runtimeService, CustomTaskService customTaskService, OrgUnitApi orgUnitApi) {
        this.customRuntimeService = customRuntimeService;
        this.runtimeService = runtimeService;
        this.customTaskService = customTaskService;
        this.orgUnitApi = orgUnitApi;
    }
}

