/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDoingApi;
import net.risesoft.model.processadmin.ProcessInstanceModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomDoingService;
import net.risesoft.y9.FlowableTenantInfoHolder;
import org.flowable.engine.HistoryService;
import org.flowable.engine.history.NativeHistoricProcessInstanceQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.history.NativeHistoricTaskInstanceQuery;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/services/rest/doing"}, produces={"application/json"})
public class ProcessDoingApiImpl
implements ProcessDoingApi {
    private final CustomDoingService customDoingService;
    private final HistoryService historyService;

    public Y9Result<Long> getCountByUserId(@RequestParam String tenantId, @RequestParam String userId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customDoingService.getCountByUserId(userId));
    }

    public Y9Page<ProcessInstanceModel> getListByUserId(@RequestParam String tenantId, @RequestParam String userId, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customDoingService.pageByUserId(userId, page, rows);
    }

    public Y9Page<ProcessInstanceModel> getListByUserIdAndProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processDefinitionKey, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customDoingService.pageByUserIdAndProcessDefinitionKey(userId, processDefinitionKey, page, rows);
    }

    public Y9Page<ProcessInstanceModel> getListByUserIdAndProcessDefinitionKeyOrderBySendTime(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processDefinitionKey, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        ArrayList<ProcessInstanceModel> resList = new ArrayList<ProcessInstanceModel>();
        String sql = "SELECT p.* from ( SELECT\tt.* FROM\tACT_HI_TASKINST t LEFT JOIN ACT_HI_PROCINST p ON t.PROC_INST_ID_ = p.PROC_INST_ID_ WHERE\tt.PROC_DEF_ID_ LIKE '" + processDefinitionKey + "%' AND p.END_TIME_ IS NULL AND t.END_TIME_ IS NOT NULL AND p.DELETE_REASON_ IS NULL AND (\tt.ASSIGNEE_ = '" + userId + "'\tOR t.OWNER_ = '" + userId + "' ) AND NOT EXISTS (\tSELECT\t\tID_\tFROM\t\tACT_HI_VARINST\tWHERE\t\tNAME_ = '" + userId + "'\tAND t.PROC_INST_ID_ = PROC_INST_ID_ ) ORDER BY t.END_TIME_ desc LIMIT 1000000 ) p GROUP BY p.PROC_INST_ID_ ORDER BY p.END_TIME_ desc";
        List htiList = ((NativeHistoricTaskInstanceQuery)this.historyService.createNativeHistoricTaskInstanceQuery().sql(sql)).listPage((page - 1) * rows, rows.intValue());
        for (HistoricTaskInstance hpi : htiList) {
            ProcessInstanceModel piModel = new ProcessInstanceModel();
            piModel.setId(hpi.getProcessInstanceId());
            piModel.setProcessDefinitionId(hpi.getProcessDefinitionId());
            piModel.setEndTime(hpi.getEndTime());
            resList.add(piModel);
        }
        String countSql = "select COUNT(RES.ID_) from ACT_HI_PROCINST RES WHERE RES.PROC_DEF_ID_ like #{processDefinitionKey} and RES.END_TIME_ IS NULL and RES.DELETE_REASON_ IS NULL and (exists(select LINK.USER_ID_ from ACT_HI_IDENTITYLINK LINK where USER_ID_ = #{USER_ID_} and LINK.PROC_INST_ID_ = RES.ID_) ) and NOT EXISTS (select ID_ from ACT_HI_VARINST where NAME_ = #{USER_ID_} and RES.PROC_INST_ID_ = PROC_INST_ID_)";
        int totalCount = (int)((NativeHistoricProcessInstanceQuery)((NativeHistoricProcessInstanceQuery)((NativeHistoricProcessInstanceQuery)this.historyService.createNativeHistoricProcessInstanceQuery().sql(countSql)).parameter("processDefinitionKey", (Object)(processDefinitionKey + "%"))).parameter("USER_ID_", (Object)userId)).count();
        return Y9Page.success((int)page, (int)((totalCount + rows - 1) / rows), (long)totalCount, resList);
    }

    public Y9Page<ProcessInstanceModel> getListByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customDoingService.pageByUserIdAndSystemName(userId, systemName, page, rows);
    }

    public Y9Page<ProcessInstanceModel> searchListByUserId(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String searchTerm, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customDoingService.pageSearchByUserId(userId, searchTerm, page, rows);
    }

    public Y9Page<ProcessInstanceModel> searchListByUserIdAndProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processDefinitionKey, @RequestParam(required=false) String searchTerm, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customDoingService.pageSearchByUserIdAndProcessDefinitionKey(userId, processDefinitionKey, searchTerm, page, rows);
    }

    public Y9Page<ProcessInstanceModel> searchListByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestParam String searchTerm, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customDoingService.pageSearchByUserIdAndSystemName(userId, systemName, searchTerm, page, rows);
    }

    @Generated
    public ProcessDoingApiImpl(CustomDoingService customDoingService, HistoryService historyService) {
        this.customDoingService = customDoingService;
        this.historyService = historyService;
    }
}

