/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.model.processadmin.FlowElementModel;
import net.risesoft.model.processadmin.GatewayModel;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomProcessDefinitionService;
import net.risesoft.y9.FlowableTenantInfoHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/processDefinition"}, produces={"application/json"})
public class ProcessDefinitionApiImpl
implements ProcessDefinitionApi {
    private final CustomProcessDefinitionService customProcessDefinitionService;

    public Y9Result<List<TargetModel>> getContainEndEvent4UserTask(@RequestParam String tenantId, @RequestParam String processDefinitionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customProcessDefinitionService.listContainEndEvent4UserTask(processDefinitionId);
    }

    public Y9Result<TargetModel> getEndNode(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customProcessDefinitionService.getEndNode(taskId);
    }

    public Y9Result<List<FlowElementModel>> listUserTask(@RequestParam String tenantId, @RequestParam String processDefinitionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customProcessDefinitionService.listUserTask(processDefinitionId);
    }

    public Y9Result<String> getNodeType(@RequestParam String tenantId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customProcessDefinitionService.getNode(processDefinitionId, taskDefKey).getMultiInstance());
    }

    public Y9Result<FlowElementModel> getNode(@RequestParam String tenantId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customProcessDefinitionService.getNode(processDefinitionId, taskDefKey));
    }

    public Y9Result<List<TargetModel>> getNodes(@RequestParam String tenantId, @RequestParam String processDefinitionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customProcessDefinitionService.listNodesByProcessDefinitionId(processDefinitionId);
    }

    public Y9Result<List<TargetModel>> getNodesOnlyMain(@RequestParam String tenantId, @RequestParam String processDefinitionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customProcessDefinitionService.listNodesByProcessDefinitionIdOnlyMain(processDefinitionId);
    }

    public Y9Result<Integer> getOutPutNodeCount(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customProcessDefinitionService.getOutPutNodeCount(taskId));
    }

    public Y9Result<List<GatewayModel>> getParallelGatewayList(@RequestParam String tenantId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customProcessDefinitionService.listParallelGateway(processDefinitionId, taskDefKey);
    }

    public Y9Result<String> getStartNodeKeyByProcessDefinitionId(@RequestParam String tenantId, @RequestParam String processDefinitionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customProcessDefinitionService.getStartNodeKeyByProcessDefinitionId(processDefinitionId));
    }

    public Y9Result<String> getStartNodeKeyByProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customProcessDefinitionService.getStartNodeKeyByProcessDefinitionKey(processDefinitionKey));
    }

    public Y9Result<TargetModel> getSubProcessParentNode(@RequestParam String tenantId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customProcessDefinitionService.getSubProcessParentNode(processDefinitionId, taskDefKey));
    }

    public Y9Result<List<TargetModel>> getTargetNodes(@RequestParam String tenantId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customProcessDefinitionService.listTargetNodes(processDefinitionId, taskDefKey);
    }

    public Y9Result<List<TargetModel>> getTargetNodes4UserTask(@RequestParam String tenantId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey, @RequestParam Boolean isContainEndNode) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customProcessDefinitionService.listTargetNodes4UserTask(processDefinitionId, taskDefKey, isContainEndNode);
    }

    public Y9Result<Boolean> isCallActivity(@RequestParam String tenantId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customProcessDefinitionService.isCallActivity(processDefinitionId, taskDefKey));
    }

    public Y9Result<Boolean> isContainEndEvent(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customProcessDefinitionService.isContainEndEvent(taskId));
    }

    public Y9Result<Boolean> isSubProcess(@RequestParam String tenantId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customProcessDefinitionService.isSubProcess(processDefinitionId, taskDefKey));
    }

    public Y9Result<Boolean> isSubProcessChildNode(@RequestParam String tenantId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customProcessDefinitionService.isSubProcessChildNode(processDefinitionId, taskDefKey));
    }

    public Y9Result<List<TargetModel>> getSubProcessChildNode(@RequestParam String tenantId, @RequestParam String processDefinitionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customProcessDefinitionService.getSubProcessChildNode(processDefinitionId);
    }

    @Generated
    public ProcessDefinitionApiImpl(CustomProcessDefinitionService customProcessDefinitionService) {
        this.customProcessDefinitionService = customProcessDefinitionService;
    }
}

