/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import lombok.Generated;
import net.risesoft.api.processadmin.MonitorApi;
import net.risesoft.model.processadmin.HistoricProcessInstanceModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomMonitorService;
import net.risesoft.service.CustomRecycleService;
import net.risesoft.y9.FlowableTenantInfoHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/monitor"}, produces={"application/json"})
public class MonitorApiImpl
implements MonitorApi {
    private final CustomMonitorService customMonitorService;
    private final CustomRecycleService customRecycleService;

    public Y9Result<Long> getDoingCountByProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customMonitorService.getDoingCountByProcessDefinitionKey(processDefinitionKey));
    }

    public Y9Result<Long> getDoingCountBySystemName(@RequestParam String tenantId, @RequestParam String systemName) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customMonitorService.getDoingCountBySystemName(systemName));
    }

    @GetMapping(value={"/getDoingListByProcessDefinitionKey"})
    public Y9Page<HistoricProcessInstanceModel> getDoingListByProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customMonitorService.pageDoingListByProcessDefinitionKey(processDefinitionKey, page, rows);
    }

    public Y9Page<HistoricProcessInstanceModel> getDoingListBySystemName(@RequestParam String tenantId, @RequestParam String systemName, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customMonitorService.pageDoingListBySystemName(systemName, page, rows);
    }

    public Y9Page<HistoricProcessInstanceModel> getAllListBySystemName(@RequestParam String tenantId, @RequestParam String systemName, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customMonitorService.pageDoingListBySystemName(systemName, page, rows);
    }

    public Y9Result<Long> getDoneCountByProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customMonitorService.getDoneCountByProcessDefinitionKey(processDefinitionKey));
    }

    public Y9Result<Long> getRecycleCountByProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customRecycleService.getRecycleCountByProcessDefinitionKey(processDefinitionKey));
    }

    public Y9Result<Long> getRecycleCountBySystemName(@RequestParam String tenantId, @RequestParam String systemName) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customRecycleService.getRecycleCountBySystemName(systemName));
    }

    public Y9Result<Long> getRecycleCountByUserIdAndProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processDefinitionKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customRecycleService.getRecycleCountByUserIdAndProcessDefinitionKey(userId, processDefinitionKey));
    }

    public Y9Result<Long> getRecycleCountByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customRecycleService.getRecycleCountByUserIdAndSystemName(userId, systemName));
    }

    public Y9Page<HistoricProcessInstanceModel> getRecycleListByProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customRecycleService.pageRecycleListByProcessDefinitionKey(processDefinitionKey, page, rows);
    }

    public Y9Page<HistoricProcessInstanceModel> getRecycleListBySystemName(@RequestParam String tenantId, @RequestParam String systemName, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customRecycleService.pageRecycleListBySystemName(systemName, page, rows);
    }

    public Y9Page<HistoricProcessInstanceModel> getRecycleListByUserIdAndProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processDefinitionKey, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customRecycleService.pageRecycleListByUserIdAndProcessDefinitionKey(userId, processDefinitionKey, page, rows);
    }

    public Y9Page<HistoricProcessInstanceModel> getRecycleListByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customRecycleService.pageRecycleListByUserIdAndSystemName(userId, systemName, page, rows);
    }

    public Y9Page<HistoricProcessInstanceModel> searchDoingListByProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey, @RequestParam String searchTerm, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customMonitorService.searchDoingListByProcessDefinitionKey(processDefinitionKey, searchTerm, page, rows);
    }

    public Y9Page<HistoricProcessInstanceModel> searchDoingListBySystemName(@RequestParam String tenantId, @RequestParam String systemName, @RequestParam String searchTerm, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customMonitorService.searchDoingListBySystemName(systemName, searchTerm, page, rows);
    }

    public Y9Page<HistoricProcessInstanceModel> searchRecycleListByProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey, @RequestParam String searchTerm, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customRecycleService.searchRecycleListByProcessDefinitionKey(processDefinitionKey, searchTerm, page, rows);
    }

    public Y9Page<HistoricProcessInstanceModel> searchRecycleListBySystemName(@RequestParam String tenantId, @RequestParam String systemName, @RequestParam String searchTerm, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customRecycleService.searchRecycleListBySystemName(systemName, searchTerm, page, rows);
    }

    public Y9Page<HistoricProcessInstanceModel> searchRecycleListByUserIdAndProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processDefinitionKey, @RequestParam String searchTerm, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customRecycleService.searchRecycleListByUserIdAndProcessDefinitionKey(userId, processDefinitionKey, searchTerm, page, rows);
    }

    public Y9Page<HistoricProcessInstanceModel> searchRecycleListByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestParam String searchTerm, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customRecycleService.searchRecycleListByUserIdAndSystemName(userId, systemName, searchTerm, page, rows);
    }

    @Generated
    public MonitorApiImpl(CustomMonitorService customMonitorService, CustomRecycleService customRecycleService) {
        this.customMonitorService = customMonitorService;
        this.customRecycleService = customRecycleService;
    }
}

