/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.processadmin.HistoricTaskApi;
import net.risesoft.model.processadmin.HistoricTaskInstanceModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomHistoricTaskService;
import net.risesoft.util.FlowableModelConvertUtil;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/historicTask"})
public class HistoricTaskApiImpl
implements HistoricTaskApi {
    private final CustomHistoricTaskService customHistoricTaskService;

    public Y9Result<List<HistoricTaskInstanceModel>> findTaskByProcessInstanceIdOrByEndTimeAsc(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String year) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<HistoricTaskInstance> list = this.customHistoricTaskService.listByProcessInstanceIdOrderByEndTimeAsc(processInstanceId, year);
        return Y9Result.success(FlowableModelConvertUtil.historicTaskInstanceList2ModelList(list));
    }

    public Y9Result<List<HistoricTaskInstanceModel>> findTaskByProcessInstanceIdOrderByStartTimeAsc(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam(required=false) String year) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<HistoricTaskInstance> list = this.customHistoricTaskService.listByProcessInstanceIdOrderByStartTimeAsc(processInstanceId, year);
        return Y9Result.success(FlowableModelConvertUtil.historicTaskInstanceList2ModelList(list));
    }

    public Y9Result<HistoricTaskInstanceModel> getById(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        HistoricTaskInstance hti = this.customHistoricTaskService.getById(taskId);
        return Y9Result.success((Object)FlowableModelConvertUtil.historicTaskInstance2Model(hti));
    }

    public Y9Result<HistoricTaskInstanceModel> getById(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam String year) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        HistoricTaskInstance hti = this.customHistoricTaskService.getByIdAndYear(taskId, year);
        return Y9Result.success((Object)FlowableModelConvertUtil.historicTaskInstance2Model(hti));
    }

    public Y9Result<List<HistoricTaskInstanceModel>> getByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam(required=false) String year) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<HistoricTaskInstance> list = this.customHistoricTaskService.listByProcessInstanceId(processInstanceId, year);
        return Y9Result.success(FlowableModelConvertUtil.historicTaskInstanceList2ModelList(list));
    }

    public Y9Result<List<HistoricTaskInstanceModel>> getByProcessInstanceIdOrderByEndTimeDesc(@RequestParam String tenantId, @RequestParam String processInstanceId, String year) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<HistoricTaskInstance> list = this.customHistoricTaskService.listByProcessInstanceIdOrderByEndTimeDesc(processInstanceId, year);
        return Y9Result.success(FlowableModelConvertUtil.historicTaskInstanceList2ModelList(list));
    }

    public Y9Result<Long> getFinishedCountByExecutionId(@RequestParam String tenantId, @RequestParam String executionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.customHistoricTaskService.getFinishedCountByExecutionId(executionId));
    }

    public Y9Result<HistoricTaskInstanceModel> getThePreviousTask(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        HistoricTaskInstance hti = this.customHistoricTaskService.getThePreviousTask(taskId);
        return Y9Result.success((Object)FlowableModelConvertUtil.historicTaskInstance2Model(hti));
    }

    public Y9Result<List<HistoricTaskInstanceModel>> getThePreviousTasks(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<HistoricTaskInstance> htiList = this.customHistoricTaskService.listThePreviousTasksByTaskId(taskId);
        return Y9Result.success(FlowableModelConvertUtil.historicTaskInstanceList2ModelList(htiList));
    }

    public Y9Result<Object> setTenantId(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.customHistoricTaskService.setTenantId(taskId);
        return Y9Result.success();
    }

    @Generated
    public HistoricTaskApiImpl(CustomHistoricTaskService customHistoricTaskService) {
        this.customHistoricTaskService = customHistoricTaskService;
    }
}

