/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.processadmin.HistoricActivityApi;
import net.risesoft.model.processadmin.HistoricActivityInstanceModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomHistoricActivityService;
import net.risesoft.util.FlowableModelConvertUtil;
import net.risesoft.y9.FlowableTenantInfoHolder;
import org.flowable.engine.history.HistoricActivityInstance;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/historicActivity"})
public class HistoricActivityApiImpl
implements HistoricActivityApi {
    private final CustomHistoricActivityService customHistoricActivityService;

    public Y9Result<List<HistoricActivityInstanceModel>> getByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<HistoricActivityInstance> list = this.customHistoricActivityService.listByProcessInstanceId(processInstanceId);
        return Y9Result.success(FlowableModelConvertUtil.historicActivityInstanceList2Model(list));
    }

    public Y9Result<List<HistoricActivityInstanceModel>> getByProcessInstanceIdAndYear(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String year) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<HistoricActivityInstance> list = this.customHistoricActivityService.listByProcessInstanceIdAndYear(processInstanceId, year);
        return Y9Result.success(FlowableModelConvertUtil.historicActivityInstanceList2Model(list));
    }

    public Y9Result<List<HistoricActivityInstanceModel>> getTaskListByExecutionId(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String executionId, String year) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customHistoricActivityService.getTaskListByExecutionId(processInstanceId, executionId, year);
    }

    @Generated
    public HistoricActivityApiImpl(CustomHistoricActivityService customHistoricActivityService) {
        this.customHistoricActivityService = customHistoricActivityService;
    }
}

