/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import net.risesoft.y9.Y9Context;
import org.apache.commons.io.FileUtils;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowUtils {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowUtils.class);

    public static String exportDiagramToFile(RepositoryService repositoryService, ProcessDefinition processDefinition) {
        String diagramResourceName = processDefinition.getDiagramResourceName();
        String key = processDefinition.getKey();
        int version = processDefinition.getVersion();
        try {
            if (diagramResourceName == null) {
                return null;
            }
            InputStream resourceAsStream = repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), diagramResourceName);
            byte[] b = new byte[resourceAsStream.available()];
            resourceAsStream.read(b, 0, b.length);
            String root = Y9Context.getWebRootRealPath();
            File file = new File(root);
            file = new File(file, "dynamicfile");
            file = new File(file, "flowchart");
            file = new File(file, key);
            file = new File(file, String.valueOf(version));
            file.mkdirs();
            file = new File(file, diagramResourceName);
            FileUtils.writeByteArrayToFile((File)file, (byte[])b);
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static String parseToZhType(String type) {
        HashMap<String, String> types = new HashMap<String, String>(16);
        types.put("userTask", "\u7528\u6237\u4efb\u52a1");
        types.put("serviceTask", "\u7cfb\u7edf\u4efb\u52a1");
        types.put("startEvent", "\u5f00\u59cb\u8282\u70b9");
        types.put("endEvent", "\u7ed3\u675f\u8282\u70b9");
        types.put("exclusiveGateway", "\u6761\u4ef6\u5224\u65ad\u8282\u70b9(\u7cfb\u7edf\u81ea\u52a8\u6839\u636e\u6761\u4ef6\u5904\u7406)");
        types.put("inclusiveGateway", "\u5e76\u884c\u5904\u7406\u4efb\u52a1");
        types.put("callActivity", "\u5b50\u6d41\u7a0b");
        return types.get(type) == null ? type : (String)types.get(type);
    }
}

