/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.ErrorLogApi;
import net.risesoft.api.itemadmin.ProcessParamApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.todo.TodoTaskApi;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.itemadmin.ErrorLogModel;
import net.risesoft.model.itemadmin.ProcessParamModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.todo.TodoTask;
import net.risesoft.service.TodoTaskService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.app.y9processadmin.Y9ProcessAdminProperties;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.event.impl.FlowableEntityEventImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.task.service.delegate.DelegateTask;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="todoTaskService")
public class TodoTaskServiceImpl
implements TodoTaskService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TodoTaskServiceImpl.class);
    private final OrgUnitApi orgUnitApi;
    private final TodoTaskApi todoTaskApi;
    private final ProcessParamApi processParamApi;
    private final ErrorLogApi errorLogApi;
    private final Y9ProcessAdminProperties y9ProcessAdminProperties;

    @Override
    public void deleteTodo(DelegateTask task, Map<String, Object> map) {
        String taskId = task.getId();
        String processInstanceId = task.getProcessInstanceId();
        try {
            Boolean todoSwitch = this.y9ProcessAdminProperties.getTodoSwitch();
            if (todoSwitch == null || Boolean.FALSE.equals(todoSwitch)) {
                LOGGER.info("######################\u4fdd\u5b58\u8d85\u7ea7\u5f85\u529e\u6309\u94ae\u5df2\u5173\u95ed,\u5982\u9700\u4fdd\u5b58\u8d85\u7ea7\u5f85\u529e\u8bf7\u66f4\u6539\u914d\u7f6e\u6587\u4ef6######################");
                return;
            }
            String tenantId = (String)map.get("tenantId");
            String assigneeId = task.getAssignee();
            boolean msg = this.todoTaskApi.deleteTodoTaskByTaskIdAndReceiverId(tenantId, task.getId(), assigneeId);
            if (msg) {
                LOGGER.info("##########################\u5220\u9664\u8d85\u7ea7\u5f85\u529e\uff1a\u6210\u529f-delete##########################");
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String time = sdf.format(new Date());
                ErrorLogModel errorLogModel = new ErrorLogModel();
                errorLogModel.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                errorLogModel.setCreateTime(time);
                errorLogModel.setErrorFlag("deleteTodo");
                errorLogModel.setErrorType("taskError");
                errorLogModel.setExtendField("\u5220\u9664\u7edf\u4e00\u5f85\u529e\u8fd4\u56defalse");
                errorLogModel.setProcessInstanceId(processInstanceId);
                errorLogModel.setTaskId(taskId);
                errorLogModel.setText("false");
                errorLogModel.setUpdateTime(time);
                this.errorLogApi.saveErrorLog(Y9LoginUserHolder.getTenantId(), errorLogModel);
                LOGGER.info("##########################\u5220\u9664\u8d85\u7ea7\u5f85\u529e\uff1a\u5931\u8d25-delete,taskId:{}##########################", (Object)task.getId());
            }
        }
        catch (Exception e) {
            LOGGER.warn("##########################\u5220\u9664\u8d85\u7ea7\u5f85\u529e\uff1a\u5931\u8d25{}##########################", (Object)e.getMessage());
            StringWriter result = new StringWriter();
            PrintWriter print = new PrintWriter(result);
            e.printStackTrace(print);
            String msg = ((Object)result).toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = sdf.format(new Date());
            ErrorLogModel errorLogModel = new ErrorLogModel();
            errorLogModel.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
            errorLogModel.setCreateTime(time);
            errorLogModel.setErrorFlag("deleteTodo");
            errorLogModel.setErrorType("taskError");
            errorLogModel.setExtendField("\u5220\u9664\u7edf\u4e00\u5f85\u529e\u5931\u8d25");
            errorLogModel.setProcessInstanceId(processInstanceId);
            errorLogModel.setTaskId(taskId);
            errorLogModel.setText(msg);
            errorLogModel.setUpdateTime(time);
            this.errorLogApi.saveErrorLog(Y9LoginUserHolder.getTenantId(), errorLogModel);
        }
    }

    @Override
    public void deleteTodoByProcessInstanceId(FlowableEvent event, Map<String, Object> variables) {
        try {
            Boolean todoSwitch = this.y9ProcessAdminProperties.getTodoSwitch();
            if (todoSwitch == null || Boolean.FALSE.equals(todoSwitch)) {
                LOGGER.info("######################\u4fdd\u5b58\u8d85\u7ea7\u5f85\u529e\u6309\u94ae\u5df2\u5173\u95ed,\u5982\u9700\u4fdd\u5b58\u8d85\u7ea7\u5f85\u529e\u8bf7\u66f4\u6539\u914d\u7f6e\u6587\u4ef6######################");
                return;
            }
            FlowableEntityEventImpl entityEvent = (FlowableEntityEventImpl)event;
            ExecutionEntityImpl executionEntity = (ExecutionEntityImpl)entityEvent.getEntity();
            VariableInstance vie = executionEntity.getVariableInstance("tenantId");
            String tenantId = vie != null ? vie.getTextValue() : "";
            boolean msg = this.todoTaskApi.deleteByProcessInstanceId(tenantId, executionEntity.getProcessInstanceId());
            if (msg) {
                LOGGER.info("##########################\u5220\u9664\u8d85\u7ea7\u5f85\u529e\uff1a\u6210\u529f-delete##########################");
            } else {
                LOGGER.info("##########################\u5220\u9664\u8d85\u7ea7\u5f85\u529e\uff1a\u5931\u8d25-delete,taskId:{}##########################", (Object)executionEntity.getProcessInstanceId());
            }
        }
        catch (Exception e) {
            LOGGER.error("##########################\u5220\u9664\u8d85\u7ea7\u5f85\u529e\uff1a\u5931\u8d25##########################" + e.getMessage());
        }
    }

    @Override
    public void saveTodoTask(DelegateTask task, Map<String, Object> map) {
        Boolean todoSwitch = this.y9ProcessAdminProperties.getTodoSwitch();
        if (todoSwitch == null || Boolean.FALSE.equals(todoSwitch)) {
            LOGGER.info("######################\u4fdd\u5b58\u8d85\u7ea7\u5f85\u529e\u6309\u94ae\u5df2\u5173\u95ed,\u5982\u9700\u4fdd\u5b58\u8d85\u7ea7\u5f85\u529e\u8bf7\u66f4\u6539\u914d\u7f6e\u6587\u4ef6######################");
            return;
        }
        String taskId = task.getId();
        String processInstanceId = task.getProcessInstanceId();
        try {
            String taskSenderId = (String)map.get("taskSenderId");
            String senderName = (String)map.get("taskSender");
            String assignee = task.getAssignee();
            String tenantId = (String)map.get("tenantId");
            Y9LoginUserHolder.setTenantId((String)tenantId);
            String processSerialNumber = (String)map.get("processSerialNumber");
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
            String itemId = processParamModel.getItemId();
            String itemName = processParamModel.getItemName();
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                OrgUnit receiverPerson = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, assignee).getData();
                OrgUnit senderPerson = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, taskSenderId).getData();
                String senderDepartmentId = senderPerson.getParentId();
                String receiverDepartmentId = receiverPerson.getParentId();
                String assigneeName = receiverPerson.getName();
                OrgUnit senderOrgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, senderDepartmentId).getData();
                OrgUnit receiverOrgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, receiverDepartmentId).getData();
                String systemName = processParamModel.getSystemName();
                String systemCnName = processParamModel.getSystemCnName();
                String todoTaskUrlPrefix = processParamModel.getTodoTaskUrlPrefix();
                String level = processParamModel.getCustomLevel() == null ? "" : processParamModel.getCustomLevel();
                String docNumber = processParamModel.getCustomNumber();
                String urgency = "0";
                String commonly = "\u4e00\u822c";
                String important = "\u91cd\u8981";
                String urgent = "\u7d27\u6025";
                if (commonly.equals(level)) {
                    urgency = "0";
                } else if (important.equals(level)) {
                    urgency = "1";
                } else if (urgent.equals(level)) {
                    urgency = "2";
                }
                switch (level) {
                    case "\u666e\u901a": {
                        urgency = "0";
                        break;
                    }
                    case "\u6025": {
                        urgency = "1";
                        break;
                    }
                    case "\u7279\u6025": {
                        urgency = "2";
                    }
                }
                TodoTask todo = new TodoTask();
                todo.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                todo.setTenantId(tenantId);
                todo.setTaskId(task.getId());
                todo.setSystemName(systemName);
                todo.setSystemCnName(systemCnName);
                todo.setAppName(itemId);
                todo.setAppCnName(itemName);
                todo.setTitle(processParamModel.getTitle());
                todo.setReceiverId(assignee);
                todo.setReceiverName(assigneeName);
                todo.setReceiverDepartmentId(receiverDepartmentId);
                todo.setReceiverDepartmentName(receiverOrgUnit.getName());
                todo.setSenderId(taskSenderId);
                todo.setSenderName(senderName);
                todo.setSenderDepartmentId(senderDepartmentId);
                todo.setSenderDepartmentName(senderOrgUnit.getName());
                todo.setSendTime(new Date());
                todo.setIsNewTodo("1");
                todo.setUrgency(urgency);
                todo.setDocNumber(docNumber);
                todo.setEmailAble(false);
                if (StringUtils.isBlank((CharSequence)processParamModel.getSended()) || "false".equals(processParamModel.getSended())) {
                    todo.setEmailAble(true);
                }
                todo.setProcessInstanceId(task.getProcessInstanceId());
                String url = todoTaskUrlPrefix + "?taskId=" + task.getId() + "&itemId=" + itemId + "&processInstanceId=&type=fromTodo";
                todo.setUrl(url);
                boolean b = this.todoTaskApi.saveTodoTask(tenantId, todo);
                if (b) {
                    LOGGER.info("##########################\u4fdd\u5b58\u8d85\u7ea7\u5f85\u529e\u6210\u529f-assignment##########################");
                } else {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String time = sdf.format(new Date());
                    ErrorLogModel errorLogModel = new ErrorLogModel();
                    errorLogModel.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                    errorLogModel.setCreateTime(time);
                    errorLogModel.setErrorFlag("saveTodoTask");
                    errorLogModel.setErrorType("taskError");
                    errorLogModel.setExtendField("\u4fdd\u5b58\u7edf\u4e00\u5f85\u529e\u8fd4\u56defalse");
                    errorLogModel.setProcessInstanceId(processInstanceId);
                    errorLogModel.setTaskId(taskId);
                    errorLogModel.setText("false");
                    errorLogModel.setUpdateTime(time);
                    this.errorLogApi.saveErrorLog(Y9LoginUserHolder.getTenantId(), errorLogModel);
                    LOGGER.info("##########################\u4fdd\u5b58\u8d85\u7ea7\u5f85\u529e\u5931\u8d25-\u751f\u6210\u8d85\u7ea7\u5f85\u529e\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38-taskId:{}##########################", (Object)task.getId());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("##########################\u4fdd\u5b58\u8d85\u7ea7\u5f85\u529e\u5931\u8d25:{}##########################", (Object)e.getMessage());
            StringWriter result = new StringWriter();
            PrintWriter print = new PrintWriter(result);
            e.printStackTrace(print);
            String msg = ((Object)result).toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = sdf.format(new Date());
            ErrorLogModel errorLogModel = new ErrorLogModel();
            errorLogModel.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
            errorLogModel.setCreateTime(time);
            errorLogModel.setErrorFlag("saveTodoTask");
            errorLogModel.setErrorType("taskError");
            errorLogModel.setExtendField("\u4fdd\u5b58\u7edf\u4e00\u5f85\u529e\u5931\u8d25");
            errorLogModel.setProcessInstanceId(processInstanceId);
            errorLogModel.setTaskId(taskId);
            errorLogModel.setText(msg);
            errorLogModel.setUpdateTime(time);
            this.errorLogApi.saveErrorLog(Y9LoginUserHolder.getTenantId(), errorLogModel);
        }
    }

    @Generated
    public TodoTaskServiceImpl(OrgUnitApi orgUnitApi, TodoTaskApi todoTaskApi, ProcessParamApi processParamApi, ErrorLogApi errorLogApi, Y9ProcessAdminProperties y9ProcessAdminProperties) {
        this.orgUnitApi = orgUnitApi;
        this.todoTaskApi = todoTaskApi;
        this.processParamApi = processParamApi;
        this.errorLogApi = errorLogApi;
        this.y9ProcessAdminProperties = y9ProcessAdminProperties;
    }
}

