/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.Y9Push;
import net.risesoft.api.itemadmin.ProcessParamApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.itemadmin.ProcessParamModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.service.PushNormalToAndroidService;
import net.risesoft.y9.configuration.app.y9processadmin.Y9ProcessAdminProperties;
import org.apache.commons.lang3.StringUtils;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pushNormalToAndroidService")
public class PushNormalToAndroidServiceImpl
implements PushNormalToAndroidService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PushNormalToAndroidServiceImpl.class);
    private final ProcessParamApi processParamApi;
    private final Y9ProcessAdminProperties y9ProcessAdminProperties;
    private final OrgUnitApi orgUnitApi;
    private final PositionApi positionApi;

    @Override
    public void pushNormalToAndroid(DelegateTask task, Map<String, Object> map) {
        Boolean pushSwitch = this.y9ProcessAdminProperties.getPushSwitch();
        if (pushSwitch == null || !pushSwitch.booleanValue()) {
            LOGGER.info("######################\u6d88\u606f\u63a8\u9001\u63d0\u9192\u5f00\u5173\u5df2\u5173\u95ed,\u5982\u9700\u63a8\u9001\u8bf7\u66f4\u6539\u914d\u7f6e\u6587\u4ef6######################");
            return;
        }
        try {
            LOGGER.info("##########################\u6d88\u606f\u63a8\u9001\u63d0\u9192##########################");
            String assignee = task.getAssignee();
            String processSerialNumber = (String)map.get("processSerialNumber");
            String tenantId = (String)map.get("tenantId");
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
            String title = processParamModel.getTitle();
            String itemName = processParamModel.getItemName();
            ArrayList<String> list = new ArrayList<String>();
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, assignee).getData();
            if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                List plist = (List)this.positionApi.listPersonsByPositionId(tenantId, assignee).getData();
                for (Person p : plist) {
                    list.add(p.getId());
                }
            } else {
                list.add(assignee);
            }
            String send = processParamModel.getSended();
            if (StringUtils.isBlank((CharSequence)send) || "false".equals(send)) {
                return;
            }
            Y9Push.pushNormalMessage(list, (String)itemName, (String)title);
        }
        catch (Exception e) {
            LOGGER.warn("##########################\u6d88\u606f\u63a8\u9001\u63d0\u9192\u53d1\u751f\u5f02\u5e38-taskId:{}##########################", (Object)task.getId(), (Object)e);
        }
    }

    @Generated
    public PushNormalToAndroidServiceImpl(ProcessParamApi processParamApi, Y9ProcessAdminProperties y9ProcessAdminProperties, OrgUnitApi orgUnitApi, PositionApi positionApi) {
        this.processParamApi = processParamApi;
        this.y9ProcessAdminProperties = y9ProcessAdminProperties;
        this.orgUnitApi = orgUnitApi;
        this.positionApi = positionApi;
    }
}

