/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.util.Date;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.ProcessInstanceApi;
import net.risesoft.api.itemadmin.ProcessParamApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.enums.ItemBoxTypeEnum;
import net.risesoft.model.itemadmin.ProcessInstanceDetailsModel;
import net.risesoft.model.itemadmin.ProcessParamModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.service.ProcessInstanceDetailsService;
import net.risesoft.y9.configuration.app.y9processadmin.Y9ProcessAdminProperties;
import org.apache.commons.lang3.StringUtils;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="processInstanceDetailsService")
public class ProcessInstanceDetailsServiceImpl
implements ProcessInstanceDetailsService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceDetailsServiceImpl.class);
    private final OrgUnitApi orgUnitApi;
    private final ProcessParamApi processParamApi;
    private final ProcessInstanceApi processInstanceApi;
    private final Y9ProcessAdminProperties y9ProcessAdminProperties;

    @Override
    public void saveProcessInstanceDetails(DelegateTask task, Map<String, Object> map) {
        Boolean cooperationStateSwitch = this.y9ProcessAdminProperties.getCooperationStateSwitch();
        if (cooperationStateSwitch == null || !cooperationStateSwitch.booleanValue()) {
            LOGGER.info("######################\u534f\u4f5c\u72b6\u6001\u5f00\u5173\u5df2\u5173\u95ed,\u5982\u9700\u4fdd\u5b58\u6570\u636e\u5230\u534f\u4f5c\u72b6\u6001\u8bf7\u66f4\u6539\u914d\u7f6e\u6587\u4ef6######################");
            return;
        }
        try {
            String assigneeId = task.getAssignee();
            String tenantId = (String)map.get("tenantId");
            String processSerialNumber = (String)map.get("processSerialNumber");
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
            String itemId = processParamModel.getItemId();
            String number = processParamModel.getCustomNumber();
            String systemCnName = processParamModel.getSystemCnName();
            String systemName = processParamModel.getSystemName();
            String documentTitle = processParamModel.getTitle();
            String todoTaskUrlPrefix = processParamModel.getTodoTaskUrlPrefix();
            String userId = map.get("taskSenderId").toString();
            Object assigneeName = "";
            String senderName = "";
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, assigneeId).getData();
            OrgUnit sendOrgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
            if (orgUnit != null && StringUtils.isNotBlank((CharSequence)orgUnit.getId())) {
                assigneeName = orgUnit.getName();
            }
            if (sendOrgUnit != null && StringUtils.isNotBlank((CharSequence)sendOrgUnit.getId())) {
                senderName = sendOrgUnit.getName();
            }
            String processInstanceId = task.getProcessInstanceId();
            String sponsorGuid = processParamModel.getSponsorGuid();
            if (StringUtils.isNotBlank((CharSequence)sponsorGuid) && sponsorGuid.equals(assigneeId)) {
                assigneeName = (String)assigneeName + "(\u4e3b\u529e)";
            }
            String url = todoTaskUrlPrefix + "?itemId=" + itemId + "&processInstanceId=" + processInstanceId + "&type=fromCplane";
            ProcessInstanceDetailsModel processInstanceDetails = new ProcessInstanceDetailsModel();
            processInstanceDetails.setAssigneeId(assigneeId);
            processInstanceDetails.setAssigneeName((String)assigneeName);
            processInstanceDetails.setItembox(ItemBoxTypeEnum.DOING.getValue());
            processInstanceDetails.setItemId(itemId);
            processInstanceDetails.setProcessInstanceId(processInstanceId);
            processInstanceDetails.setProcessSerialNumber(processSerialNumber);
            processInstanceDetails.setSenderId(userId);
            processInstanceDetails.setSenderName(senderName);
            processInstanceDetails.setSerialNumber(number);
            processInstanceDetails.setStartTime(task.getCreateTime());
            processInstanceDetails.setSystemCnName(systemCnName);
            processInstanceDetails.setSystemName(systemName);
            processInstanceDetails.setTaskId(task.getId());
            processInstanceDetails.setTaskName(task.getName());
            processInstanceDetails.setTitle(documentTitle);
            processInstanceDetails.setUrl(url);
            processInstanceDetails.setUserName(processParamModel.getStartorName());
            boolean b = (Boolean)this.processInstanceApi.saveProcessInstanceDetails(tenantId, processInstanceDetails).getData();
            if (b) {
                LOGGER.info("#################\u534f\u4f5c\u72b6\u6001\u4fdd\u5b58\u6210\u529f-TASK_ASSIGNED####\u4efb\u52a1id:{}{}#################", (Object)task.getAssignee(), (Object)task.getId());
            } else {
                LOGGER.error("#################\u534f\u4f5c\u72b6\u6001\u4fdd\u5b58\u5931\u8d25-TASK_ASSIGNED####\u4efb\u52a1id:{}{}#################", (Object)task.getAssignee(), (Object)task.getId());
            }
        }
        catch (Exception e) {
            LOGGER.error("#################\u4fdd\u5b58\u4e8b\u4ef6\u529e\u7406\u60c5\u51b5\u5931\u8d25:1-TASK_ASSIGNED\uff1a{} \u9519\u8bef\u4fe1\u606f\uff1a{}#################", (Object)task.getAssignee(), (Object)e.getMessage());
        }
    }

    @Override
    public void updateProcessInstanceDetails(DelegateTask taskEntityHti, Map<String, Object> map) {
        Boolean cooperationStateSwitch = this.y9ProcessAdminProperties.getCooperationStateSwitch();
        if (cooperationStateSwitch == null || !cooperationStateSwitch.booleanValue()) {
            LOGGER.info("######################\u534f\u4f5c\u72b6\u6001\u5f00\u5173\u5df2\u5173\u95ed,\u5982\u9700\u4fdd\u5b58\u6570\u636e\u5230\u534f\u4f5c\u72b6\u6001\u8bf7\u66f4\u6539\u914d\u7f6e\u6587\u4ef6######################");
            return;
        }
        try {
            String assigneeId = taskEntityHti.getAssignee() != null ? taskEntityHti.getAssignee() : "";
            String tenantId = (String)map.get("tenantId");
            boolean b = (Boolean)this.processInstanceApi.updateProcessInstanceDetails(tenantId, assigneeId, taskEntityHti.getProcessInstanceId(), taskEntityHti.getId(), ItemBoxTypeEnum.DONE.getValue(), new Date()).getData();
            if (b) {
                LOGGER.info("#################\u66f4\u65b0\u534f\u4f5c\u72b6\u6001\u6210\u529f-TASK_COMPLETED####\u4efb\u52a1id:{}{}################", (Object)taskEntityHti.getName(), (Object)taskEntityHti.getId());
            } else {
                LOGGER.error("#################\u66f4\u65b0\u534f\u4f5c\u72b6\u6001\u5931\u8d25-TASK_COMPLETED####\u4efb\u52a1id:{}{}#################", (Object)taskEntityHti.getName(), (Object)taskEntityHti.getId());
            }
        }
        catch (Exception e) {
            LOGGER.error("#################\u66f4\u65b0\u534f\u4f5c\u72b6\u6001\u5931\u8d25-TASK_COMPLETED#################");
        }
    }

    @Generated
    public ProcessInstanceDetailsServiceImpl(OrgUnitApi orgUnitApi, ProcessParamApi processParamApi, ProcessInstanceApi processInstanceApi, Y9ProcessAdminProperties y9ProcessAdminProperties) {
        this.orgUnitApi = orgUnitApi;
        this.processParamApi = processParamApi;
        this.processInstanceApi = processInstanceApi;
        this.y9ProcessAdminProperties = y9ProcessAdminProperties;
    }
}

