/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.listener;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import lombok.Generated;
import net.risesoft.api.platform.tenant.TenantApi;
import net.risesoft.configuration.MultiTenantProcessEngineConfiguration;
import net.risesoft.init.TenantDataInitializer;
import net.risesoft.model.platform.Tenant;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FlowableMultiTenantListener
implements TenantDataInitializer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableMultiTenantListener.class);
    private MultiTenantProcessEngineConfiguration multiTenantProcessEngineConfiguration;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TenantApi tenantApi;

    private void createDeployment(String tenantId) {
        try {
            Y9LoginUserHolder.setTenantId((String)tenantId);
            FlowableTenantInfoHolder.setTenantId(tenantId);
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ziyouliucheng").latestVersion().singleResult();
            if (null == processDefinition) {
                String xmlPath = Y9Context.getWebRootRealPath() + "static" + File.separator + "processXml" + File.separator + "ziyouliucheng.bpmn";
                File file = new File(xmlPath);
                FileInputStream fileInputStream = new FileInputStream(file);
                this.repositoryService.createDeployment().addInputStream("ziyouliucheng.bpmn", (InputStream)fileInputStream).deploy();
            }
        }
        catch (Exception e) {
            LOGGER.error("\u3010{}\u3011\u79df\u7528processAdmin \u521d\u59cb\u5316\u3010\u81ea\u7531\u529e\u4ef6\u3011\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)tenantId, (Object)e.getMessage());
        }
    }

    public void init(String tenantId) {
        Tenant tenant = (Tenant)this.tenantApi.getById(tenantId).getData();
        LOGGER.info("\u3010{}\u3011\u79df\u7528processAdmin \u521d\u59cb\u5316\u8868\u7ed3\u6784\u5f00\u59cb.........", (Object)tenant.getName());
        if (this.multiTenantProcessEngineConfiguration == null) {
            try {
                this.multiTenantProcessEngineConfiguration = (MultiTenantProcessEngineConfiguration)((Object)Y9Context.getBean((String)"processEngineConfiguration"));
            }
            catch (Exception e) {
                LOGGER.error("multiTenantProcessEngineConfiguration==null\uff0c\u540c\u6b65flowable\u79df\u6237\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff0c\u9000\u51fa\u3002", (Throwable)e);
                return;
            }
        }
        this.multiTenantProcessEngineConfiguration.buildProcessEngine();
        LOGGER.info("\u3010{}\u3011\u79df\u7528processAdmin \u521d\u59cb\u5316\u8868\u7ed3\u6784\u7ed3\u675f.........", (Object)tenant.getName());
        LOGGER.info("\u3010{}\u3011\u79df\u7528processAdmin \u521d\u59cb\u5316\u3010\u81ea\u7531\u529e\u4ef6\u3011\u5f00\u59cb.........", (Object)tenant.getName());
        this.createDeployment(tenantId);
        LOGGER.info("\u3010{}\u3011\u79df\u7528processAdmin \u521d\u59cb\u5316\u3010\u81ea\u7531\u529e\u4ef6\u3011\u7ed3\u675f.........", (Object)tenant.getName());
    }
}

