/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.risesoft.enums.DialectEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Y9SqlPaginationUtil {
    private static final Logger log = LoggerFactory.getLogger(Y9SqlPaginationUtil.class);
    private static String dbType;
    private static int dbVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generatePagedSql(DataSource ds, String sql, int start, int limit) throws Exception {
        String rSql = "";
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        if (dbType == null) {
            Connection connection = null;
            String microsoft = "microsoft";
            try {
                connection = ds.getConnection();
                DatabaseMetaData dbmd = connection.getMetaData();
                String databaseName = dbmd.getDatabaseProductName().toLowerCase();
                dbType = databaseName.indexOf(DialectEnum.MYSQL.getValue()) > -1 ? "mysql" : (databaseName.indexOf(DialectEnum.ORACLE.getValue()) > -1 ? "oracle" : (databaseName.indexOf(microsoft) > -1 ? "mssql" : (databaseName.indexOf(DialectEnum.KINGBASE.getValue()) > -1 ? "kingbase" : "oracle")));
                dbVersion = dbmd.getDatabaseMajorVersion();
            }
            catch (SQLException e) {
                log.error(e.getMessage());
            }
            finally {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.error(e.getMessage());
                }
            }
        }
        rSql = Y9SqlPaginationUtil.generatePagedSql(dbType, dbVersion, sql, start, limit);
        return rSql;
    }

    public static String generatePagedSql(String databaseType, int databaseVersion, String sql, int start, int limit) throws Exception {
        Object rSql = "";
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        if (DialectEnum.MYSQL.getValue().equalsIgnoreCase(databaseType)) {
            rSql = sql + " limit " + start + "," + limit;
        } else if (DialectEnum.MSSQL.getValue().equalsIgnoreCase(databaseType)) {
            int databaseVersion12 = 12;
            if (databaseVersion >= databaseVersion12) {
                String orderBy = " order by ";
                rSql = sql.toLowerCase().contains(orderBy) ? sql + " OFFSET " + start + " ROW FETCH NEXT " + limit + " rows only" : "SELECT TOP " + limit + " A.* FROM ( SELECT ROW_NUMBER() OVER (ORDER BY (select NULL)) AS RowNumber,B.* FROM ( " + sql + ") B ) A WHERE A.RowNumber > " + start;
            } else {
                rSql = "SELECT TOP " + limit + " A.* FROM ( SELECT ROW_NUMBER() OVER (ORDER BY (select NULL)) AS RowNumber,B.* FROM ( " + sql + ") B ) A WHERE A.RowNumber > " + start;
            }
        } else if (DialectEnum.ORACLE.getValue().equalsIgnoreCase(databaseType)) {
            rSql = "select * from (select mytable.*,rownum as my_rownum from (" + sql + ") mytable) where my_rownum<=" + (start + limit) + " and my_rownum>" + start;
        } else if (DialectEnum.KINGBASE.getValue().equalsIgnoreCase(databaseType)) {
            rSql = "select * from (select mytable.*,rownum as my_rownum from (" + sql + ") mytable) where my_rownum<=" + (start + limit) + " and my_rownum>" + start;
        }
        return rSql;
    }
}

