/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.ProcessParamApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.model.itemadmin.ProcessParamModel;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.service.WeiXinRemindService;
import net.risesoft.y9.configuration.Y9Properties;
import net.risesoft.y9.json.Y9JsonUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.StringUtils;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="weiXinRemindService")
public class WeiXinRemindServiceImpl
implements WeiXinRemindService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WeiXinRemindServiceImpl.class);
    private final PersonApi personManager;
    private final PositionApi positionApi;
    private final ProcessParamApi processParamManager;
    private final Y9Properties y9Conf;

    @Override
    public void weiXinRemind(DelegateTask task, Map<String, Object> map, Map<String, Object> local) {
        Boolean weiXinSwitch = this.y9Conf.getApp().getProcessAdmin().getWeiXinSwitch();
        if (weiXinSwitch == null || Boolean.FALSE.equals(weiXinSwitch)) {
            LOGGER.info("######################\u5fae\u4fe1\u63d0\u9192\u5f00\u5173\u5df2\u5173\u95ed,\u5982\u9700\u5fae\u4fe1\u63d0\u9192\u8bf7\u66f4\u6539\u914d\u7f6e\u6587\u4ef6######################");
            return;
        }
        try {
            String tenantId = (String)map.get("tenantId");
            String processSerialNumber = (String)map.get("processSerialNumber");
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamManager.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
            String documentTitle = processParamModel.getTitle();
            String itemId = processParamModel.getItemId();
            String itemName = processParamModel.getItemName();
            if (local.get("takeBack") != null || local.get("rollBack") != null) {
                return;
            }
            String assignee = task.getAssignee();
            String userId = map.get("taskSenderId").toString();
            String send = processParamModel.getSended();
            if (StringUtils.isBlank((CharSequence)send) || "false".equals(send)) {
                return;
            }
            Person person = (Person)this.personManager.get(tenantId, userId).getData();
            if (person == null || StringUtils.isBlank((CharSequence)person.getId())) {
                List list = (List)this.positionApi.listPersonsByPositionId(tenantId, assignee).getData();
                Position position = (Position)this.positionApi.get(tenantId, userId).getData();
                String url = this.y9Conf.getApp().getProcessAdmin().getWeiXinUrl();
                for (Person p : list) {
                    try {
                        HttpClient client = new HttpClient();
                        client.getParams().setParameter("http.method.response.buffer.warnlimit", (Object)0xA00000);
                        client.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
                        PostMethod method = new PostMethod();
                        method.addParameter("userId", p.getId());
                        method.addParameter("title", documentTitle);
                        method.addParameter("taskSender", position.getName());
                        method.addParameter("taskName", itemName + "-" + task.getName());
                        method.addParameter("processSerialNumber", processSerialNumber);
                        method.addParameter("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                        method.addParameter("processInstanceId", task.getProcessInstanceId());
                        method.addParameter("taskId", task.getId());
                        method.addParameter("itemId", itemId);
                        method.setPath(url);
                        int code = client.executeMethod((HttpMethod)method);
                        LOGGER.info("##########################\u5fae\u4fe1\u63a5\u53e3\u72b6\u6001\uff1a{}##########################", (Object)code);
                        if (code != 200) continue;
                        String response = new String(method.getResponseBodyAsString().getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
                        LOGGER.info("##########################\u8fd4\u56de\u72b6\u6001\uff1a{}##########################", (Object)response);
                    }
                    catch (Exception e) {
                        LOGGER.error("##########################\u5fae\u4fe1\u63d0\u9192\u65f6\u53d1\u751f\u5f02\u5e38-userId:{}#", (Object)p.getId());
                    }
                }
            } else {
                HttpClient client = new HttpClient();
                client.getParams().setParameter("http.method.response.buffer.warnlimit", (Object)0xA00000);
                client.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
                PostMethod method = new PostMethod();
                method.addParameter("userId", assignee);
                method.addParameter("title", documentTitle);
                method.addParameter("taskSender", person.getName());
                method.addParameter("taskName", itemName + "-" + task.getName());
                method.addParameter("processSerialNumber", processSerialNumber);
                method.addParameter("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                method.addParameter("processInstanceId", task.getProcessInstanceId());
                method.addParameter("taskId", task.getId());
                method.addParameter("itemId", itemId);
                String url = this.y9Conf.getApp().getProcessAdmin().getWeiXinUrl();
                method.setPath(url);
                int code = client.executeMethod((HttpMethod)method);
                LOGGER.info("##########################\u5fae\u4fe1\u63a5\u53e3\u72b6\u6001\uff1a{}##########################", (Object)code);
                if (code == 200) {
                    String response = new String(method.getResponseBodyAsString().getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
                    Map m = (Map)Y9JsonUtil.readValue((String)response, Map.class);
                    LOGGER.info("##########################\u8fd4\u56de\u72b6\u6001\uff1a{}##########################", (Object)response);
                    assert (m != null);
                    if ("false".equals(m.get("success"))) {
                        LOGGER.error("##########\u5fae\u4fe1\u63d0\u9192\u5931\u8d25-userId:{}#", (Object)assignee);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("##########################\u5fae\u4fe1\u63d0\u9192\u65f6\u53d1\u751f\u5f02\u5e38-taskId:{} \u9519\u8bef\u4fe1\u606f\uff1a{}###########################", (Object)task.getId(), (Object)e.getMessage());
        }
    }

    @Generated
    public WeiXinRemindServiceImpl(PersonApi personManager, PositionApi positionApi, ProcessParamApi processParamManager, Y9Properties y9Conf) {
        this.personManager = personManager;
        this.positionApi = positionApi;
        this.processParamManager = processParamManager;
        this.y9Conf = y9Conf;
    }
}

