/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.util.Date;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.ProcessInstanceApi;
import net.risesoft.api.itemadmin.ProcessParamApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.enums.ItemBoxTypeEnum;
import net.risesoft.model.itemadmin.ProcessInstanceDetailsModel;
import net.risesoft.model.itemadmin.ProcessParamModel;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.service.ProcessInstanceDetailsService;
import net.risesoft.service.impl.ProcessInstanceDetailsServiceImpl$AjcClosure1;
import net.risesoft.y9.configuration.Y9Properties;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.aspectj.AnnotationAsyncExecutionAspect;
import org.springframework.stereotype.Service;

@Service(value="processInstanceDetailsService")
public class ProcessInstanceDetailsServiceImpl
implements ProcessInstanceDetailsService {
    @Generated
    private static final Logger LOGGER;
    private final PersonApi personManager;
    private final PositionApi positionApi;
    private final ProcessParamApi processParamManager;
    private final ProcessInstanceApi processInstanceApi;
    private final Y9Properties y9Conf;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public void saveProcessInstanceDetails(DelegateTask task, Map<String, Object> map) {
        Boolean cooperationStateSwitch = this.y9Conf.getApp().getProcessAdmin().getCooperationStateSwitch();
        if (cooperationStateSwitch == null || !cooperationStateSwitch.booleanValue()) {
            LOGGER.info("######################\u534f\u4f5c\u72b6\u6001\u5f00\u5173\u5df2\u5173\u95ed,\u5982\u9700\u4fdd\u5b58\u6570\u636e\u5230\u534f\u4f5c\u72b6\u6001\u8bf7\u66f4\u6539\u914d\u7f6e\u6587\u4ef6######################");
            return;
        }
        try {
            String senderName;
            Object assigneeName;
            String assigneeId = task.getAssignee();
            String tenantId = (String)map.get("tenantId");
            String processSerialNumber = (String)map.get("processSerialNumber");
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamManager.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
            String itemId = processParamModel.getItemId();
            String number = processParamModel.getCustomNumber();
            String systemCnName = processParamModel.getSystemCnName();
            String systemName = processParamModel.getSystemName();
            String documentTitle = processParamModel.getTitle();
            String todoTaskUrlPrefix = processParamModel.getTodoTaskUrlPrefix();
            String userId = map.get("taskSenderId").toString();
            Person person = (Person)this.personManager.get(tenantId, assigneeId).getData();
            if (person == null || StringUtils.isBlank((CharSequence)person.getId())) {
                Position position = (Position)this.positionApi.get(tenantId, assigneeId).getData();
                assigneeName = position.getName();
                position = (Position)this.positionApi.get(tenantId, userId).getData();
                senderName = position.getName();
            } else {
                assigneeName = person.getName();
                person = (Person)this.personManager.get(tenantId, userId).getData();
                senderName = person.getName();
            }
            String processInstanceId = task.getProcessInstanceId();
            String sponsorGuid = processParamModel.getSponsorGuid();
            if (StringUtils.isNotBlank((CharSequence)sponsorGuid) && sponsorGuid.equals(assigneeId)) {
                assigneeName = (String)assigneeName + "(\u4e3b\u529e)";
            }
            String url = todoTaskUrlPrefix + "?itemId=" + itemId + "&processInstanceId=" + processInstanceId + "&type=fromCplane";
            ProcessInstanceDetailsModel processInstanceDetails = new ProcessInstanceDetailsModel();
            processInstanceDetails.setAssigneeId(assigneeId);
            processInstanceDetails.setAssigneeName((String)assigneeName);
            processInstanceDetails.setItembox(ItemBoxTypeEnum.DOING.getValue());
            processInstanceDetails.setItemId(itemId);
            processInstanceDetails.setProcessInstanceId(processInstanceId);
            processInstanceDetails.setProcessSerialNumber(processSerialNumber);
            processInstanceDetails.setSenderId(userId);
            processInstanceDetails.setSenderName(senderName);
            processInstanceDetails.setSerialNumber(number);
            processInstanceDetails.setStartTime(task.getCreateTime());
            processInstanceDetails.setSystemCnName(systemCnName);
            processInstanceDetails.setSystemName(systemName);
            processInstanceDetails.setTaskId(task.getId());
            processInstanceDetails.setTaskName(task.getName());
            processInstanceDetails.setTitle(documentTitle);
            processInstanceDetails.setUrl(url);
            processInstanceDetails.setUserName(processParamModel.getStartorName());
            boolean b = (Boolean)this.processInstanceApi.saveProcessInstanceDetails(tenantId, processInstanceDetails).getData();
            if (b) {
                LOGGER.info("#################\u534f\u4f5c\u72b6\u6001\u4fdd\u5b58\u6210\u529f-TASK_ASSIGNED####\u4efb\u52a1id:{}{}#################", (Object)task.getAssignee(), (Object)task.getId());
            } else {
                LOGGER.error("#################\u534f\u4f5c\u72b6\u6001\u4fdd\u5b58\u5931\u8d25-TASK_ASSIGNED####\u4efb\u52a1id:{}{}#################", (Object)task.getAssignee(), (Object)task.getId());
            }
        }
        catch (Exception e) {
            LOGGER.error("#################\u4fdd\u5b58\u4e8b\u4ef6\u529e\u7406\u60c5\u51b5\u5931\u8d25:1-TASK_ASSIGNED\uff1a{} \u9519\u8bef\u4fe1\u606f\uff1a{}#################", (Object)task.getAssignee(), (Object)e.getMessage());
        }
    }

    @Override
    @Async
    public void updateProcessInstanceDetails(DelegateTask taskEntityHti, Map<String, Object> map) {
        DelegateTask delegateTask = taskEntityHti;
        Map<String, Object> map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)delegateTask, map2);
        Object[] objectArray = new Object[]{this, delegateTask, map2, joinPoint};
        AnnotationAsyncExecutionAspect.aspectOf().ajc$around$org_springframework_scheduling_aspectj_AbstractAsyncExecutionAspect$1$6c004c3e((AroundClosure)new ProcessInstanceDetailsServiceImpl$AjcClosure1(objectArray), ajc$tjp_0, joinPoint);
    }

    @Generated
    public ProcessInstanceDetailsServiceImpl(PersonApi personManager, PositionApi positionApi, ProcessParamApi processParamManager, ProcessInstanceApi processInstanceApi, Y9Properties y9Conf) {
        this.personManager = personManager;
        this.positionApi = positionApi;
        this.processParamManager = processParamManager;
        this.processInstanceApi = processInstanceApi;
        this.y9Conf = y9Conf;
    }

    static {
        ProcessInstanceDetailsServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ProcessInstanceDetailsServiceImpl.class);
    }

    static final /* synthetic */ void updateProcessInstanceDetails_aroundBody0(ProcessInstanceDetailsServiceImpl ajc$this, DelegateTask taskEntityHti, Map map, JoinPoint joinPoint) {
        Boolean cooperationStateSwitch = ajc$this.y9Conf.getApp().getProcessAdmin().getCooperationStateSwitch();
        if (cooperationStateSwitch == null || !cooperationStateSwitch.booleanValue()) {
            LOGGER.info("######################\u534f\u4f5c\u72b6\u6001\u5f00\u5173\u5df2\u5173\u95ed,\u5982\u9700\u4fdd\u5b58\u6570\u636e\u5230\u534f\u4f5c\u72b6\u6001\u8bf7\u66f4\u6539\u914d\u7f6e\u6587\u4ef6######################");
            return;
        }
        try {
            String assigneeId = taskEntityHti.getAssignee() != null ? taskEntityHti.getAssignee() : "";
            String tenantId = (String)map.get("tenantId");
            boolean b = (Boolean)ajc$this.processInstanceApi.updateProcessInstanceDetails(tenantId, assigneeId, taskEntityHti.getProcessInstanceId(), taskEntityHti.getId(), ItemBoxTypeEnum.DONE.getValue(), new Date()).getData();
            if (b) {
                LOGGER.info("#################\u66f4\u65b0\u534f\u4f5c\u72b6\u6001\u6210\u529f-TASK_COMPLETED####\u4efb\u52a1id:{}{}################", (Object)taskEntityHti.getName(), (Object)taskEntityHti.getId());
            } else {
                LOGGER.error("#################\u66f4\u65b0\u534f\u4f5c\u72b6\u6001\u5931\u8d25-TASK_COMPLETED####\u4efb\u52a1id:{}{}#################", (Object)taskEntityHti.getName(), (Object)taskEntityHti.getId());
            }
        }
        catch (Exception e) {
            LOGGER.error("#################\u66f4\u65b0\u534f\u4f5c\u72b6\u6001\u5931\u8d25-TASK_COMPLETED#################");
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProcessInstanceDetailsServiceImpl.java", ProcessInstanceDetailsServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateProcessInstanceDetails", "net.risesoft.service.impl.ProcessInstanceDetailsServiceImpl", "org.flowable.task.service.delegate.DelegateTask:java.util.Map", "taskEntityHti:map", "", "void"), 125);
    }
}

