/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import lombok.Generated;
import net.risesoft.api.itemadmin.ActRuDetailApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.model.itemadmin.ActRuDetailModel;
import net.risesoft.model.platform.Position;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="task4ActRuDetaillService")
public class Task4ActRuDetaillService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Task4ActRuDetaillService.class);
    private final ActRuDetailApi actRuDetailApi;
    private final PositionApi positionApi;
    @Resource(name="jdbcTemplate4Tenant")
    private JdbcTemplate jdbcTemplate;

    public Task4ActRuDetaillService(ActRuDetailApi actRuDetailApi, PositionApi positionApi) {
        this.actRuDetailApi = actRuDetailApi;
        this.positionApi = positionApi;
    }

    public void saveOrUpdate(DelegateTask taskEntity, int status) {
        try {
            String tenantId = (String)taskEntity.getVariable("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                Y9LoginUserHolder.setTenantId((String)tenantId);
                FlowableTenantInfoHolder.setTenantId(tenantId);
                String sql0 = "SELECT SUBSTRING(P.START_TIME_,1,19) as START_TIME_ FROM  ACT_HI_PROCINST P WHERE P.PROC_INST_ID_ = '" + taskEntity.getProcessInstanceId() + "'";
                List list = this.jdbcTemplate.queryForList(sql0);
                String processSerialNumber = (String)taskEntity.getVariable("processSerialNumber");
                String assignee = taskEntity.getAssignee();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Position position = (Position)this.positionApi.get(tenantId, assignee).getData();
                ActRuDetailModel actRuDetailModel = new ActRuDetailModel();
                actRuDetailModel.setCreateTime(taskEntity.getCreateTime());
                actRuDetailModel.setAssignee(assignee);
                actRuDetailModel.setAssigneeName(position.getName());
                actRuDetailModel.setDeptId(position.getParentId());
                actRuDetailModel.setLastTime(new Date());
                actRuDetailModel.setProcessDefinitionKey(taskEntity.getProcessDefinitionId().split(":")[0]);
                actRuDetailModel.setProcessInstanceId(taskEntity.getProcessInstanceId());
                actRuDetailModel.setProcessSerialNumber(processSerialNumber);
                actRuDetailModel.setStatus(Integer.valueOf(status));
                actRuDetailModel.setTaskId(taskEntity.getId());
                actRuDetailModel.setStarted(true);
                actRuDetailModel.setEnded(false);
                actRuDetailModel.setStartTime(list.isEmpty() ? sdf.format(new Date()) : ((Map)list.get(0)).get("START_TIME_").toString());
                this.actRuDetailApi.saveOrUpdate(tenantId, actRuDetailModel);
                String owner = taskEntity.getOwner();
                if (StringUtils.isNotBlank((CharSequence)owner)) {
                    this.actRuDetailApi.removeByProcessSerialNumberAndAssignee(tenantId, processSerialNumber, owner);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("##########################Task4ActRuDetaillService:saveOrUpdate\u4fdd\u5b58\u6d41\u7a0b\u6d41\u8f6c\u4fe1\u606f\u5931\u8d25-taskId:{}##########################", (Object)taskEntity.getId(), (Object)e);
        }
    }

    public void saveOrUpdate4DoSign(DelegateTask taskEntity) {
        try {
            String tenantId = (String)taskEntity.getVariable("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                Y9LoginUserHolder.setTenantId((String)tenantId);
                FlowableTenantInfoHolder.setTenantId(tenantId);
                String sql0 = "SELECT SUBSTRING(P.START_TIME_,1,19) as START_TIME_ FROM  ACT_HI_PROCINST P WHERE P.PROC_INST_ID_ = '" + taskEntity.getProcessInstanceId() + "'";
                List list = this.jdbcTemplate.queryForList(sql0);
                String assignee = taskEntity.getAssignee();
                String processSerialNumber = (String)taskEntity.getVariable("processSerialNumber");
                Set linkSet = taskEntity.getCandidates();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (IdentityLink link : linkSet) {
                    String userId = link.getUserId();
                    Position position = (Position)this.positionApi.get(tenantId, userId).getData();
                    ActRuDetailModel actRuDetailModel = new ActRuDetailModel();
                    actRuDetailModel.setCreateTime(sdf.parse(sdf.format(taskEntity.getCreateTime())));
                    actRuDetailModel.setAssignee(userId);
                    actRuDetailModel.setAssigneeName(position.getName());
                    actRuDetailModel.setDeptId(position.getParentId());
                    actRuDetailModel.setLastTime(new Date());
                    actRuDetailModel.setProcessDefinitionKey(taskEntity.getProcessDefinitionId().split(":")[0]);
                    actRuDetailModel.setProcessInstanceId(taskEntity.getProcessInstanceId());
                    actRuDetailModel.setProcessSerialNumber(processSerialNumber);
                    actRuDetailModel.setTaskId(taskEntity.getId());
                    actRuDetailModel.setStarted(true);
                    actRuDetailModel.setEnded(false);
                    actRuDetailModel.setStartTime(((Map)list.get(0)).get("START_TIME_").toString());
                    if (assignee.equals(userId)) {
                        actRuDetailModel.setStatus(Integer.valueOf(0));
                    } else {
                        actRuDetailModel.setStatus(Integer.valueOf(1));
                    }
                    this.actRuDetailApi.saveOrUpdate(tenantId, actRuDetailModel);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("##########################saveOrUpdate4DoSign\u62a2\u5360\u5f0f\u8282\u70b9-\u4fdd\u5b58\u6d41\u7a0b\u6d41\u8f6c\u4fe1\u606f\u5931\u8d25-taskId:{}##########################", (Object)taskEntity.getId(), (Object)e);
        }
    }

    public void saveOrUpdate4Reposition(DelegateTask taskEntity) {
        try {
            String tenantId = (String)taskEntity.getVariable("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                Y9LoginUserHolder.setTenantId((String)tenantId);
                FlowableTenantInfoHolder.setTenantId(tenantId);
                String sql0 = "SELECT SUBSTRING(P.START_TIME_,1,19) as START_TIME_ FROM  ACT_HI_PROCINST P WHERE P.PROC_INST_ID_ = '" + taskEntity.getProcessInstanceId() + "'";
                List list = this.jdbcTemplate.queryForList(sql0);
                String processSerialNumber = (String)taskEntity.getVariable("processSerialNumber");
                Set linkSet = taskEntity.getCandidates();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (IdentityLink link : linkSet) {
                    String userId = link.getUserId();
                    Position position = (Position)this.positionApi.get(tenantId, userId).getData();
                    ActRuDetailModel actRuDetailModel = new ActRuDetailModel();
                    actRuDetailModel.setCreateTime(sdf.parse(sdf.format(taskEntity.getCreateTime())));
                    actRuDetailModel.setAssignee(userId);
                    actRuDetailModel.setAssigneeName(position.getName());
                    actRuDetailModel.setDeptId(position.getParentId());
                    actRuDetailModel.setLastTime(new Date());
                    actRuDetailModel.setProcessDefinitionKey(taskEntity.getProcessDefinitionId().split(":")[0]);
                    actRuDetailModel.setProcessInstanceId(taskEntity.getProcessInstanceId());
                    actRuDetailModel.setProcessSerialNumber(processSerialNumber);
                    actRuDetailModel.setTaskId(taskEntity.getId());
                    actRuDetailModel.setStarted(true);
                    actRuDetailModel.setEnded(false);
                    actRuDetailModel.setStatus(Integer.valueOf(1));
                    actRuDetailModel.setStartTime(((Map)list.get(0)).get("START_TIME_").toString());
                    this.actRuDetailApi.saveOrUpdate(tenantId, actRuDetailModel);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("##########################saveOrUpdate4Reposition\u62a2\u5360\u5f0f\u8282\u70b9-\u4fdd\u5b58\u6d41\u7a0b\u6d41\u8f6c\u4fe1\u606f\u5931\u8d25-taskId:{}##########################", (Object)taskEntity.getId());
        }
    }

    public void saveOrUpdate4Sign(DelegateTask taskEntity, int status) {
        try {
            String tenantId = (String)taskEntity.getVariable("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                Y9LoginUserHolder.setTenantId((String)tenantId);
                FlowableTenantInfoHolder.setTenantId(tenantId);
                String sql0 = "SELECT SUBSTRING(P.START_TIME_,1,19) as START_TIME_ FROM  ACT_HI_PROCINST P WHERE P.PROC_INST_ID_ = '" + taskEntity.getProcessInstanceId() + "'";
                List list = this.jdbcTemplate.queryForList(sql0);
                String processSerialNumber = (String)taskEntity.getVariable("processSerialNumber");
                Set linkSet = taskEntity.getCandidates();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (IdentityLink link : linkSet) {
                    String userId = link.getUserId();
                    Position position = (Position)this.positionApi.get(tenantId, userId).getData();
                    ActRuDetailModel actRuDetailModel = new ActRuDetailModel();
                    actRuDetailModel.setCreateTime(sdf.parse(sdf.format(taskEntity.getCreateTime())));
                    actRuDetailModel.setAssignee(userId);
                    actRuDetailModel.setAssigneeName(position.getName());
                    actRuDetailModel.setDeptId(position.getParentId());
                    actRuDetailModel.setLastTime(new Date());
                    actRuDetailModel.setProcessDefinitionKey(taskEntity.getProcessDefinitionId().split(":")[0]);
                    actRuDetailModel.setProcessInstanceId(taskEntity.getProcessInstanceId());
                    actRuDetailModel.setProcessSerialNumber(processSerialNumber);
                    actRuDetailModel.setStatus(Integer.valueOf(status));
                    actRuDetailModel.setTaskId(taskEntity.getId());
                    actRuDetailModel.setStarted(true);
                    actRuDetailModel.setEnded(false);
                    actRuDetailModel.setStartTime(((Map)list.get(0)).get("START_TIME_").toString());
                    this.actRuDetailApi.saveOrUpdate(tenantId, actRuDetailModel);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("##########################saveOrUpdate4Sign\u62a2\u5360\u5f0f\u8282\u70b9-\u4fdd\u5b58\u6d41\u7a0b\u6d41\u8f6c\u4fe1\u606f\u5931\u8d25-taskId:{}##########################", (Object)taskEntity.getId());
        }
    }
}

