/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.ProcessParamApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.model.itemadmin.ProcessParamModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9Util;
import org.apache.commons.lang3.StringUtils;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="setDeptIdUtilService")
public class SetDeptIdUtilService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SetDeptIdUtilService.class);
    private final ProcessParamApi processParamManager;
    private final PersonApi personManager;
    private final PositionApi positionApi;
    private final OrgUnitApi orgUnitManager;

    public void setDeptId(DelegateTask taskEntity, Map<String, Object> map) {
        try {
            String assignee = taskEntity.getAssignee();
            String processSerialNumber = (String)map.get("processSerialNumber");
            String tenantId = (String)map.get("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                String oldBureauId1;
                String oldDeptId1;
                OrgUnit orgUnit;
                OrgUnit bureau;
                Y9LoginUserHolder.setTenantId((String)tenantId);
                Person person = (Person)this.personManager.get(tenantId, assignee).getData();
                if (person == null || StringUtils.isBlank((CharSequence)person.getId())) {
                    Position position = (Position)this.positionApi.get(tenantId, assignee).getData();
                    bureau = (OrgUnit)this.orgUnitManager.getBureau(tenantId, position.getParentId()).getData();
                    orgUnit = (OrgUnit)this.orgUnitManager.getOrgUnit(tenantId, position.getParentId()).getData();
                } else {
                    bureau = (OrgUnit)this.orgUnitManager.getBureau(tenantId, person.getId()).getData();
                    orgUnit = (OrgUnit)this.orgUnitManager.getOrgUnit(tenantId, person.getParentId()).getData();
                }
                ProcessParamModel processParamModel = (ProcessParamModel)this.processParamManager.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
                String oldDeptId = StringUtils.isBlank((CharSequence)processParamModel.getDeptIds()) ? "" : processParamModel.getDeptIds();
                String string = oldDeptId1 = StringUtils.isBlank((CharSequence)processParamModel.getDeptIds()) ? "" : processParamModel.getDeptIds();
                if (!oldDeptId.contains(orgUnit.getId())) {
                    oldDeptId = Y9Util.genCustomStr((String)oldDeptId, (String)orgUnit.getId());
                }
                String oldBureauId = StringUtils.isBlank((CharSequence)processParamModel.getBureauIds()) ? "" : processParamModel.getBureauIds();
                String string2 = oldBureauId1 = StringUtils.isBlank((CharSequence)processParamModel.getBureauIds()) ? "" : processParamModel.getBureauIds();
                if (bureau != null && !oldBureauId.contains(bureau.getId())) {
                    oldBureauId = Y9Util.genCustomStr((String)oldBureauId, (String)bureau.getId());
                }
                if (!oldBureauId.equals(oldBureauId1)) {
                    processParamModel.setBureauIds(oldBureauId);
                    processParamModel.setDeptIds(oldDeptId);
                    processParamModel.setProcessInstanceId(taskEntity.getProcessInstanceId());
                    this.processParamManager.saveOrUpdate(tenantId, processParamModel);
                } else if (!oldDeptId.equals(oldDeptId1)) {
                    processParamModel.setDeptIds(oldDeptId);
                    processParamModel.setProcessInstanceId(taskEntity.getProcessInstanceId());
                    this.processParamManager.saveOrUpdate(tenantId, processParamModel);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("##########################\u4fdd\u5b58\u79d1\u5ba4id\u5931\u8d25-taskId:{}##########################", (Object)taskEntity.getId(), (Object)e);
        }
    }

    @Generated
    public SetDeptIdUtilService(ProcessParamApi processParamManager, PersonApi personManager, PositionApi positionApi, OrgUnitApi orgUnitManager) {
        this.processParamManager = processParamManager;
        this.personManager = personManager;
        this.positionApi = positionApi;
        this.orgUnitManager = orgUnitManager;
    }
}

