/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.configuration;

import com.alibaba.druid.pool.DruidDataSource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import lombok.Generated;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.configuration.Y9Properties;
import net.risesoft.y9.util.base64.Y9Base64Util;
import org.flowable.common.engine.impl.cfg.multitenant.TenantInfoHolder;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.impl.cfg.multitenant.MultiSchemaMultiTenantProcessEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.lookup.DataSourceLookupFailureException;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.stereotype.Component;

@Component
public class MultiTenantProcessEngineConfiguration
extends MultiSchemaMultiTenantProcessEngineConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiTenantProcessEngineConfiguration.class);
    public static final String SYSTEM_ID = "11111111-1111-1111-1111-111111111100";
    private final JndiDataSourceLookup jndiDataSourceLookup = new JndiDataSourceLookup();
    @Resource(name="jdbcTemplate4Public")
    private JdbcTemplate jdbcTemplate4Public;
    @Resource(name="y9FlowableDS")
    private DruidDataSource defaultDataSource;
    @Autowired
    private Y9Properties y9Config;

    private static TenantInfoHolder getFlowableTenantInfoHolder() {
        FlowableTenantInfoHolder flowableTenantInfoHolder = new FlowableTenantInfoHolder();
        flowableTenantInfoHolder.addTenant(null);
        return flowableTenantInfoHolder;
    }

    public MultiTenantProcessEngineConfiguration() {
        super(MultiTenantProcessEngineConfiguration.getFlowableTenantInfoHolder());
    }

    public MultiTenantProcessEngineConfiguration(TenantInfoHolder tenantInfoHolder) {
        super(tenantInfoHolder);
    }

    public ProcessEngine buildProcessEngine() {
        this.createSystem(this.y9Config.getApp().getProcessAdmin().getSystemName());
        this.createTenantSystem(this.y9Config.getApp().getProcessAdmin().getSystemName());
        LOGGER.info("start registerTenant");
        this.registerTenant("", (DataSource)this.defaultDataSource);
        ProcessEngine processEngine = super.buildProcessEngine();
        List systems = this.jdbcTemplate4Public.queryForList("SELECT ID FROM Y9_COMMON_SYSTEM T WHERE T.NAME=?", new Object[]{this.y9Config.getApp().getProcessAdmin().getSystemName()});
        if (!systems.isEmpty()) {
            Map map = (Map)systems.get(0);
            String systemId = (String)map.get("ID");
            List tenantSystems = this.jdbcTemplate4Public.queryForList("SELECT TENANT_ID, TENANT_DATA_SOURCE FROM Y9_COMMON_TENANT_SYSTEM T WHERE T.SYSTEM_ID = ?", new Object[]{systemId});
            if (tenantSystems.isEmpty()) {
                this.createDefaultTenantDataSource();
            } else {
                boolean isCreateDefaultTenantDataSource = false;
                for (Map tenantSystem : tenantSystems) {
                    String tenantId = (String)tenantSystem.get("TENANT_ID");
                    String dataSourceId = (String)tenantSystem.get("TENANT_DATA_SOURCE");
                    List list3 = this.jdbcTemplate4Public.queryForList("select * from Y9_COMMON_DATASOURCE t where t.id = ?", new Object[]{dataSourceId});
                    if (list3.isEmpty()) continue;
                    this.registerTenant(tenantId, (Map)list3.get(0));
                    if (!tenantId.equals("11111111-1111-1111-1111-111111111113")) continue;
                    isCreateDefaultTenantDataSource = true;
                }
                if (!isCreateDefaultTenantDataSource) {
                    this.createDefaultTenantDataSource();
                }
            }
        } else {
            this.createDefaultTenantDataSource();
        }
        return processEngine;
    }

    private void createDefaultTenantDataSource() {
        List defaultTenant = this.jdbcTemplate4Public.queryForList("SELECT ID, DEFAULT_DATA_SOURCE_ID FROM Y9_COMMON_TENANT WHERE ID=?", new Object[]{"11111111-1111-1111-1111-111111111113"});
        List defaultDataSource = this.jdbcTemplate4Public.queryForList("SELECT * FROM Y9_COMMON_DATASOURCE T WHERE T.ID = ?", new Object[]{"11111111-1111-1111-1111-111111111114"});
        if (!defaultTenant.isEmpty() && !defaultDataSource.isEmpty()) {
            String defaultTenantId = ((Map)defaultTenant.get(0)).get("ID").toString();
            this.registerTenant(defaultTenantId, (Map)defaultDataSource.get(0));
        }
    }

    private void createSystem(String systemName) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String sql = "select * from y9_common_system where NAME = '" + systemName + "'";
            List list = this.jdbcTemplate4Public.queryForList(sql);
            if (list.isEmpty()) {
                sql = "INSERT INTO y9_common_system (ID, CONTEXT_PATH, NAME, CN_NAME, TAB_INDEX,ENABLED,AUTO_INIT,CREATE_TIME) VALUES ('11111111-1111-1111-1111-111111111100', 'processAdmin', '" + systemName + "', '\u6d41\u7a0b\u7ba1\u7406', 100,1,1,'" + sdf.format(new Date()) + "')";
                this.jdbcTemplate4Public.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createTenantSystem(String systemName) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Object sql = "select * from y9_common_system where NAME = '" + systemName + "'";
            List list = this.jdbcTemplate4Public.queryForList((String)sql);
            if (list.size() == 1) {
                Map smap = (Map)list.get(0);
                sql = "select * from Y9_COMMON_TENANT where TENANT_TYPE = 3";
                List tlist = this.jdbcTemplate4Public.queryForList((String)sql);
                for (Map map : tlist) {
                    sql = "select * from y9_common_tenant_system where TENANT_ID = '" + map.get("ID").toString() + "' and SYSTEM_ID = '" + smap.get("ID").toString() + "'";
                    List qlist = this.jdbcTemplate4Public.queryForList((String)sql);
                    if (!qlist.isEmpty()) continue;
                    long id = System.currentTimeMillis();
                    String sql1 = "INSERT INTO y9_common_tenant_system (ID, SYSTEM_ID, TENANT_ID, TENANT_DATA_SOURCE, CREATE_TIME) VALUES ('" + id + "', '" + smap.get("ID").toString() + "', '" + map.get("ID").toString() + "', '" + map.get("DEFAULT_DATA_SOURCE_ID").toString() + "','" + sdf.format(new Date()) + "')";
                    this.jdbcTemplate4Public.execute(sql1);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("createTenantSystem error {}", (Object)e.getMessage());
        }
    }

    private void registerTenant(String tenantId, Map<String, Object> dsMap) {
        int type = Integer.parseInt(dsMap.get("TYPE").toString());
        String jndiName = (String)dsMap.get("JNDI_NAME");
        if (type == 1) {
            try {
                DruidDataSource dataSource = (DruidDataSource)this.jndiDataSourceLookup.getDataSource(jndiName);
                this.registerTenant(tenantId, (DataSource)dataSource);
            }
            catch (DataSourceLookupFailureException e) {
                this.logger.error(e.getMessage());
            }
        } else {
            String url = (String)dsMap.get("URL");
            String username = (String)dsMap.get("USERNAME");
            String password = (String)dsMap.get("PASSWORD");
            String driver = dsMap.get("DRIVER") != null ? (String)dsMap.get("DRIVER") : "";
            password = Y9Base64Util.decode((String)password);
            int initialSize = Integer.parseInt(dsMap.get("INITIAL_SIZE").toString());
            int maxActive = Integer.parseInt(dsMap.get("MAX_ACTIVE").toString());
            int minIdle = Integer.parseInt(dsMap.get("MIN_IDLE").toString());
            DruidDataSource ds = new DruidDataSource();
            ds.setTestOnBorrow(true);
            ds.setTestOnReturn(true);
            ds.setTestWhileIdle(true);
            ds.setInitialSize(initialSize);
            ds.setMaxActive(maxActive);
            ds.setMinIdle(minIdle);
            ds.setValidationQuery("SELECT 1 FROM DUAL");
            ds.setUrl(url);
            ds.setUsername(username);
            ds.setPassword(password);
            ds.setTimeBetweenConnectErrorMillis(60000L);
            if (!"".equals(driver)) {
                ds.setDriverClassName(driver);
            }
            this.registerTenant(tenantId, (DataSource)ds);
        }
    }
}

