/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.command;

import java.util.Date;
import java.util.List;
import java.util.Map;
import net.risesoft.model.user.UserInfo;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.identitylink.service.HistoricIdentityLinkService;
import org.flowable.identitylink.service.IdentityLinkService;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;

public class RecoveryTodoCommand
implements Command<Void> {
    protected HistoricTaskInstance hisTask;
    protected Map<String, Object> pVarMap;
    protected Map<String, Object> tVarMap;

    public RecoveryTodoCommand(HistoricTaskInstance hisTask, Map<String, Object> pVarMap, Map<String, Object> tVarMap) {
        this.hisTask = hisTask;
        this.pVarMap = pVarMap;
        this.tVarMap = tVarMap;
    }

    public Void execute(CommandContext commandContext) {
        TaskService taskService = CommandContextUtil.getTaskService();
        HistoricIdentityLinkService historicIdentityLinkService = CommandContextUtil.getHistoricIdentityLinkService();
        IdentityLinkService identityLinkService = CommandContextUtil.getIdentityLinkService();
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = CommandContextUtil.getHistoricProcessInstanceEntityManager();
        UserInfo userInfo = Y9LoginUserHolder.getUserInfo();
        String userId = userInfo.getPersonId();
        String processInstanceId = this.hisTask.getProcessInstanceId();
        String taskId = this.hisTask.getId();
        String assignee = this.hisTask.getAssignee();
        TaskEntityImpl taskEntity = new TaskEntityImpl();
        taskEntity.setId(taskId);
        taskEntity.setRevision(1);
        taskEntity.setExecutionId(this.hisTask.getExecutionId());
        taskEntity.setProcessInstanceId(this.hisTask.getProcessInstanceId());
        taskEntity.setProcessDefinitionId(this.hisTask.getProcessDefinitionId());
        taskEntity.setName(this.hisTask.getName());
        taskEntity.setTaskDefinitionKey(this.hisTask.getTaskDefinitionKey());
        taskEntity.setAssignee(userId);
        taskEntity.setPriority(this.hisTask.getPriority());
        taskEntity.setCreateTime(new Date());
        taskEntity.setSuspensionState(1);
        taskEntity.setCountEnabled(true);
        taskEntity.setCategory(this.hisTask.getCategory());
        taskEntity.setVariableCount(0);
        taskEntity.setIdentityLinkCount(this.hisTask.getIdentityLinks().size());
        taskEntity.setSubTaskCount(0);
        if (!assignee.equals(userId) || StringUtils.isNotBlank((CharSequence)this.hisTask.getOwner())) {
            if (StringUtils.isNotBlank((CharSequence)this.hisTask.getOwner())) {
                taskEntity.setOwner(this.hisTask.getOwner());
            } else {
                taskEntity.setOwner(assignee);
            }
        }
        taskService.insertTask((TaskEntity)taskEntity, true);
        taskEntity.setVariables(this.pVarMap);
        taskEntity.setVariablesLocal(this.tVarMap);
        taskService.updateTask((TaskEntity)taskEntity, false);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        processEngineConfiguration.getListenerNotificationHelper().executeTaskListeners((TaskEntity)taskEntity, "create");
        HistoricProcessInstanceEntity historicProcessInstanceEntity = (HistoricProcessInstanceEntity)historicProcessInstanceEntityManager.findById(processInstanceId);
        if (null != historicProcessInstanceEntity) {
            historicProcessInstanceEntity.setEndTime(null);
            historicProcessInstanceEntity.setDurationInMillis(null);
            historicProcessInstanceEntity.setEndActivityId(null);
            historicProcessInstanceEntity.setDeleteReason(null);
            historicProcessInstanceEntityManager.update((Entity)historicProcessInstanceEntity);
        }
        List hilEntityList4P = historicIdentityLinkService.findHistoricIdentityLinksByProcessInstanceId(processInstanceId);
        for (HistoricIdentityLinkEntity hilEntity : hilEntityList4P) {
            identityLinkService.createProcessInstanceIdentityLink(processInstanceId, userId, null, hilEntity.getType());
        }
        List hilEntityList4T = historicIdentityLinkService.findHistoricIdentityLinksByTaskId(taskId);
        for (HistoricIdentityLinkEntity hilEntity : hilEntityList4T) {
            identityLinkService.createTaskIdentityLink(taskId, userId, null, hilEntity.getType());
        }
        return null;
    }
}

