/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.command;

import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class JumpSubProcessCommand
implements Command<Void> {
    protected String taskId;
    protected String targetNodeId;
    protected Map<String, Object> vars;
    protected String positionId;
    protected List<String> users;

    public JumpSubProcessCommand(String taskId, String positionId, Map<String, Object> vars, String targetNodeId, List<String> users) {
        this.taskId = taskId;
        this.targetNodeId = targetNodeId;
        this.vars = vars;
        this.positionId = positionId;
        this.users = users;
    }

    public Void execute(CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        TaskService taskService = CommandContextUtil.getTaskService();
        TaskEntity parentTask = taskService.getTask(this.taskId);
        ExecutionEntity parentExecutionEntity = (ExecutionEntity)executionEntityManager.findById(parentTask.getExecutionId());
        ExecutionEntity childExecution = executionEntityManager.createChildExecution(parentExecutionEntity);
        if (this.users.size() == 1) {
            this.vars.put("user", this.users.get(0));
        }
        this.vars.put("users", this.users);
        childExecution.setVariables(this.vars);
        Process process = ProcessDefinitionUtil.getProcess((String)parentExecutionEntity.getProcessDefinitionId());
        FlowElement targetFlowElement = process.getFlowElement(this.targetNodeId);
        FlowableEngineAgenda flowableEngineAgenda = CommandContextUtil.getAgenda();
        childExecution.setCurrentFlowElement(targetFlowElement);
        flowableEngineAgenda.planContinueProcessInCompensation(childExecution);
        return null;
    }
}

