/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.command;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.risesoft.model.user.UserInfo;
import net.risesoft.y9.Y9LoginUserHolder;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.identitylink.service.IdentityLinkService;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.VariableService;

public class JumpCommand
implements Command<Void> {
    protected String taskId;
    protected String targetNodeId;
    protected List<String> users;
    protected String reason;

    public JumpCommand(String taskId, String targetNodeId, List<String> users, String reason) {
        this.taskId = taskId;
        this.targetNodeId = targetNodeId;
        this.users = users;
        this.reason = reason;
    }

    public Void execute(CommandContext commandContext) {
        String userId;
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        TaskService taskService = CommandContextUtil.getTaskService();
        IdentityLinkService identityLinkService = CommandContextUtil.getIdentityLinkService();
        VariableService variableService = CommandContextUtil.getVariableService();
        TaskEntity taskEntity = taskService.getTask(this.taskId);
        String executionId = taskEntity.getExecutionId();
        ExecutionEntity executionEntity = (ExecutionEntity)executionEntityManager.findById(executionId);
        Process process = ProcessDefinitionUtil.getProcess((String)executionEntity.getProcessDefinitionId());
        Activity flowElement = (Activity)process.getFlowElement(taskEntity.getTaskDefinitionKey());
        Object currentBehavior = flowElement.getBehavior();
        if (currentBehavior instanceof MultiInstanceActivityBehavior) {
            ExecutionEntity parentExecutionEntity = executionEntity.getParent();
            executionEntityManager.deleteChildExecutions(parentExecutionEntity, this.reason, false);
        } else {
            identityLinkService.deleteIdentityLinksByTaskId(this.taskId);
            variableService.deleteVariablesByExecutionId(executionId);
            taskService.deleteTask(taskEntity, true);
            CommandContextUtil.getHistoryManager().recordTaskEnd(taskEntity, executionEntity, this.reason, new Date());
            CommandContextUtil.getActivityInstanceEntityManager().recordActivityEnd(executionEntity, this.reason);
        }
        FlowElement targetFlowElement = process.getFlowElement(this.targetNodeId);
        UserInfo userInfo = Y9LoginUserHolder.getUserInfo();
        String taskSender = userInfo.getName();
        String taskSenderId = userId = userInfo.getPersonId();
        String user = null;
        HashMap<String, Object> vars = new HashMap<String, Object>(16);
        vars.put("taskSender", taskSender);
        vars.put("taskSenderId", taskSenderId);
        if (this.users.size() == 1) {
            user = this.users.get(0);
        }
        vars.put("user", user);
        vars.put("users", this.users);
        FlowableEngineAgenda flowableEngineAgenda = CommandContextUtil.getAgenda();
        if (currentBehavior instanceof MultiInstanceActivityBehavior) {
            ExecutionEntity parentExecutionEntity = executionEntity.getParent();
            parentExecutionEntity.setCurrentFlowElement(targetFlowElement);
            parentExecutionEntity.setActive(true);
            parentExecutionEntity.setMultiInstanceRoot(false);
            parentExecutionEntity.setVariables(vars);
            executionEntityManager.update((Entity)parentExecutionEntity);
            flowableEngineAgenda.planContinueProcessInCompensation(parentExecutionEntity);
        } else {
            executionEntity.setCurrentFlowElement(targetFlowElement);
            executionEntity.setVariables(vars);
            flowableEngineAgenda.planContinueProcessInCompensation(executionEntity);
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        processEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(taskEntity, "delete");
        return null;
    }
}

