/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.api.processadmin.TaskApi;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.model.processadmin.TaskModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomTaskService;
import net.risesoft.util.FlowableModelConvertUtil;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/task"}, produces={"application/json"})
public class TaskApiImpl
implements TaskApi {
    private final CustomTaskService customTaskService;
    private final PersonApi personManager;
    private final PositionApi positionManager;

    public Y9Result<Object> claim(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customTaskService.claim(taskId, userId);
        return Y9Result.success();
    }

    public Y9Result<Object> complete(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.customTaskService.complete(taskId);
        return Y9Result.success();
    }

    public Y9Result<Object> completeTask(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Task task = this.customTaskService.findById(taskId);
        if (DelegationState.PENDING == task.getDelegationState()) {
            String taskOwner = task.getOwner();
            this.customTaskService.resolveTask(taskId);
            this.customTaskService.setAssignee(taskId, taskOwner);
        }
        return Y9Result.success();
    }

    public Y9Result<Object> completeTaskWithoutAssignee(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        this.customTaskService.completeTaskWithoutAssignee(processInstanceId);
        return Y9Result.success();
    }

    public Y9Result<Object> completeWithVariables(@RequestParam String tenantId, @RequestParam String taskId, @RequestBody Map<String, Object> map) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.customTaskService.completeWithVariables(taskId, map);
        return Y9Result.success();
    }

    public Y9Result<Object> completeWithVariables4Position(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam String positionId, @RequestBody Map<String, Object> vars) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        this.customTaskService.completeWithVariables(taskId, vars);
        return Y9Result.success();
    }

    public Y9Result<Object> createWithVariables(@RequestParam String tenantId, @RequestParam String personId, @RequestParam String routeToTaskId, @SpringQueryMap Map<String, Object> vars, @RequestBody List<String> userIdList) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)((Person)this.personManager.get(tenantId, personId).getData()));
        this.customTaskService.createWithVariables(vars, routeToTaskId, userIdList);
        return Y9Result.success();
    }

    public Y9Result<Object> createWithVariables4Position(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String personId, @RequestParam String routeToTaskId, @SpringQueryMap Map<String, Object> vars, @RequestBody List<String> positionIdList) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        Y9LoginUserHolder.setPerson((Person)((Person)this.personManager.get(tenantId, personId).getData()));
        this.customTaskService.createWithVariables(positionId, vars, routeToTaskId, positionIdList);
        return Y9Result.success();
    }

    public Y9Result<Object> delegateTask(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam String assignee) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customTaskService.delegateTask(taskId, assignee);
        return Y9Result.success();
    }

    public Y9Result<Object> deleteCandidateUser(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam String assignee) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customTaskService.deleteCandidateUser(taskId, URLDecoder.decode(assignee, StandardCharsets.UTF_8));
        return Y9Result.success();
    }

    public Y9Result<List<TaskModel>> findAll(@RequestParam String tenantId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<Task> taskList = this.customTaskService.findAll();
        return Y9Result.success(FlowableModelConvertUtil.taskList2TaskModelList(taskList));
    }

    public Y9Result<TaskModel> findById(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Task task = this.customTaskService.findById(taskId);
        return Y9Result.success((Object)FlowableModelConvertUtil.task2TaskModel(task));
    }

    public Y9Result<List<TaskModel>> findByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<Task> taskList = this.customTaskService.listByProcessInstanceId(processInstanceId);
        return Y9Result.success(FlowableModelConvertUtil.taskList2TaskModelList(taskList));
    }

    public Y9Result<List<TaskModel>> findByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam boolean active) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<Task> taskList = this.customTaskService.listByProcessInstanceIdAndActive(processInstanceId, active);
        return Y9Result.success(FlowableModelConvertUtil.taskList2TaskModelList(taskList));
    }

    public Y9Page<TaskModel> findListByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customTaskService.pageByProcessInstanceId(processInstanceId, page, rows);
    }

    public Y9Result<Object> saveTask(@RequestParam String tenantId, @RequestBody TaskModel taskModel) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Task task = this.customTaskService.findById(taskModel.getId());
        FlowableModelConvertUtil.taskModel2Task(taskModel, task);
        this.customTaskService.saveTask(task);
        return Y9Result.success();
    }

    public Y9Result<Object> setAssignee(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam String assignee) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customTaskService.setAssignee(taskId, URLDecoder.decode(assignee, StandardCharsets.UTF_8));
        return Y9Result.success();
    }

    public Y9Result<Object> setDueDate(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam Date date) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customTaskService.setDueDate(taskId, date);
        return Y9Result.success();
    }

    public Y9Result<Object> setPriority(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam Integer priority) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customTaskService.setPriority(taskId, priority);
        return Y9Result.success();
    }

    public Y9Result<Object> unClaim(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customTaskService.unclaim(taskId);
        return Y9Result.success();
    }

    @Generated
    public TaskApiImpl(CustomTaskService customTaskService, PersonApi personManager, PositionApi positionManager) {
        this.customTaskService = customTaskService;
        this.personManager = personManager;
        this.positionManager = positionManager;
    }
}

