/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.api.processadmin.SpecialOperationApi;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.OperationService;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/specialOperation"}, produces={"application/json"})
public class SpecialOperationApiImpl
implements SpecialOperationApi {
    private final OperationService operationService;
    private final PersonApi personManager;
    private final PositionApi positionManager;

    public Y9Result<Object> reposition(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String taskId, @RequestParam String targetTaskDefineKey, @RequestBody List<String> users, String reason, String sponsorGuid) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Person person = (Person)this.personManager.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.operationService.reposition(taskId, targetTaskDefineKey, users, reason, sponsorGuid);
        return Y9Result.success();
    }

    public Y9Result<Object> reposition4Position(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId, @RequestParam String repositionToTaskId, @RequestParam(value="userChoice") List<String> userChoice, String reason, String sponsorGuid) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        this.operationService.reposition4Position(taskId, repositionToTaskId, userChoice, reason, sponsorGuid);
        return Y9Result.success();
    }

    public Y9Result<Object> rollBack(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String taskId, String reason) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Person person = (Person)this.personManager.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.operationService.rollBack(taskId, reason);
        return Y9Result.success();
    }

    public Y9Result<Object> rollBack4Position(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId, String reason) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        this.operationService.rollBack4Position(taskId, reason);
        return Y9Result.success();
    }

    public Y9Result<Object> rollbackToSender4Position(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        this.operationService.rollbackToSender4Position(taskId);
        return Y9Result.success();
    }

    public Y9Result<Object> rollbackToStartor4Position(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId, String reason) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        this.operationService.rollbackToStartor4Position(taskId, reason);
        return Y9Result.success();
    }

    public Y9Result<Object> specialComplete4Position(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId, String reason) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        this.operationService.specialComplete4Position(taskId, reason);
        return Y9Result.success();
    }

    public Y9Result<Object> takeBack(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String taskId, String reason) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Person person = (Person)this.personManager.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.operationService.takeBack(taskId, reason);
        return Y9Result.success();
    }

    public Y9Result<Object> takeBack4Position(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId, String reason) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        this.operationService.takeBack4Position(taskId, reason);
        return Y9Result.success();
    }

    @Generated
    public SpecialOperationApiImpl(OperationService operationService, PersonApi personManager, PositionApi positionManager) {
        this.operationService = operationService;
        this.personManager = personManager;
        this.positionManager = positionManager;
    }
}

