/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessTodoApi;
import net.risesoft.model.processadmin.TaskModel;
import net.risesoft.model.processadmin.Y9FlowableCountModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomDoingService;
import net.risesoft.service.CustomTodoService;
import net.risesoft.y9.FlowableTenantInfoHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/processTodo"})
public class ProcessTodoApiImpl
implements ProcessTodoApi {
    private final CustomTodoService customTodoService;
    private final CustomDoingService customDoingService;

    public Y9Result<Long> countByPositionId(String tenantId, String positionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customTodoService.getCountByUserId(positionId));
    }

    public Y9Result<Y9FlowableCountModel> getCountByUserIdAndProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processDefinitionKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        long todoCount = this.customTodoService.getCountByUserIdAndProcessDefinitionKey(userId, processDefinitionKey);
        long doingCount = this.customDoingService.getCountByUserIdAndProcessDefinitionKey(userId, processDefinitionKey);
        long doneCount = 0L;
        return Y9Result.success((Object)new Y9FlowableCountModel(todoCount, doingCount, doneCount));
    }

    public Y9Result<Y9FlowableCountModel> getCountByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        long todoCount = this.customTodoService.getCountByUserIdAndSystemName(userId, systemName);
        long doingCount = this.customDoingService.getCountByUserIdAndSystemName(userId, systemName);
        long doneCount = 0L;
        return Y9Result.success((Object)new Y9FlowableCountModel(todoCount, doingCount, doneCount));
    }

    public Y9Page<TaskModel> getListByUserIdAndProcessDefinitionKey(@RequestParam @NotBlank String tenantId, @RequestParam @NotBlank String userId, @RequestParam @NotBlank String processDefinitionKey, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customTodoService.pageByUserIdAndProcessDefinitionKey(userId, processDefinitionKey, page, rows);
    }

    public Y9Page<TaskModel> getListByUserIdAndSystemName(@RequestParam @NotBlank String tenantId, @RequestParam @NotBlank String userId, @RequestParam @NotBlank String systemName, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customTodoService.pageByUserIdAndSystemName(userId, systemName, page, rows);
    }

    public Y9Result<Long> getTodoCountByPositionIdAndProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String processDefinitionKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customTodoService.getCountByUserIdAndProcessDefinitionKey(positionId, processDefinitionKey));
    }

    public Y9Result<Long> getTodoCountByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success((Object)this.customTodoService.getCountByUserIdAndSystemName(userId, systemName));
    }

    public Y9Page<TaskModel> pageByUserId(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customTodoService.pageByUserId(positionId, page, rows);
    }

    public Y9Page<TaskModel> searchListByUserIdAndProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processDefinitionKey, String searchTerm, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customTodoService.searchListByUserIdAndProcessDefinitionKey(userId, processDefinitionKey, searchTerm, page, rows);
    }

    public Y9Page<TaskModel> searchListByUserIdAndSystemName(@RequestParam @NotBlank String tenantId, @RequestParam @NotBlank String userId, @RequestParam @NotBlank String systemName, String searchTerm, @RequestParam Integer page, @RequestParam Integer rows) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customTodoService.searchListByUserIdAndSystemName(userId, systemName, searchTerm, page, rows);
    }

    @Generated
    public ProcessTodoApiImpl(CustomTodoService customTodoService, CustomDoingService customDoingService) {
        this.customTodoService = customTodoService;
        this.customDoingService = customDoingService;
    }
}

