/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import lombok.Generated;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.processadmin.ProcessModelApi;
import net.risesoft.model.platform.Person;
import net.risesoft.model.processadmin.FlowableBpmnModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.BpmnAutoLayout;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Process;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.util.XmlUtil;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.flowable.validation.ProcessValidator;
import org.flowable.validation.ProcessValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/services/rest/processModel"}, produces={"application/json"})
public class ProcessModelApiImpl
implements ProcessModelApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessModelApiImpl.class);
    private final ModelService modelService;
    private final RepositoryService repositoryService;
    private final ModelRepository modelRepository;
    private final PersonApi personApi;

    public Y9Result<Object> deleteModel(@RequestParam String tenantId, @RequestParam String modelId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.modelService.deleteModel(modelId);
        return Y9Result.success();
    }

    public Y9Result<Object> deployModel(@RequestParam String tenantId, @RequestParam String modelId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Model modelData = this.modelService.getModel(modelId);
        BpmnModel model = this.modelService.getBpmnModel((AbstractModel)modelData);
        if (model.getProcesses().isEmpty()) {
            return Y9Result.failure((String)"\u6570\u636e\u6a21\u578b\u4e0d\u7b26\u8981\u6c42\uff0c\u8bf7\u81f3\u5c11\u8bbe\u8ba1\u4e00\u6761\u4e3b\u7ebf\u6d41\u7a0b\u3002");
        }
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(model);
        String processName = modelData.getName() + ".bpmn20.xml";
        this.repositoryService.createDeployment().name(modelData.getName()).addBytes(processName, bpmnBytes).deploy();
        return Y9Result.success();
    }

    public Y9Result<List<FlowableBpmnModel>> getModelList(@RequestParam String tenantId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        FlowableTenantInfoHolder.setTenantId(tenantId);
        ArrayList<FlowableBpmnModel> items = new ArrayList<FlowableBpmnModel>();
        List list = this.modelService.getModelsByModelType(Integer.valueOf(0));
        for (AbstractModel model : list) {
            FlowableBpmnModel flowableBpmnModel = new FlowableBpmnModel();
            flowableBpmnModel.setId(model.getId());
            flowableBpmnModel.setKey(model.getKey());
            flowableBpmnModel.setName(model.getName());
            flowableBpmnModel.setVersion(0);
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(model.getKey()).latestVersion().singleResult();
            if (null != processDefinition) {
                flowableBpmnModel.setVersion(processDefinition.getVersion());
            }
            flowableBpmnModel.setCreateTime(sdf.format(model.getCreated()));
            flowableBpmnModel.setLastUpdateTime(sdf.format(model.getLastUpdated()));
            items.add(flowableBpmnModel);
        }
        return Y9Result.success(items, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public Y9Result<String> getModelXml(@RequestParam String tenantId, @RequestParam String modelId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Model model = this.modelService.getModel(modelId);
        byte[] bpmnBytes = this.modelService.getBpmnXML((AbstractModel)model);
        return Y9Result.success((Object)(bpmnBytes == null ? "" : new String(bpmnBytes, StandardCharsets.UTF_8)), (String)"\u83b7\u53d6\u6210\u529f");
    }

    public Y9Result<Object> saveModelXml(@RequestParam String tenantId, @RequestParam String userId, MultipartFile file) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        try {
            Person person = (Person)this.personApi.get(tenantId, userId).getData();
            Y9LoginUserHolder.setPerson((Person)person);
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            InputStreamReader xmlIn = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
            XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
            BpmnXMLConverter bpmnXmlConverter = new BpmnXMLConverter();
            BpmnModel bpmnModel = bpmnXmlConverter.convertToBpmnModel(xtr);
            ProcessValidator validator = new ProcessValidatorFactory().createDefaultProcessValidator();
            List errors = validator.validate(bpmnModel);
            if (!errors.isEmpty()) {
                StringBuffer es = new StringBuffer();
                errors.forEach(ve -> es.append(ve.toString()).append("/n"));
                return Y9Result.failure((String)("\u4fdd\u5b58\u5931\u8d25\uff1a\u6a21\u677f\u9a8c\u8bc1\u5931\u8d25\uff0c\u539f\u56e0: " + es));
            }
            if (bpmnModel.getProcesses().isEmpty()) {
                return Y9Result.failure((String)"\u4fdd\u5b58\u5931\u8d25\uff1a \u6587\u4ef6\u4e2d\u4e0d\u5b58\u5728\u6d41\u7a0b\u7684\u4fe1\u606f");
            }
            if (bpmnModel.getLocationMap().isEmpty()) {
                BpmnAutoLayout bpmnLayout = new BpmnAutoLayout(bpmnModel);
                bpmnLayout.execute();
            }
            BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
            ObjectNode modelNode = bpmnJsonConverter.convertToJson(bpmnModel);
            Process process = bpmnModel.getMainProcess();
            String name = process.getId();
            if (StringUtils.isNotEmpty((CharSequence)process.getName())) {
                name = process.getName();
            }
            String description = process.getDocumentation();
            Model newModel = new Model();
            List models = this.modelRepository.findByKeyAndType(process.getId(), Integer.valueOf(0));
            if (!models.isEmpty()) {
                Model updateModel = (Model)models.get(0);
                newModel.setId(updateModel.getId());
            }
            newModel.setName(name);
            newModel.setKey(process.getId());
            newModel.setModelType(Integer.valueOf(0));
            newModel.setCreated(Calendar.getInstance().getTime());
            newModel.setCreatedBy(person.getName());
            newModel.setDescription(description);
            newModel.setModelEditorJson(modelNode.toString());
            newModel.setLastUpdated(Calendar.getInstance().getTime());
            newModel.setLastUpdatedBy(person.getName());
            newModel.setTenantId(tenantId);
            String createdBy = SecurityUtils.getCurrentUserId();
            this.modelService.createModel(newModel, createdBy);
            return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u6a21\u578b\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @Generated
    public ProcessModelApiImpl(ModelService modelService, RepositoryService repositoryService, ModelRepository modelRepository, PersonApi personApi) {
        this.modelService = modelService;
        this.repositoryService = repositoryService;
        this.modelRepository = modelRepository;
        this.personApi = personApi;
    }
}

