/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.processadmin.HistoricVariableApi;
import net.risesoft.model.processadmin.HistoricVariableInstanceModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomHistoricVariableService;
import net.risesoft.util.FlowableModelConvertUtil;
import net.risesoft.y9.FlowableTenantInfoHolder;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/historicVariable"})
public class HistoricVariableApiImpl
implements HistoricVariableApi {
    private final CustomHistoricVariableService customHistoricVariableService;

    public Y9Result<List<HistoricVariableInstanceModel>> getByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<HistoricVariableInstance> hviList = this.customHistoricVariableService.listByProcessInstanceId(processInstanceId);
        return Y9Result.success(FlowableModelConvertUtil.historicVariableInstanceList2ModelList(hviList));
    }

    public Y9Result<HistoricVariableInstanceModel> getByProcessInstanceIdAndVariableName(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String variableName, String year) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        HistoricVariableInstance hvi = this.customHistoricVariableService.getByProcessInstanceIdAndVariableName(processInstanceId, variableName, year);
        if (hvi == null) {
            return Y9Result.failure((String)"\u8be5\u6d41\u7a0b\u5b9e\u4f8b\u4e0b\u6ca1\u6709\u8be5\u53d8\u91cf");
        }
        return Y9Result.success((Object)FlowableModelConvertUtil.historicVariableInstance2Model(hvi));
    }

    public Y9Result<List<HistoricVariableInstanceModel>> getByTaskId(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<HistoricVariableInstance> hviList = this.customHistoricVariableService.listByTaskId(taskId);
        return Y9Result.success(FlowableModelConvertUtil.historicVariableInstanceList2ModelList(hviList));
    }

    public Y9Result<HistoricVariableInstanceModel> getByTaskIdAndVariableName(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam String variableName, String year) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        HistoricVariableInstance hvi = this.customHistoricVariableService.getByTaskIdAndVariableName(taskId, variableName, year);
        if (hvi == null) {
            return Y9Result.failure((String)"\u6d41\u7a0b\u53d8\u91cf\u4e0d\u5b58\u5728");
        }
        return Y9Result.success((Object)FlowableModelConvertUtil.historicVariableInstance2Model(hvi));
    }

    public Y9Result<Map<String, Object>> getVariables(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestBody Collection<String> keys) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success(this.customHistoricVariableService.getVariables(tenantId, processInstanceId, keys));
    }

    @Generated
    public HistoricVariableApiImpl(CustomHistoricVariableService customHistoricVariableService) {
        this.customHistoricVariableService = customHistoricVariableService;
    }
}

