/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.ProcessInstanceApi;
import net.risesoft.api.itemadmin.position.ChaoSong4PositionApi;
import net.risesoft.api.processadmin.HistoricProcessApi;
import net.risesoft.api.todo.TodoTaskApi;
import net.risesoft.model.processadmin.HistoricProcessInstanceModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomHistoricProcessService;
import net.risesoft.service.CustomTaskService;
import net.risesoft.util.FlowableModelConvertUtil;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/historicProcess"})
public class HistoricProcessApiImpl
implements HistoricProcessApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoricProcessApiImpl.class);
    private final CustomHistoricProcessService customHistoricProcessService;
    private final CustomTaskService customTaskService;
    private final TodoTaskApi rpcTodoTaskManager;
    private final ProcessInstanceApi processInstance4PositionApi;
    private final ChaoSong4PositionApi chaoSongInfoManager;

    public Y9Result<Object> deleteProcessInstance(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Task> list = this.customTaskService.listByProcessInstanceId(processInstanceId);
        boolean b = this.customHistoricProcessService.deleteProcessInstance(processInstanceId);
        if (b) {
            if (list != null && !list.isEmpty()) {
                for (Task task : list) {
                    try {
                        boolean msg1 = this.rpcTodoTaskManager.deleteTodoTaskByTaskId(tenantId, task.getId());
                        LOGGER.error("##############################\u7edf\u4e00\u5f85\u529e\u5220\u9664\uff1a{}#################################", (Object)msg1);
                    }
                    catch (Exception e) {
                        LOGGER.error("##############################\u7edf\u4e00\u5f85\u529e\u5220\u9664\u5931\u8d25\uff1a{}#", (Object)e.getMessage());
                    }
                }
            }
            try {
                boolean msg3 = this.chaoSongInfoManager.deleteByProcessInstanceId(tenantId, processInstanceId).isSuccess();
                LOGGER.error("##############################\u6284\u9001\u4ef6\u5220\u9664\uff1a{}#################################", (Object)msg3);
            }
            catch (Exception e) {
                LOGGER.error("##########\u6284\u9001\u4ef6\u5220\u9664\u5931\u8d25\uff1a{}#", (Object)e.getMessage());
            }
            try {
                boolean msg2 = (Boolean)this.processInstance4PositionApi.deleteProcessInstance(tenantId, processInstanceId).getData();
                LOGGER.error("##############################\u534f\u4f5c\u72b6\u6001\u5220\u9664\uff1a{}#################################", (Object)msg2);
            }
            catch (Exception e) {
                LOGGER.error("##########\u534f\u4f5c\u72b6\u6001\u5220\u9664\u5931\u8d25\uff1a{}#", (Object)e.getMessage());
            }
        }
        return Y9Result.success();
    }

    public Y9Result<HistoricProcessInstanceModel> getById(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        HistoricProcessInstance hpi = this.customHistoricProcessService.getById(processInstanceId);
        return Y9Result.success((Object)FlowableModelConvertUtil.historicProcessInstance2Model(hpi));
    }

    public Y9Result<HistoricProcessInstanceModel> getByIdAndYear(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String year) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        HistoricProcessInstance hpi = this.customHistoricProcessService.getByIdAndYear(processInstanceId, year);
        HistoricProcessInstanceModel hpiModel = null;
        if (hpi != null) {
            hpiModel = FlowableModelConvertUtil.historicProcessInstance2Model(hpi);
        }
        return Y9Result.success(hpiModel);
    }

    public Y9Result<List<HistoricProcessInstanceModel>> getBySuperProcessInstanceId(@RequestParam String tenantId, @RequestParam String superProcessInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<HistoricProcessInstance> hpiList = this.customHistoricProcessService.listBySuperProcessInstanceId(superProcessInstanceId);
        return Y9Result.success(FlowableModelConvertUtil.historicProcessInstanceList2ModelList(hpiList));
    }

    public Y9Result<HistoricProcessInstanceModel> getSuperProcessInstanceById(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        HistoricProcessInstance hpi = this.customHistoricProcessService.getSuperProcessInstanceById(processInstanceId);
        return Y9Result.success((Object)FlowableModelConvertUtil.historicProcessInstance2Model(hpi));
    }

    public Y9Result<Object> recoveryProcess(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        boolean b = this.customHistoricProcessService.recoveryProcessInstance(processInstanceId);
        List<Task> list = this.customTaskService.listByProcessInstanceId(processInstanceId);
        if (b && list != null && !list.isEmpty()) {
            for (Task task : list) {
                try {
                    boolean msg1 = this.rpcTodoTaskManager.recoveryTodoTaskByTaskId(tenantId, task.getId());
                    LOGGER.info("##############################\u7edf\u4e00\u5f85\u529e\u8fd8\u539f\uff1a{}#################################", (Object)msg1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return Y9Result.success();
    }

    public Y9Result<Object> removeProcess(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.customHistoricProcessService.removeProcess(processInstanceId));
    }

    public Y9Result<Object> removeProcess4Position(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.customHistoricProcessService.removeProcess4Position(processInstanceId));
    }

    public Y9Result<Object> setPriority(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String priority) throws Exception {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customHistoricProcessService.setPriority(processInstanceId, priority);
        return Y9Result.success();
    }

    @Generated
    public HistoricProcessApiImpl(CustomHistoricProcessService customHistoricProcessService, CustomTaskService customTaskService, TodoTaskApi rpcTodoTaskManager, ProcessInstanceApi processInstance4PositionApi, ChaoSong4PositionApi chaoSongInfoManager) {
        this.customHistoricProcessService = customHistoricProcessService;
        this.customTaskService = customTaskService;
        this.rpcTodoTaskManager = rpcTodoTaskManager;
        this.processInstance4PositionApi = processInstance4PositionApi;
        this.chaoSongInfoManager = chaoSongInfoManager;
    }
}

