/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.WorkflowTaskService;
import net.risesoft.util.MapUtil;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.flowable.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.repository.ProcessDefinitionQuery;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.springframework.stereotype.Service;

@Service
public class WorkflowProcessInstanceService {
    private static final String ENDEVENT = "endEvent";
    private final RuntimeService runtimeService;
    private final RepositoryService repositoryService;
    private final TaskService taskService;
    private final WorkflowTaskService workflowTaskService;

    public ProcessInstance findProcessInstance(String processInstanceId) {
        ProcessInstance processInstance = null;
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            try {
                processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                if (processInstance == null) {
                    throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u672a\u627e\u5230!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return processInstance;
    }

    public ProcessInstance findProcessInstanceByTaskId(String taskId) {
        ProcessInstance processInstance = null;
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            String processInstanceId = this.workflowTaskService.getTaskByTaskId(taskId).getProcessInstanceId();
            processInstance = this.findProcessInstance(processInstanceId);
        }
        return processInstance;
    }

    public Map<String, String> getCertainTaskTargets(String taskId, String targetType) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        List<SequenceFlow> outTransitions = this.getPvmTransitions(taskId);
        for (SequenceFlow tr : outTransitions) {
            if (!(tr.getTargetFlowElement() instanceof EndEvent)) continue;
            map.put(tr.getTargetFlowElement().getId(), tr.getTargetFlowElement().getName());
        }
        return map;
    }

    public List<String> getCertainTaskTargetsId(String taskId, String targetType) {
        Map<String, String> targetTasks = this.getCertainTaskTargets(taskId, targetType);
        return MapUtil.getKey(targetTasks);
    }

    public Y9Result<List<TargetModel>> getCurrentTaskTargets(String processDefinitionId, String taskDefKey) {
        ArrayList<TargetModel> targetTasks = new ArrayList<TargetModel>();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = (Process)bpmnModel.getProcesses().get(0);
        List flowElements = (List)process.getFlowElements();
        boolean isGateway = false;
        block0: for (int i = 0; i < flowElements.size(); ++i) {
            TargetModel targetModel;
            StartEvent task;
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (!taskDefKey.equals(flowElement.getId())) continue;
            List list = new ArrayList();
            if (flowElement instanceof StartEvent) {
                task = (StartEvent)flowElement;
                list = task.getOutgoingFlows();
            } else if (flowElement instanceof UserTask) {
                task = (UserTask)flowElement;
                list = task.getOutgoingFlows();
            } else if (flowElement instanceof ExclusiveGateway) {
                task = (ExclusiveGateway)flowElement;
                list = task.getOutgoingFlows();
            }
            if (!isGateway) {
                for (SequenceFlow tr : list) {
                    targetModel = new TargetModel();
                    FlowElement fe = tr.getTargetFlowElement();
                    if (!(fe instanceof EndEvent)) {
                        targetModel.setTaskDefKey(tr.getTargetFlowElement().getId());
                        String name = tr.getName();
                        if (StringUtils.isNotBlank((CharSequence)name)) {
                            targetModel.setTaskDefName(name);
                        } else {
                            targetModel.setTaskDefName(tr.getTargetFlowElement().getName());
                        }
                    }
                    if (tr.getTargetFlowElement() instanceof ExclusiveGateway) {
                        taskDefKey = tr.getTargetFlowElement().getId();
                        i = -1;
                        isGateway = true;
                        continue block0;
                    }
                    targetTasks.add(targetModel);
                }
                continue;
            }
            for (SequenceFlow tr : list) {
                targetModel = new TargetModel();
                String conditionText = tr.getConditionExpression();
                FlowElement fe = tr.getTargetFlowElement();
                if (!StringUtils.isNotBlank((CharSequence)conditionText) || fe instanceof EndEvent) continue;
                targetModel.setTaskDefKey(tr.getTargetFlowElement().getId());
                targetModel.setTaskDefName(tr.getName());
                UserTask userTask = (UserTask)fe;
                if (userTask.getBehavior() instanceof SequentialMultiInstanceBehavior) {
                    targetModel.setMultiInstance("sequential");
                } else if (userTask.getBehavior() instanceof ParallelMultiInstanceBehavior) {
                    targetModel.setMultiInstance("parallel");
                }
                targetTasks.add(targetModel);
            }
        }
        return Y9Result.success(targetTasks);
    }

    public String getProcessDefinitionId(String processDefinitionKey) {
        ProcessDefinitionQuery processDefinitionQuery = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByProcessDefinitionKey().asc();
        String processDefinitionId = "";
        List processDefinitionList = processDefinitionQuery.list();
        for (ProcessDefinition processDefinition : processDefinitionList) {
            if (!processDefinitionKey.equals(processDefinition.getKey())) continue;
            processDefinitionId = processDefinition.getId();
        }
        return processDefinitionId;
    }

    public List<String> getProcessInstanceIds(String processDefinitionKey) {
        ArrayList<String> result = new ArrayList<String>();
        List<ProcessInstance> processInstanceList = this.getProcessInstances(processDefinitionKey);
        if (!processInstanceList.isEmpty()) {
            for (ProcessInstance entity : processInstanceList) {
                result.add(entity.getProcessInstanceId());
            }
        }
        return result;
    }

    public List<ProcessInstance> getProcessInstances(String processDefinitionKey) {
        List<Object> list = new ArrayList<ProcessInstance>();
        if (StringUtils.isNotBlank((CharSequence)processDefinitionKey)) {
            list = this.runtimeService.createProcessInstanceQuery().processDefinitionKey(processDefinitionKey).list();
        }
        return list;
    }

    public List<SequenceFlow> getPvmTransitions(String taskId) {
        boolean isGateway = false;
        TaskEntity task = this.workflowTaskService.getTaskByTaskId(taskId);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        Process process = (Process)bpmnModel.getProcesses().get(0);
        List flowElements = (List)process.getFlowElements();
        List<Object> list = new ArrayList<SequenceFlow>();
        ArrayList<SequenceFlow> flowList = new ArrayList<SequenceFlow>();
        String activitiId = this.workflowTaskService.getActivitiIdByTask((Task)task);
        block0: for (int i = 0; i < flowElements.size(); ++i) {
            StartEvent event;
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            String id = flowElement.getId();
            if (!activitiId.equals(id)) continue;
            if (flowElement instanceof StartEvent) {
                event = (StartEvent)flowElement;
                list = event.getOutgoingFlows();
            } else if (flowElement instanceof UserTask) {
                event = (UserTask)flowElement;
                list = event.getOutgoingFlows();
            } else if (flowElement instanceof ExclusiveGateway) {
                event = (ExclusiveGateway)flowElement;
                list = event.getOutgoingFlows();
            }
            if (!isGateway) {
                for (SequenceFlow sequenceFlow : list) {
                    FlowElement fe = sequenceFlow.getTargetFlowElement();
                    if (fe instanceof ExclusiveGateway) {
                        activitiId = fe.getId();
                        i = -1;
                        isGateway = true;
                        continue block0;
                    }
                    flowList.add(sequenceFlow);
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : list) {
                flowList.add(sequenceFlow);
            }
            list = flowList;
        }
        return list;
    }

    public List<SequenceFlow> getPvmTransitions(String processDefinitionId, String taskDefKey) {
        boolean isGateway = false;
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = (Process)bpmnModel.getProcesses().get(0);
        List flowElements = (List)process.getFlowElements();
        List<Object> list = new ArrayList<SequenceFlow>();
        ArrayList<SequenceFlow> flowList = new ArrayList<SequenceFlow>();
        block0: for (int i = 0; i < flowElements.size(); ++i) {
            StartEvent event;
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            String id = flowElement.getId();
            if (!taskDefKey.equals(id)) continue;
            if (flowElement instanceof StartEvent) {
                event = (StartEvent)flowElement;
                list = event.getOutgoingFlows();
            } else if (flowElement instanceof UserTask) {
                event = (UserTask)flowElement;
                list = event.getOutgoingFlows();
            } else if (flowElement instanceof ExclusiveGateway) {
                event = (ExclusiveGateway)flowElement;
                list = event.getOutgoingFlows();
            }
            if (!isGateway) {
                for (SequenceFlow sequenceFlow : list) {
                    FlowElement fe = sequenceFlow.getTargetFlowElement();
                    if (!(fe instanceof ExclusiveGateway)) continue;
                    taskDefKey = fe.getId();
                    i = -1;
                    isGateway = true;
                    continue block0;
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : list) {
                String conditionText = sequenceFlow.getConditionExpression();
                if (!StringUtils.isNotBlank((CharSequence)conditionText)) continue;
                flowList.add(sequenceFlow);
            }
            list = flowList;
        }
        return list;
    }

    public int getPvmTransitionsCount(String taskId) {
        int count = 0;
        List<SequenceFlow> outTransitions = this.getPvmTransitions(taskId);
        ArrayList<SequenceFlow> list = new ArrayList<SequenceFlow>();
        for (SequenceFlow tr : outTransitions) {
            if (tr.getTargetFlowElement() instanceof EndEvent) continue;
            list.add(tr);
        }
        if (list != null) {
            count = list.size();
        }
        return count;
    }

    public String getSenderUser(String taskId) {
        String senderId = "";
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            senderId = (String)this.taskService.getVariable(taskId, "taskSenderId");
        }
        return senderId;
    }

    public List<Map<String, String>> getStartTaskTargets(String processDefinitionKey) {
        ArrayList<Map<String, String>> targetTasks = new ArrayList<Map<String, String>>();
        ProcessDefinitionQuery processDefinitionQuery = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByProcessDefinitionKey().asc();
        String processDefinitionId = "";
        List processDefinitionList = processDefinitionQuery.list();
        for (ProcessDefinition processDefinition : processDefinitionList) {
            if (!processDefinitionKey.equals(processDefinition.getKey())) continue;
            processDefinitionId = processDefinition.getId();
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = bpmnModel.getMainProcess();
        Collection flowElements = process.getFlowElements();
        List startEvents = process.findFlowElementsOfType(StartEvent.class);
        FlowElement sourceNode = (FlowElement)startEvents.get(0);
        for (FlowElement flowElement : flowElements) {
            if (!flowElement.getId().equals(sourceNode.getId())) continue;
            List sequenceFlows = ((FlowNode)sourceNode).getOutgoingFlows();
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                FlowElement targetFlowElement = process.getFlowElement(sequenceFlow.getTargetRef());
                if (targetFlowElement instanceof Gateway) {
                    sourceNode = targetFlowElement;
                    continue;
                }
                org.flowable.bpmn.model.Task targetTask = (org.flowable.bpmn.model.Task)targetFlowElement;
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("taskName", targetTask.getName());
                map.put("taskId", targetTask.getId());
                targetTasks.add(map);
            }
        }
        return targetTasks;
    }

    public boolean isContainTaskTarget(String taskId, String type) {
        boolean result = false;
        List<SequenceFlow> flowElements = this.getPvmTransitions(taskId);
        for (SequenceFlow tr : flowElements) {
            FlowElement flowElement = tr.getTargetFlowElement();
            if (!(flowElement instanceof EndEvent)) continue;
            result = true;
        }
        return result;
    }

    public boolean isContainTaskTargets(String taskId) {
        boolean result = false;
        List<SequenceFlow> flowElements = this.getPvmTransitions(taskId);
        for (SequenceFlow tr : flowElements) {
            FlowElement flowElement = tr.getTargetFlowElement();
            if (!(flowElement instanceof EndEvent)) continue;
            result = true;
        }
        return result;
    }

    @Generated
    public WorkflowProcessInstanceService(RuntimeService runtimeService, RepositoryService repositoryService, TaskService taskService, WorkflowTaskService workflowTaskService) {
        this.runtimeService = runtimeService;
        this.repositoryService = repositoryService;
        this.taskService = taskService;
        this.workflowTaskService = workflowTaskService;
    }
}

