/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import net.risesoft.service.WorkflowHistoryProcessInstanceService;
import net.risesoft.util.WorkflowUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.RepositoryServiceImpl;
import org.flowable.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.flowable.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.repository.ProcessDefinitionQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"repositoryService"})
public class WorkflowProcessDefinitionService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowProcessDefinitionService.class);
    private final RepositoryService repositoryService;
    private final WorkflowHistoryProcessInstanceService workflowHistoryProcessInstanceService;

    private void deploySingleProcess(String processKey) throws IOException {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        String classpathResourceUrl = "classpath:/deployments/" + processKey + ".bar";
        LOGGER.debug("read workflow from: {}", (Object)classpathResourceUrl);
        Resource resource = resourceLoader.getResource(classpathResourceUrl);
        InputStream inputStream = resource.getInputStream();
        LOGGER.debug("finded workflow module: {}, deploy it!", (Object)classpathResourceUrl);
        ZipInputStream zis = new ZipInputStream(inputStream);
        Deployment deployment = this.repositoryService.createDeployment().addZipInputStream(zis).deploy();
        List list = this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).list();
        for (ProcessDefinition processDefinition : list) {
            WorkflowUtils.exportDiagramToFile(this.repositoryService, processDefinition);
        }
    }

    public ProcessDefinitionEntity findProcessDefinition(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition = null;
        if (StringUtils.isNotBlank((CharSequence)processDefinitionId)) {
            try {
                processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
                if (processDefinition == null) {
                    throw new Exception("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return processDefinition;
    }

    public ProcessDefinitionEntity findProcessDefinitionByPid(String processInstanceId) {
        String processDefinitionId;
        ProcessDefinitionEntity processDefinition = null;
        HistoricProcessInstance historicProcessInstance = this.workflowHistoryProcessInstanceService.findOne(processInstanceId);
        if (historicProcessInstance != null && StringUtils.isNotBlank((CharSequence)(processDefinitionId = historicProcessInstance.getProcessDefinitionId()))) {
            processDefinition = this.findProcessDefinition(processDefinitionId);
        }
        return processDefinition;
    }

    public List<FlowElement> getActivityImpls(BpmnModel bpmnModel) {
        List<Object> list = new ArrayList<FlowElement>();
        try {
            Process process = (Process)bpmnModel.getProcesses().get(0);
            list = (List)process.getFlowElements();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<FlowElement> getActivityImpls(String processDefinitionId) {
        List<FlowElement> list = new ArrayList<FlowElement>();
        try {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            list = this.getActivityImpls(bpmnModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public Map<String, String> getActivityProperties(List<FlowElement> activities, String activityId, List<String> propertiesNameList) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        try {
            for (FlowElement activity : activities) {
                if (!activityId.equals(activity.getId())) continue;
                for (String s : propertiesNameList) {
                    UserTask userTask = (UserTask)activity;
                    Object obj = userTask.getBehavior();
                    if (obj instanceof SequentialMultiInstanceBehavior) {
                        result.put(s, "sequential");
                        continue;
                    }
                    if (obj instanceof ParallelMultiInstanceBehavior) {
                        result.put(s, "parallel");
                        continue;
                    }
                    result.put(s, "");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<String, String> getActivityProperties(String processDefinitionId, String activityId, List<String> propertiesNameList) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        try {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            Process process = (Process)bpmnModel.getProcesses().get(0);
            List list = (List)process.getFlowElements();
            return this.getActivityProperties(list, activityId, propertiesNameList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public String getActivityProperty(String processDefinitionId, String activityId, String propertyName) {
        Map<Object, Object> map = new HashMap(16);
        ArrayList<String> propertiesNameList = new ArrayList<String>();
        propertiesNameList.add(propertyName);
        try {
            map = this.getActivityProperties(processDefinitionId, activityId, propertiesNameList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (String)map.get(propertyName);
    }

    public List<Map<String, Object>> getBpmList(String processDefinitionId, Boolean isFilter) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Object> activitieList = new ArrayList();
        if (isFilter != null && isFilter.booleanValue()) {
            Object list1 = new ArrayList();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            Process process = (Process)bpmnModel.getProcesses().get(0);
            list1 = (List)process.getFlowElements();
            if (list1.size() > 0) {
                activitieList.addAll((Collection<Object>)list1);
            }
            Iterator<Object> sListIterator = activitieList.iterator();
            while (sListIterator.hasNext()) {
                FlowElement e = (FlowElement)sListIterator.next();
                if (!(e instanceof Gateway) && !(e instanceof StartEvent) && !(e instanceof EndEvent) && !(e instanceof SequenceFlow)) continue;
                sListIterator.remove();
            }
        } else {
            activitieList = this.getFilteredActivityImpls(processDefinitionId);
        }
        for (FlowElement flowElement : activitieList) {
            LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
            tempMap.put("taskDefKey", flowElement.getId());
            tempMap.put("taskDefName", flowElement.getName());
            list.add(tempMap);
        }
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
        tempMap.put("taskDefKey", "");
        tempMap.put("taskDefName", "\u6d41\u7a0b");
        list.add(0, tempMap);
        return list;
    }

    public List<Map<String, Object>> getBpmListContainStart(String processDefinitionId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ArrayList activitieList = new ArrayList();
        List list1 = new ArrayList();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = (Process)bpmnModel.getProcesses().get(0);
        list1 = (List)process.getFlowElements();
        if (list1.size() > 0) {
            activitieList.addAll(list1);
        }
        Iterator sListIterator = activitieList.iterator();
        while (sListIterator.hasNext()) {
            FlowElement e = (FlowElement)sListIterator.next();
            if (!(e instanceof Gateway) && !(e instanceof EndEvent) && !(e instanceof SequenceFlow)) continue;
            sListIterator.remove();
        }
        for (FlowElement activity : activitieList) {
            LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
            tempMap.put("taskDefKey", activity.getId());
            tempMap.put("taskDefName", activity.getName());
            list.add(tempMap);
        }
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
        tempMap.put("taskDefKey", "");
        tempMap.put("taskDefName", "\u6d41\u7a0b");
        list.add(0, tempMap);
        return list;
    }

    public List<FlowElement> getFilteredActivityImpls(BpmnModel bpmnModel) {
        List<FlowElement> list = this.getActivityImpls(bpmnModel);
        ArrayList<FlowElement> resultList = new ArrayList<FlowElement>();
        if (!list.isEmpty()) {
            resultList.addAll(list);
        }
        Iterator sListIterator = resultList.iterator();
        while (sListIterator.hasNext()) {
            FlowElement e = (FlowElement)sListIterator.next();
            if (!(e instanceof Gateway)) continue;
            sListIterator.remove();
        }
        return resultList;
    }

    public List<FlowElement> getFilteredActivityImpls(String processDefinitionId) {
        List<FlowElement> list = new ArrayList<FlowElement>();
        try {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            list = this.getFilteredActivityImpls(bpmnModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<FlowElement> getFilteredActivityImpls(String processDefinitionId, List<String> filterList) {
        ArrayList<FlowElement> resultList = new ArrayList<FlowElement>();
        List list = new ArrayList();
        try {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            Process process = (Process)bpmnModel.getProcesses().get(0);
            list = (List)process.getFlowElements();
            if (!list.isEmpty()) {
                resultList.addAll(list);
            }
            Iterator sListIterator = resultList.iterator();
            while (sListIterator.hasNext()) {
                FlowElement e = (FlowElement)sListIterator.next();
                if (!(e instanceof Gateway) && !filterList.contains(e.getName())) continue;
                sListIterator.remove();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public ProcessDefinition getLatestProcessDefinition(String processDefinitionKey) {
        if (StringUtils.isNotBlank((CharSequence)processDefinitionKey)) {
            return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        }
        return null;
    }

    public String getLatestProcessDefinitionId(String processDefinitionKey) {
        ProcessDefinition pd;
        String latestProcessDefinitionId = "";
        if (StringUtils.isNotBlank((CharSequence)processDefinitionKey) && (pd = this.getLatestProcessDefinition(processDefinitionKey)) != null) {
            latestProcessDefinitionId = pd.getId();
        }
        return latestProcessDefinitionId;
    }

    public String getMultiinstanceType(String processDefinitionId, String activityId) throws Exception {
        String multiInstance = this.getActivityProperty(processDefinitionId, activityId, "multiInstance");
        if (StringUtils.isNotBlank((CharSequence)multiInstance)) {
            if (multiInstance.equals("parallel")) {
                return "parallel";
            }
            if (multiInstance.equals("sequential")) {
                return "sequential";
            }
        }
        return "";
    }

    public List<String> getNodeName(String processDefinitionId, String nodeType) {
        ArrayList<String> result = new ArrayList<String>();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            flowElement.getId();
        }
        return result;
    }

    public List<String> getProcessDefinitionIds(String processDefinitionKey) {
        ArrayList<String> list = new ArrayList<String>();
        List<ProcessDefinition> processDefinitionList = this.getProcessDefinitions(processDefinitionKey);
        for (ProcessDefinition pd : processDefinitionList) {
            list.add(pd.getId());
        }
        return list;
    }

    public List<ProcessDefinition> getProcessDefinitions(String processDefinitionKey) {
        List<Object> processDefinitionList = new ArrayList<ProcessDefinition>();
        if (StringUtils.isNotBlank((CharSequence)processDefinitionKey)) {
            ProcessDefinitionQuery processDefinitionQuery = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).orderByProcessDefinitionVersion().desc();
            processDefinitionList = processDefinitionQuery.list();
        }
        return processDefinitionList;
    }

    public List<Integer> getProcessDefinitionVersions(String processDefinitionKey) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        List<ProcessDefinition> processDefinitionList = this.getProcessDefinitions(processDefinitionKey);
        for (ProcessDefinition pd : processDefinitionList) {
            list.add(pd.getVersion());
        }
        return list;
    }

    public String getStartActivityImplByProcessDefinitionKey(String processDefinitionKey) {
        String processDefinitionId = this.getLatestProcessDefinitionId(processDefinitionKey);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            return flowElement.getId();
        }
        return null;
    }

    public String getStartTaskDefinitionKey(String processDefinitionId) {
        String result = "";
        ArrayList<FlowElement> resultList = new ArrayList<FlowElement>();
        List<FlowElement> list = this.getActivityImpls(processDefinitionId);
        if (!list.isEmpty()) {
            resultList.addAll(list);
        }
        for (FlowElement e : resultList) {
            if (!(e instanceof StartEvent)) continue;
            result = e.getId();
            break;
        }
        return result;
    }

    public Map<String, String> procDefIdMap() {
        HashMap<String, String> procDefMap = new HashMap<String, String>(16);
        ProcessDefinitionQuery processDefinitionQuery = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByProcessDefinitionKey().asc();
        List processDefinitionList = processDefinitionQuery.list();
        for (ProcessDefinition pd : processDefinitionList) {
            procDefMap.put(pd.getId(), pd.getName());
        }
        return procDefMap;
    }

    public void redeploy(String ... processKeys) throws Exception {
        if (ArrayUtils.isNotEmpty((Object[])processKeys)) {
            for (String processKey : processKeys) {
                this.deploySingleProcess(processKey);
            }
        }
    }

    @Generated
    public WorkflowProcessDefinitionService(RepositoryService repositoryService, WorkflowHistoryProcessInstanceService workflowHistoryProcessInstanceService) {
        this.repositoryService = repositoryService;
        this.workflowHistoryProcessInstanceService = workflowHistoryProcessInstanceService;
    }
}

