/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import cn.hutool.json.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.sql.DataSource;
import lombok.Generated;
import net.risesoft.api.itemadmin.ErrorLogApi;
import net.risesoft.api.itemadmin.ItemInterfaceApi;
import net.risesoft.api.itemadmin.ProcessParamApi;
import net.risesoft.enums.ItemInterfaceTypeEnum;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.itemadmin.ErrorLogModel;
import net.risesoft.model.itemadmin.InterfaceModel;
import net.risesoft.model.itemadmin.InterfaceParamsModel;
import net.risesoft.model.itemadmin.ProcessParamModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.InterfaceUtilService$AjcClosure1;
import net.risesoft.service.InterfaceUtilService$AjcClosure3;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.sqlddl.DbMetaDataUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.flowable.engine.delegate.event.impl.FlowableSequenceFlowTakenEventImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.aspectj.AnnotationAsyncExecutionAspect;
import org.springframework.stereotype.Service;

@EnableAsync
@Service(value="interfaceUtilService")
public class InterfaceUtilService {
    @Generated
    private static final Logger LOGGER;
    private final ProcessParamApi processParamApi;
    private final ErrorLogApi errorLogApi;
    private final ItemInterfaceApi itemInterfaceApi;
    @Resource(name="jdbcTemplate4Tenant")
    private JdbcTemplate jdbcTemplate;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public InterfaceUtilService(ProcessParamApi processParamApi, ErrorLogApi errorLogApi, ItemInterfaceApi itemInterfaceApi) {
        this.processParamApi = processParamApi;
        this.errorLogApi = errorLogApi;
        this.itemInterfaceApi = itemInterfaceApi;
    }

    @Async
    public Future<Boolean> asynInterface(String tenantId, String orgUnitId, String processSerialNumber, String itemId, InterfaceModel info, String processInstanceId, String taskId, String taskKey) {
        String string = tenantId;
        String string2 = orgUnitId;
        String string3 = processSerialNumber;
        String string4 = itemId;
        InterfaceModel interfaceModel = info;
        String string5 = processInstanceId;
        String string6 = taskId;
        String string7 = taskKey;
        Object[] objectArray = new Object[]{string, string2, string3, string4, interfaceModel, string5, string6, string7};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, string4, interfaceModel, string5, string6, string7, joinPoint};
        return (Future)AnnotationAsyncExecutionAspect.aspectOf().ajc$around$org_springframework_scheduling_aspectj_AbstractAsyncExecutionAspect$1$6c004c3e((AroundClosure)new InterfaceUtilService$AjcClosure1(objectArray2), ajc$tjp_0, joinPoint);
    }

    public void dataHandling(String processSerialNumber, String processInstanceId, Map<String, Object> map, List<InterfaceParamsModel> paramsList, InterfaceModel info) throws Exception {
        block13: {
            if (map != null && paramsList != null && !paramsList.isEmpty()) {
                try {
                    String tableName = "";
                    for (InterfaceParamsModel model : paramsList) {
                        if (!model.getBindType().equals(ItemInterfaceTypeEnum.INTERFACE_RESPONSE.getValue())) continue;
                        tableName = model.getTableName();
                        break;
                    }
                    DataSource database = Objects.requireNonNull(this.jdbcTemplate.getDataSource());
                    String dialect = DbMetaDataUtil.getDatabaseDialectName((DataSource)database);
                    StringBuilder sqlStr = new StringBuilder();
                    if ("oracle".equals(dialect)) {
                        sqlStr.append("update \"").append(tableName).append("\" set ");
                    } else if ("dm".equals(dialect)) {
                        sqlStr.append("update \"").append(tableName).append("\" set ");
                    } else if ("mysql".equals(dialect)) {
                        sqlStr.append("update ").append(tableName).append(" set ");
                    } else if ("kingbase".equals(dialect)) {
                        sqlStr.append("update \"").append(tableName).append("\" set ");
                    }
                    boolean isHaveField = false;
                    for (InterfaceParamsModel model : paramsList) {
                        if (!model.getBindType().equals(ItemInterfaceTypeEnum.INTERFACE_RESPONSE.getValue())) continue;
                        if (isHaveField) {
                            sqlStr.append(",");
                        }
                        String fieldName = model.getColumnName();
                        String parameterName = model.getParameterName();
                        sqlStr.append(fieldName).append("=");
                        sqlStr.append((String)(StringUtils.isNotBlank((CharSequence)((String)map.get(parameterName))) ? "'" + map.get(parameterName) + "'" : "''"));
                        isHaveField = true;
                    }
                    sqlStr.append(" where guid ='").append(processSerialNumber).append("'");
                    String sql = sqlStr.toString();
                    System.out.println("******************************sql:" + sql);
                    this.jdbcTemplate.execute(sql);
                }
                catch (Exception e) {
                    StringWriter msgResult = new StringWriter();
                    PrintWriter print = new PrintWriter(msgResult);
                    e.printStackTrace(print);
                    String msg = ((Object)msgResult).toString();
                    this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, "dataHandling", "", info.getInterfaceAddress(), msg);
                    if (!info.getAbnormalStop().equals("1")) break block13;
                    throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_dataHandling\uff1a" + info.getInterfaceAddress());
                }
            }
        }
    }

    public void getMethod(String processSerialNumber, String itemId, InterfaceModel info, String processInstanceId, String taskId, String taskKey) throws Exception {
        block14: {
            try {
                HttpClient client = new HttpClient();
                GetMethod method = new GetMethod();
                method.setPath(info.getInterfaceAddress());
                method.addRequestHeader("auth-positionId", Y9LoginUserHolder.getOrgUnitId());
                method.addRequestHeader("auth-tenantId", Y9LoginUserHolder.getTenantId());
                Y9Result y9Result = this.itemInterfaceApi.getInterfaceParams(Y9LoginUserHolder.getTenantId(), itemId, info.getId());
                ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
                if (y9Result.isSuccess() && y9Result.getData() != null && !((List)y9Result.getData()).isEmpty()) {
                    List<Map<String, Object>> list = this.getRequestParams((List)y9Result.getData(), processSerialNumber, processInstanceId, info);
                    for (InterfaceParamsModel model : (List)y9Result.getData()) {
                        String parameterValue;
                        if (!model.getBindType().equals(ItemInterfaceTypeEnum.INTERFACE_REQUEST.getValue())) continue;
                        if (model.getParameterType().equals(ItemInterfaceTypeEnum.PARAMS.getValue()) || model.getParameterType().equals(ItemInterfaceTypeEnum.BODY.getValue())) {
                            parameterValue = "";
                            for (Map<String, Object> map : list) {
                                if (!map.containsKey(model.getColumnName())) continue;
                                parameterValue = (String)map.get(model.getColumnName());
                                break;
                            }
                            nameValuePairs.add(new NameValuePair(model.getParameterName(), parameterValue));
                        }
                        if (!model.getParameterType().equals(ItemInterfaceTypeEnum.HEADERS.getValue())) continue;
                        parameterValue = "";
                        for (Map<String, Object> map : list) {
                            if (!map.containsKey(model.getColumnName())) continue;
                            parameterValue = (String)map.get(model.getColumnName());
                            break;
                        }
                        method.addRequestHeader(model.getParameterName(), parameterValue);
                    }
                }
                if (!nameValuePairs.isEmpty()) {
                    method.setQueryString(nameValuePairs.toArray(new NameValuePair[nameValuePairs.size()]));
                }
                client.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
                client.getHttpConnectionManager().getParams().setSoTimeout(10000);
                int httpCode = client.executeMethod((HttpMethod)method);
                if (httpCode == 200) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    String response = new String(method.getResponseBodyAsString().getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
                    Y9Result result = (Y9Result)objectMapper.readValue(response, Y9Result.class);
                    if (!result.isSuccess()) {
                        if (info.getAbnormalStop().equals("1")) {
                            this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, taskId, taskKey, info.getInterfaceAddress(), response);
                            throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_\u8fd4\u56de\u7ed3\u679c\uff1a" + response + "|" + info.getInterfaceAddress());
                        }
                    } else {
                        this.dataHandling(processSerialNumber, processInstanceId, (Map)result.getData(), (List)y9Result.getData(), info);
                    }
                    LOGGER.info("*********************\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:response={}", (Object)response);
                } else {
                    this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, taskId, taskKey, info.getInterfaceAddress(), "httpCode:" + httpCode);
                    if (info.getAbnormalStop().equals("1")) {
                        throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_\u8fd4\u56de\u72b6\u6001\uff1a" + httpCode + "|" + info.getInterfaceAddress());
                    }
                }
            }
            catch (Exception e) {
                StringWriter msgResult = new StringWriter();
                PrintWriter print = new PrintWriter(msgResult);
                e.printStackTrace(print);
                String msg = ((Object)msgResult).toString();
                this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, taskId, taskKey, info.getInterfaceAddress(), msg);
                if (!info.getAbnormalStop().equals("1")) break block14;
                throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_getMethod\uff1a" + info.getInterfaceAddress());
            }
        }
    }

    public List<Map<String, Object>> getRequestParams(List<InterfaceParamsModel> list, String processSerialNumber, String processInstanceId, InterfaceModel info) throws Exception {
        try {
            String tableName = "";
            for (InterfaceParamsModel model : list) {
                if (!model.getBindType().equals(ItemInterfaceTypeEnum.INTERFACE_REQUEST.getValue())) continue;
                tableName = model.getTableName();
                break;
            }
            DataSource dataSource = Objects.requireNonNull(this.jdbcTemplate.getDataSource());
            String dialect = DbMetaDataUtil.getDatabaseDialectName((DataSource)dataSource);
            StringBuilder sqlStr = this.getSqlStr(dialect, tableName);
            List listmap = this.jdbcTemplate.queryForList(sqlStr.toString(), new Object[]{processSerialNumber});
            LOGGER.info("*********************\u8bf7\u6c42\u53c2\u6570\u8fd4\u56de\u7ed3\u679c:listmap={}", (Object)Y9JsonUtil.writeValueAsString((Object)listmap));
            return listmap;
        }
        catch (Exception e) {
            StringWriter msgResult = new StringWriter();
            PrintWriter print = new PrintWriter(msgResult);
            e.printStackTrace(print);
            String msg = ((Object)msgResult).toString();
            this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, "getRequestParams", "", info.getInterfaceAddress(), msg);
            if (info.getAbnormalStop().equals("1")) {
                throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_getRequestParams\uff1a" + info.getInterfaceAddress());
            }
            return new ArrayList<Map<String, Object>>();
        }
    }

    private StringBuilder getSqlStr(String dialect, String tableName) {
        StringBuilder sqlStr = new StringBuilder();
        if ("oracle".equals(dialect)) {
            sqlStr = new StringBuilder("SELECT * FROM \"" + tableName + "\" where guid =?");
        } else if ("dm".equals(dialect)) {
            sqlStr = new StringBuilder("SELECT * FROM \"" + tableName + "\" where guid =?");
        } else if ("kingbase".equals(dialect)) {
            sqlStr = new StringBuilder("SELECT * FROM \"" + tableName + "\" where guid =?");
        } else if ("mysql".equals(dialect)) {
            sqlStr = new StringBuilder("SELECT * FROM " + tableName + " where guid =?");
        }
        return sqlStr;
    }

    public void interfaceCallByProcess(ExecutionEntityImpl executionEntity, Map<String, Object> variables, String condition) throws Exception {
        String processDefinitionId = executionEntity.getProcessDefinitionId();
        String taskDefinitionKey = "";
        String tenantId = "";
        String processSerialNumber = "";
        String processInstanceId = executionEntity.getProcessInstanceId();
        String itemId = "";
        String orgUnitId = Y9LoginUserHolder.getOrgUnitId();
        Y9Result y9Result = null;
        try {
            tenantId = FlowableTenantInfoHolder.getTenantId();
            processSerialNumber = (String)variables.get("processSerialNumber");
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
            itemId = processParamModel.getItemId();
            y9Result = this.itemInterfaceApi.getInterface(tenantId, itemId, taskDefinitionKey, processDefinitionId, condition);
        }
        catch (Exception e) {
            StringWriter result = new StringWriter();
            PrintWriter print = new PrintWriter(result);
            e.printStackTrace(print);
            String msg = ((Object)result).toString();
            this.saveErrorLog(tenantId, processInstanceId, "", "", "interfaceCallByProcess", msg);
        }
        if (y9Result != null && y9Result.isSuccess() && y9Result.getData() != null && !((List)y9Result.getData()).isEmpty()) {
            for (InterfaceModel info : (List)y9Result.getData()) {
                if (info.getAsyn().equals("1")) {
                    this.asynInterface(tenantId, orgUnitId, processSerialNumber, itemId, info, processInstanceId, "", "");
                    continue;
                }
                if (!info.getAsyn().equals("0")) continue;
                this.syncInterface(processSerialNumber, itemId, info, processInstanceId, "", "");
            }
        }
    }

    public void interfaceCallBySequenceFlow(FlowableSequenceFlowTakenEventImpl flow, String condition) throws Exception {
        String processDefinitionId = flow.getProcessDefinitionId();
        String taskDefinitionKey = flow.getId();
        String tenantId = "";
        String processInstanceId = "";
        String processSerialNumber = "";
        String itemId = "";
        Y9Result y9Result = null;
        String orgUnitId = Y9LoginUserHolder.getOrgUnitId();
        try {
            tenantId = FlowableTenantInfoHolder.getTenantId();
            processInstanceId = flow.getProcessInstanceId();
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessInstanceId(tenantId, processInstanceId).getData();
            if (processParamModel == null) {
                LOGGER.info("*********************\u6d41\u7a0b\u5b9e\u4f8bID:{}", (Object)processInstanceId);
                return;
            }
            itemId = processParamModel.getItemId();
            processSerialNumber = processParamModel.getProcessSerialNumber();
            y9Result = this.itemInterfaceApi.getInterface(tenantId, itemId, taskDefinitionKey, processDefinitionId, condition);
        }
        catch (Exception e) {
            StringWriter result = new StringWriter();
            PrintWriter print = new PrintWriter(result);
            e.printStackTrace(print);
            String msg = ((Object)result).toString();
            this.saveErrorLog(tenantId, processInstanceId, flow.getId(), flow.getId(), "interfaceCallBySequenceFlow", msg);
        }
        if (y9Result != null && y9Result.isSuccess() && y9Result.getData() != null && !((List)y9Result.getData()).isEmpty()) {
            for (InterfaceModel info : (List)y9Result.getData()) {
                if (info.getAsyn().equals("1")) {
                    this.asynInterface(tenantId, orgUnitId, processSerialNumber, itemId, info, processInstanceId, flow.getId(), taskDefinitionKey);
                    continue;
                }
                if (!info.getAsyn().equals("0")) continue;
                this.syncInterface(processSerialNumber, itemId, info, processInstanceId, flow.getId(), taskDefinitionKey);
            }
        }
    }

    public void interfaceCallByTask(DelegateTask task, Map<String, Object> variables, String condition) throws Exception {
        String processDefinitionId = task.getProcessDefinitionId();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        String tenantId = "";
        String processSerialNumber = "";
        String itemId = "";
        String orgUnitId = task.getAssignee();
        Y9Result y9Result = null;
        try {
            tenantId = FlowableTenantInfoHolder.getTenantId();
            processSerialNumber = (String)variables.get("processSerialNumber");
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
            itemId = processParamModel.getItemId();
            y9Result = this.itemInterfaceApi.getInterface(tenantId, itemId, taskDefinitionKey, processDefinitionId, condition);
        }
        catch (Exception e) {
            StringWriter result = new StringWriter();
            PrintWriter print = new PrintWriter(result);
            e.printStackTrace(print);
            String msg = ((Object)result).toString();
            this.saveErrorLog(tenantId, task.getProcessInstanceId(), task.getId(), task.getTaskDefinitionKey(), "interfaceCallByTask", msg);
        }
        if (y9Result != null && y9Result.isSuccess() && y9Result.getData() != null && !((List)y9Result.getData()).isEmpty()) {
            for (InterfaceModel info : (List)y9Result.getData()) {
                if (info.getAsyn().equals("1")) {
                    this.asynInterface(tenantId, orgUnitId, processSerialNumber, itemId, info, task.getProcessInstanceId(), task.getId(), task.getTaskDefinitionKey());
                    continue;
                }
                if (!info.getAsyn().equals("0")) continue;
                this.syncInterface(processSerialNumber, itemId, info, task.getProcessInstanceId(), task.getId(), task.getTaskDefinitionKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMethod(String processSerialNumber, String itemId, InterfaceModel info, String processInstanceId, String taskId, String taskKey) throws Exception {
        CloseableHttpClient httpclient = null;
        try {
            httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(info.getInterfaceAddress());
            httpPost.addHeader("Content-Type", "application/json;charset=utf-8");
            httpPost.addHeader("auth-positionId", Y9LoginUserHolder.getOrgUnitId());
            httpPost.addHeader("auth-tenantId", Y9LoginUserHolder.getTenantId());
            Y9Result y9Result = this.itemInterfaceApi.getInterfaceParams(Y9LoginUserHolder.getTenantId(), itemId, info.getId());
            if (y9Result.isSuccess() && y9Result.getData() != null && !((List)y9Result.getData()).isEmpty()) {
                List<Map<String, Object>> list = this.getRequestParams((List)y9Result.getData(), processSerialNumber, processInstanceId, info);
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                for (InterfaceParamsModel model : (List)y9Result.getData()) {
                    String parameterValue;
                    if (!model.getBindType().equals(ItemInterfaceTypeEnum.INTERFACE_REQUEST.getValue())) continue;
                    if (model.getParameterType().equals(ItemInterfaceTypeEnum.PARAMS.getValue()) || model.getParameterType().equals(ItemInterfaceTypeEnum.BODY.getValue())) {
                        parameterValue = "";
                        for (Map<String, Object> map : list) {
                            if (!map.containsKey(model.getColumnName())) continue;
                            parameterValue = (String)map.get(model.getColumnName());
                            break;
                        }
                        paramsMap.put(model.getParameterName(), parameterValue);
                    }
                    if (!model.getParameterType().equals(ItemInterfaceTypeEnum.HEADERS.getValue())) continue;
                    parameterValue = "";
                    for (Map<String, Object> map : list) {
                        if (!map.containsKey(model.getColumnName())) continue;
                        parameterValue = (String)map.get(model.getColumnName());
                        break;
                    }
                    httpPost.addHeader(model.getParameterName(), parameterValue);
                }
                JSONObject jsonString = new JSONObject(paramsMap);
                StringEntity entity = new StringEntity(jsonString.toString(), Consts.UTF_8);
                httpPost.setEntity((HttpEntity)entity);
            }
            String urlStr = httpPost.getURI().toString();
            httpPost.setURI(new URI(urlStr));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int httpCode = response.getStatusLine().getStatusCode();
            if (httpCode == 200) {
                ObjectMapper objectMapper = new ObjectMapper();
                String resp = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                Y9Result result = (Y9Result)objectMapper.readValue(resp, Y9Result.class);
                if (!result.isSuccess()) {
                    this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, taskId, taskKey, info.getInterfaceAddress(), resp);
                    if (info.getAbnormalStop().equals("1")) {
                        throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_\u8fd4\u56de\u7ed3\u679c\uff1a" + resp + "|" + info.getInterfaceAddress());
                    }
                } else {
                    this.dataHandling(processSerialNumber, processInstanceId, (Map)result.getData(), (List)y9Result.getData(), info);
                }
                LOGGER.info("*********************\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:response={}", (Object)resp);
            } else {
                this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, taskId, taskKey, info.getInterfaceAddress(), "httpCode:" + httpCode);
                if (info.getAbnormalStop().equals("1")) {
                    throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_\u8fd4\u56de\u72b6\u6001\uff1a" + httpCode + "|" + info.getInterfaceAddress());
                }
            }
        }
        catch (Exception e) {
            StringWriter msgResult = new StringWriter();
            PrintWriter print = new PrintWriter(msgResult);
            e.printStackTrace(print);
            String msg = ((Object)msgResult).toString();
            this.saveErrorLog(Y9LoginUserHolder.getTenantId(), processInstanceId, taskId, taskKey, info.getInterfaceAddress(), msg);
            if (info.getAbnormalStop().equals("1")) {
                throw new Exception("\u8c03\u7528\u63a5\u53e3\u5931\u8d25_postMethod\uff1a" + info.getInterfaceAddress());
            }
        }
        finally {
            if (httpclient != null) {
                try {
                    httpclient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Async
    public Future<Boolean> saveErrorLog(String tenantId, String processInstanceId, String taskId, String taskKey, String interfaceAddress, String msg) {
        String string = tenantId;
        String string2 = processInstanceId;
        String string3 = taskId;
        String string4 = taskKey;
        String string5 = interfaceAddress;
        String string6 = msg;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, string4, string5, string6, joinPoint};
        return (Future)AnnotationAsyncExecutionAspect.aspectOf().ajc$around$org_springframework_scheduling_aspectj_AbstractAsyncExecutionAspect$1$6c004c3e((AroundClosure)new InterfaceUtilService$AjcClosure3(objectArray2), ajc$tjp_1, joinPoint);
    }

    public void syncInterface(String processSerialNumber, String itemId, InterfaceModel info, String processInstanceId, String taskId, String taskKey) throws Exception {
        if (info.getRequestType().equals(ItemInterfaceTypeEnum.METHOD_GET.getValue())) {
            this.getMethod(processSerialNumber, itemId, info, processInstanceId, taskId, taskKey);
        } else if (info.getRequestType().equals(ItemInterfaceTypeEnum.METHOD_POST.getValue())) {
            this.postMethod(processSerialNumber, itemId, info, processInstanceId, taskId, taskKey);
        }
    }

    static {
        InterfaceUtilService.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(InterfaceUtilService.class);
    }

    static final /* synthetic */ Future asynInterface_aroundBody0(InterfaceUtilService ajc$this, String tenantId, String orgUnitId, String processSerialNumber, String itemId, InterfaceModel info, String processInstanceId, String taskId, String taskKey, JoinPoint joinPoint) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setOrgUnitId((String)orgUnitId);
        try {
            if (info.getRequestType().equals(ItemInterfaceTypeEnum.METHOD_GET.getValue())) {
                ajc$this.getMethod(processSerialNumber, itemId, info, processInstanceId, taskId, taskKey);
            } else if (info.getRequestType().equals(ItemInterfaceTypeEnum.METHOD_POST.getValue())) {
                ajc$this.postMethod(processSerialNumber, itemId, info, processInstanceId, taskId, taskKey);
            }
            return new AsyncResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            return new AsyncResult((Object)false);
        }
    }

    static final /* synthetic */ Future saveErrorLog_aroundBody2(InterfaceUtilService ajc$this, String tenantId, String processInstanceId, String taskId, String taskKey, String interfaceAddress, String msg, JoinPoint joinPoint) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = sdf.format(new Date());
            ErrorLogModel errorLogModel = new ErrorLogModel();
            errorLogModel.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
            errorLogModel.setCreateTime(time);
            errorLogModel.setErrorFlag("\u63a5\u53e3\u8c03\u7528\u9519\u8bef:" + taskKey);
            errorLogModel.setErrorType("processInstanceError");
            errorLogModel.setExtendField(interfaceAddress);
            errorLogModel.setProcessInstanceId(processInstanceId);
            errorLogModel.setTaskId(taskId);
            errorLogModel.setText(msg);
            errorLogModel.setUpdateTime(time);
            ajc$this.errorLogApi.saveErrorLog(tenantId, errorLogModel);
            return new AsyncResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9519\u8bef\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            return new AsyncResult((Object)false);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("InterfaceUtilService.java", InterfaceUtilService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "asynInterface", "net.risesoft.service.InterfaceUtilService", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:net.risesoft.model.itemadmin.InterfaceModel:java.lang.String:java.lang.String:java.lang.String", "tenantId:orgUnitId:processSerialNumber:itemId:info:processInstanceId:taskId:taskKey", "", "java.util.concurrent.Future"), 99);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveErrorLog", "net.risesoft.service.InterfaceUtilService", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "tenantId:processInstanceId:taskId:taskKey:interfaceAddress:msg", "", "java.util.concurrent.Future"), 608);
    }
}

