/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.processadmin.VariableApi;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomVariableService;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/variable"})
public class VariableApiImpl
implements VariableApi {
    private final CustomVariableService customVariableService;
    private final TaskService taskService;
    private final RuntimeService runtimeService;

    public Y9Result<Object> deleteVariable(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam String key) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customVariableService.deleteVariable(taskId, key);
        return Y9Result.success();
    }

    public Y9Result<Object> deleteVariableLocal(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam String key) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customVariableService.removeVariableLocal(taskId, key);
        return Y9Result.success();
    }

    public Y9Result<String> getVariable(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam String key) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Object o = this.customVariableService.getVariable(taskId, key);
        return Y9Result.success((Object)(o != null ? Y9JsonUtil.writeValueAsString((Object)o) : null));
    }

    public Y9Result<String> getVariableByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String key) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Object o = this.runtimeService.getVariable(processInstanceId, key);
        return Y9Result.success((Object)(o != null ? Y9JsonUtil.writeValueAsString((Object)o) : null));
    }

    public Y9Result<String> getVariableLocal(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam String key) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Object o = this.taskService.getVariableLocal(taskId, key);
        return Y9Result.success((Object)(o != null ? Y9JsonUtil.writeValueAsString((Object)o) : null));
    }

    public Y9Result<Map<String, Object>> getVariables(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success(this.customVariableService.getVariables(taskId));
    }

    public Y9Result<Map<String, Object>> getVariablesByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestBody Collection<String> keys) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.runtimeService.getVariables(processInstanceId, keys));
    }

    public Y9Result<Map<String, Object>> getVariablesLocal(@RequestParam String tenantId, @RequestParam String taskId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return Y9Result.success(this.customVariableService.getVariables(taskId));
    }

    public Y9Result<Object> setVariable(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam String key, @RequestBody Map<String, Object> map) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customVariableService.setVariable(taskId, key, map.get("val"));
        return Y9Result.success();
    }

    public Y9Result<Object> setVariableByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String key, @RequestBody Map<String, Object> map) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.runtimeService.setVariable(processInstanceId, key, map.get("val"));
        return Y9Result.success();
    }

    public Y9Result<Object> setVariableLocal(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam String key, @RequestBody Map<String, Object> map) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customVariableService.setVariableLocal(taskId, key, map.get("val"));
        return Y9Result.success();
    }

    public Y9Result<Object> setVariables(@RequestParam String tenantId, @RequestParam String taskId, @RequestBody Map<String, Object> map) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customVariableService.setVariables(taskId, map);
        return Y9Result.success();
    }

    public Y9Result<Object> setVariablesLocal(@RequestParam String tenantId, @RequestParam String taskId, @RequestBody Map<String, Object> map) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.customVariableService.setVariablesLocal(taskId, map);
        return Y9Result.success();
    }

    @Generated
    public VariableApiImpl(CustomVariableService customVariableService, TaskService taskService, RuntimeService runtimeService) {
        this.customVariableService = customVariableService;
        this.taskService = taskService;
        this.runtimeService = runtimeService;
    }
}

