/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.processadmin.RepositoryApi;
import net.risesoft.model.processadmin.ProcessDefinitionModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomRepositoryService;
import net.risesoft.util.FlowableModelConvertUtil;
import net.risesoft.y9.FlowableTenantInfoHolder;
import org.apache.commons.io.IOUtils;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/services/rest/repository"}, produces={"application/json"})
public class RepositoryApiImpl
implements RepositoryApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryApiImpl.class);
    private final CustomRepositoryService customRepositoryService;

    public Y9Result<Object> delete(@RequestParam String tenantId, @RequestParam String deploymentId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customRepositoryService.delete(deploymentId);
    }

    public Y9Result<Object> deploy(@RequestParam String tenantId, MultipartFile file) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customRepositoryService.deploy(file);
    }

    public Y9Result<ProcessDefinitionModel> getLatestProcessDefinitionByKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        ProcessDefinition pd = this.customRepositoryService.getLatestProcessDefinitionByKey(processDefinitionKey);
        return Y9Result.success((Object)FlowableModelConvertUtil.processDefinition2Model(pd));
    }

    public Y9Result<List<ProcessDefinitionModel>> getLatestProcessDefinitionList(@RequestParam String tenantId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<ProcessDefinition> pdList = this.customRepositoryService.listLatestProcessDefinition();
        return Y9Result.success(FlowableModelConvertUtil.processDefinitionList2ModelList(pdList));
    }

    public Y9Result<ProcessDefinitionModel> getPreviousProcessDefinitionById(@RequestParam String tenantId, @RequestParam String processDefinitionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        ProcessDefinition pd = this.customRepositoryService.getPreviousProcessDefinitionById(processDefinitionId);
        return Y9Result.success((Object)FlowableModelConvertUtil.processDefinition2Model(pd));
    }

    public Y9Result<ProcessDefinitionModel> getProcessDefinitionById(@RequestParam String tenantId, @RequestParam String processDefinitionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        ProcessDefinition pd = this.customRepositoryService.getProcessDefinitionById(processDefinitionId);
        return Y9Result.success((Object)FlowableModelConvertUtil.processDefinition2Model(pd));
    }

    public Y9Result<List<ProcessDefinitionModel>> getProcessDefinitionListByKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        List<ProcessDefinition> pdList = this.customRepositoryService.listProcessDefinitionByKey(processDefinitionKey);
        return Y9Result.success(FlowableModelConvertUtil.processDefinitionList2ModelList(pdList));
    }

    public Y9Result<String> getXmlByProcessInstance(@RequestParam String tenantId, @RequestParam String resourceType, @RequestParam String processInstanceId, @RequestParam String processDefinitionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        InputStream resourceAsStream = this.customRepositoryService.getProcessInstance(resourceType, processInstanceId, processDefinitionId);
        try {
            String xmlStr = IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8);
            return Y9Result.success((Object)xmlStr);
        }
        catch (IOException e) {
            LOGGER.error("\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49xml\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49xml\u5931\u8d25");
        }
    }

    public Y9Result<List<ProcessDefinitionModel>> list(@RequestParam String tenantId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customRepositoryService.list("");
    }

    public Y9Result<Object> switchSuspendOrActive(@RequestParam String tenantId, @RequestParam String state, @RequestParam String processDefinitionId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        return this.customRepositoryService.switchSuspendOrActive(state, processDefinitionId);
    }

    @Generated
    public RepositoryApiImpl(CustomRepositoryService customRepositoryService) {
        this.customRepositoryService = customRepositoryService;
    }
}

