/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import lombok.Generated;
import net.risesoft.api.itemadmin.OfficeDoneInfoApi;
import net.risesoft.api.itemadmin.ProcessParamApi;
import net.risesoft.api.itemadmin.ProcessTrackApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.processadmin.BpmnModelApi;
import net.risesoft.model.itemadmin.OfficeDoneInfoModel;
import net.risesoft.model.itemadmin.ProcessParamModel;
import net.risesoft.model.itemadmin.ProcessTrackModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.processadmin.FlowNodeModel;
import net.risesoft.model.processadmin.FlowableBpmnModel;
import net.risesoft.model.processadmin.LinkNodeModel;
import net.risesoft.model.processadmin.Y9BpmnModel;
import net.risesoft.model.processadmin.Y9FlowChartModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CustomHistoricActivityService;
import net.risesoft.service.CustomHistoricProcessService;
import net.risesoft.service.CustomHistoricTaskService;
import net.risesoft.service.CustomHistoricVariableService;
import net.risesoft.y9.FlowableTenantInfoHolder;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9Util;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.BpmnAutoLayout;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.image.ProcessDiagramGenerator;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.ui.common.util.XmlUtil;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.model.ModelRepresentation;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.flowable.validation.ProcessValidator;
import org.flowable.validation.ProcessValidatorFactory;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/services/rest/bpmnModel"})
public class BpmnModelApiImpl
implements BpmnModelApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnModelApiImpl.class);
    private final CustomHistoricProcessService customHistoricProcessService;
    private final CustomHistoricTaskService customHistoricTaskService;
    private final CustomHistoricVariableService customHistoricVariableService;
    private final TaskService taskService;
    private final RuntimeService runtimeService;
    private final CustomHistoricActivityService customHistoricActivityService;
    private final RepositoryService repositoryService;
    private final OrgUnitApi orgUnitApi;
    private final OfficeDoneInfoApi officeDoneInfoManager;
    private final ProcessParamApi processParamManager;
    private final ProcessTrackApi processTrackManager;
    private final ModelService modelService;
    private final ModelRepository modelRepository;

    public Y9Result<Object> deleteModel(@RequestParam String tenantId, @RequestParam String modelId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        this.modelService.deleteModel(modelId);
        return Y9Result.success();
    }

    public Y9Result<Object> deployModel(@RequestParam String tenantId, @RequestParam String modelId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Model modelData = this.modelService.getModel(modelId);
        BpmnModel model = this.modelService.getBpmnModel((AbstractModel)modelData);
        if (model.getProcesses().isEmpty()) {
            return Y9Result.failure((String)"\u6570\u636e\u6a21\u578b\u4e0d\u7b26\u8981\u6c42\uff0c\u8bf7\u81f3\u5c11\u8bbe\u8ba1\u4e00\u6761\u4e3b\u7ebf\u6d41\u7a0b\u3002");
        }
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(model);
        String processName = modelData.getName() + ".bpmn20.xml";
        this.repositoryService.createDeployment().name(modelData.getName()).addBytes(processName, bpmnBytes).deploy();
        return Y9Result.success();
    }

    public Y9Result<String> genProcessDiagram(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        byte[] buf;
        InputStream in;
        FlowableTenantInfoHolder.setTenantId(tenantId);
        HistoricProcessInstance pi = this.customHistoricProcessService.getById(processInstanceId);
        if (pi == null) {
            return null;
        }
        ProcessEngine processEngine = (ProcessEngine)Y9Context.getBean(ProcessEngine.class);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(pi.getProcessDefinitionId());
        ProcessEngineConfiguration engConf = processEngine.getProcessEngineConfiguration();
        ProcessDiagramGenerator diagramGenerator = engConf.getProcessDiagramGenerator();
        if (pi.getEndTime() == null) {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId())).singleResult();
            String instanceId = task.getProcessInstanceId();
            List executions = this.runtimeService.createExecutionQuery().processInstanceId(instanceId).list();
            ArrayList activityIds = new ArrayList();
            ArrayList flows = new ArrayList();
            for (Execution exe : executions) {
                List ids = this.runtimeService.getActiveActivityIds(exe.getId());
                activityIds.addAll(ids);
            }
            in = diagramGenerator.generateDiagram(bpmnModel, "png", activityIds, flows, engConf.getActivityFontName(), engConf.getLabelFontName(), engConf.getAnnotationFontName(), engConf.getClassLoader(), 1.0, false);
        } else {
            in = diagramGenerator.generateDiagram(bpmnModel, "png", engConf.getActivityFontName(), engConf.getLabelFontName(), engConf.getAnnotationFontName(), engConf.getClassLoader(), false);
        }
        try {
            buf = IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Y9Result.success((Object)Base64.getEncoder().encodeToString(buf));
    }

    public Y9Result<Y9BpmnModel> getBpmnModel(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        HistoricProcessInstance pi = this.customHistoricProcessService.getById(processInstanceId);
        if (pi == null) {
            return Y9Result.failure((String)"\u6d41\u7a0b\u5df2\u529e\u7ed3");
        }
        String txtFlowPath = "";
        ArrayList<FlowNodeModel> nodeDataArray = new ArrayList<FlowNodeModel>();
        ArrayList<LinkNodeModel> linkDataArray = new ArrayList<LinkNodeModel>();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(pi.getProcessDefinitionId());
        Map infoMap = bpmnModel.getLocationMap();
        Process process = (Process)bpmnModel.getProcesses().get(0);
        List flowElements = (List)process.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            UserTask u;
            FlowElement fe;
            List list;
            GraphicInfo graphicInfo;
            if (flowElement instanceof StartEvent) {
                StartEvent startEvent = (StartEvent)flowElement;
                graphicInfo = (GraphicInfo)infoMap.get(startEvent.getId());
                txtFlowPath = startEvent.getId();
                nodeDataArray.add(new FlowNodeModel(startEvent.getId(), "Start", "\u5f00\u59cb", "Circle", "#4fba4f", "1", graphicInfo.getX() - 100.0 + " " + graphicInfo.getY(), ""));
                list = startEvent.getOutgoingFlows();
                for (SequenceFlow tr : list) {
                    fe = tr.getTargetFlowElement();
                    if (!(fe instanceof UserTask)) continue;
                    u = (UserTask)fe;
                    linkDataArray.add(new LinkNodeModel(startEvent.getId(), u.getId()));
                }
                continue;
            }
            if (flowElement instanceof UserTask) {
                UserTask userTask = (UserTask)flowElement;
                graphicInfo = (GraphicInfo)infoMap.get(userTask.getId());
                nodeDataArray.add(new FlowNodeModel(userTask.getId(), "", userTask.getName(), "", "", "", graphicInfo.getX() + " " + graphicInfo.getY(), "111111111"));
                list = userTask.getOutgoingFlows();
                for (SequenceFlow tr : list) {
                    UserTask task;
                    FlowElement element;
                    List outgoingFlows;
                    ExclusiveGateway gateway;
                    fe = tr.getTargetFlowElement();
                    if (fe instanceof ExclusiveGateway) {
                        gateway = (ExclusiveGateway)fe;
                        outgoingFlows = gateway.getOutgoingFlows();
                        for (SequenceFlow sf : outgoingFlows) {
                            element = sf.getTargetFlowElement();
                            if (element instanceof UserTask) {
                                task = (UserTask)element;
                                linkDataArray.add(new LinkNodeModel(userTask.getId(), task.getId()));
                                continue;
                            }
                            if (element instanceof EndEvent) {
                                EndEvent endEvent = (EndEvent)element;
                                linkDataArray.add(new LinkNodeModel(userTask.getId(), endEvent.getId()));
                                continue;
                            }
                            if (!(element instanceof ParallelGateway)) continue;
                            ParallelGateway parallelgateway = (ParallelGateway)element;
                            List outgoingFlows1 = parallelgateway.getOutgoingFlows();
                            for (SequenceFlow sf1 : outgoingFlows1) {
                                FlowElement element1 = sf1.getTargetFlowElement();
                                if (!(element1 instanceof UserTask)) continue;
                                UserTask task1 = (UserTask)element1;
                                linkDataArray.add(new LinkNodeModel(userTask.getId(), task1.getId()));
                            }
                        }
                        continue;
                    }
                    if (fe instanceof UserTask) {
                        u = (UserTask)fe;
                        linkDataArray.add(new LinkNodeModel(userTask.getId(), u.getId()));
                        continue;
                    }
                    if (fe instanceof EndEvent) {
                        EndEvent endEvent = (EndEvent)fe;
                        linkDataArray.add(new LinkNodeModel(userTask.getId(), endEvent.getId()));
                        continue;
                    }
                    if (!(fe instanceof ParallelGateway)) continue;
                    gateway = (ParallelGateway)fe;
                    outgoingFlows = gateway.getOutgoingFlows();
                    for (SequenceFlow sf : outgoingFlows) {
                        element = sf.getTargetFlowElement();
                        if (!(element instanceof UserTask)) continue;
                        task = (UserTask)element;
                        linkDataArray.add(new LinkNodeModel(userTask.getId(), task.getId()));
                    }
                }
                continue;
            }
            if (!(flowElement instanceof EndEvent)) continue;
            EndEvent endEvent = (EndEvent)flowElement;
            graphicInfo = (GraphicInfo)infoMap.get(endEvent.getId());
            nodeDataArray.add(new FlowNodeModel(endEvent.getId(), "End", "\u7ed3\u675f", "Circle", "#CE0620", "4", graphicInfo.getX() + " " + graphicInfo.getY(), ""));
        }
        List<HistoricTaskInstance> list = this.customHistoricTaskService.listByProcessInstanceId(processInstanceId, "");
        for (HistoricTaskInstance task : list) {
            txtFlowPath = Y9Util.genCustomStr((String)txtFlowPath, (String)task.getTaskDefinitionKey());
        }
        return Y9Result.success((Object)new Y9BpmnModel(nodeDataArray, linkDataArray, txtFlowPath, pi.getEndTime() != null));
    }

    public Y9Result<Y9FlowChartModel> getFlowChart(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        Y9FlowChartModel flowChartModel = new Y9FlowChartModel();
        FlowableTenantInfoHolder.setTenantId(tenantId);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<Y9FlowChartModel> listMap = new ArrayList<Y9FlowChartModel>();
        String activityId = "";
        String parentId = "";
        String year = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            HistoricProcessInstance hpi = this.customHistoricProcessService.getById(processInstanceId);
            if (hpi == null) {
                OfficeDoneInfoModel officeDoneInfo = (OfficeDoneInfoModel)this.officeDoneInfoManager.findByProcessInstanceId(tenantId, processInstanceId).getData();
                if (officeDoneInfo == null) {
                    ProcessParamModel processParam = (ProcessParamModel)this.processParamManager.findByProcessInstanceId(tenantId, processInstanceId).getData();
                    year = processParam.getCreateTime().substring(0, 4);
                } else {
                    year = officeDoneInfo.getStartTime().substring(0, 4);
                }
            }
            List<HistoricActivityInstance> list = this.customHistoricActivityService.listByProcessInstanceIdAndYear(processInstanceId, year);
            list.sort((o1, o2) -> {
                if (o1.getEndTime() == null || o2.getEndTime() == null) {
                    return 0;
                }
                long endTime1 = o1.getEndTime().getTime();
                long endTime2 = o2.getEndTime().getTime();
                return Long.compare(endTime1, endTime2);
            });
            int num = 0;
            for (HistoricActivityInstance his : list) {
                Y9FlowChartModel flowChart;
                HistoricVariableInstance historicVariableInstance;
                String id = his.getId();
                String taskId = his.getTaskId();
                String type = his.getActivityType();
                if (type.contains("startEvent") || type.contains("Flow")) continue;
                if (type.contains("endEvent")) {
                    ++num;
                    String completer = ((Y9FlowChartModel)listMap.get(listMap.size() - 1)).getTitle();
                    if (completer.contains("\u4e3b\u529e")) {
                        completer = completer.substring(0, completer.length() - 4);
                    }
                    Y9FlowChartModel flowChart2 = new Y9FlowChartModel();
                    flowChart2.setId(id);
                    flowChart2.setName("\u529e\u7ed3");
                    flowChart2.setTitle(completer);
                    flowChart2.setParentId(parentId);
                    flowChart2.setClassName("specialColor");
                    flowChart2.setNum(num);
                    flowChart2.setEndTime(his.getEndTime() != null ? his.getEndTime().getTime() : 0L);
                    listMap.add(flowChart2);
                    continue;
                }
                if (type.contains("Gateway")) {
                    ++num;
                    continue;
                }
                String userId = his.getAssignee();
                OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
                if ("".equals(activityId) || activityId.equals(his.getActivityId())) {
                    historicVariableInstance = this.customHistoricVariableService.getByTaskIdAndVariableName(taskId, "parallelSponsor", year);
                    flowChart = new Y9FlowChartModel();
                    flowChart.setId(taskId);
                    flowChart.setName(his.getActivityName());
                    flowChart.setTitle(orgUnit != null ? orgUnit.getName() : "\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
                    if (historicVariableInstance != null) {
                        flowChart.setTitle((String)(orgUnit != null ? orgUnit.getName() + "(\u4e3b\u529e)" : "\u8be5\u7528\u6237\u4e0d\u5b58\u5728"));
                    }
                    flowChart.setParentId(parentId);
                    flowChart.setClassName(his.getEndTime() != null ? "serverColor" : "specialColor");
                    flowChart.setNum(num);
                    flowChart.setEndTime(his.getEndTime() != null ? his.getEndTime().getTime() : 0L);
                    listMap.add(flowChart);
                    activityId = his.getActivityId();
                    parentId = taskId;
                } else {
                    ++num;
                    activityId = his.getActivityId();
                    historicVariableInstance = this.customHistoricVariableService.getByTaskIdAndVariableName(taskId, "parallelSponsor", year);
                    flowChart = new Y9FlowChartModel();
                    flowChart.setId(taskId);
                    flowChart.setName(his.getActivityName());
                    flowChart.setTitle(orgUnit != null ? orgUnit.getName() : "\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
                    if (historicVariableInstance != null) {
                        flowChart.setTitle((String)(orgUnit != null ? orgUnit.getName() + "(\u4e3b\u529e)" : "\u8be5\u7528\u6237\u4e0d\u5b58\u5728"));
                    }
                    flowChart.setParentId(parentId);
                    flowChart.setClassName(his.getEndTime() != null ? "serverColor" : "specialColor");
                    flowChart.setNum(num);
                    flowChart.setEndTime(his.getEndTime() != null ? his.getEndTime().getTime() : 0L);
                    listMap.add(flowChart);
                }
                List ptList = (List)this.processTrackManager.findByTaskIdAsc(tenantId, taskId).getData();
                String parentId0 = taskId;
                for (int j = 0; j < ptList.size(); ++j) {
                    ++num;
                    ProcessTrackModel pt = (ProcessTrackModel)ptList.get(j);
                    if (j != 0) {
                        parentId0 = pt.getId();
                    }
                    Y9FlowChartModel flowChart3 = new Y9FlowChartModel();
                    flowChart3.setId(pt.getId());
                    flowChart3.setName(pt.getTaskDefName());
                    flowChart3.setTitle(pt.getSenderName());
                    flowChart3.setParentId(parentId0);
                    flowChart3.setClassName(StringUtils.isNotBlank((CharSequence)pt.getEndTime()) ? "serverColor" : "specialColor");
                    flowChart3.setNum(num);
                    flowChart3.setEndTime(StringUtils.isNotBlank((CharSequence)pt.getEndTime()) ? sdf.parse(pt.getEndTime()).getTime() : 0L);
                    listMap.add(flowChart3);
                    if (j != ptList.size() - 1) continue;
                    parentId = parentId0;
                }
            }
            int oldNum = 0;
            int newNum = 0;
            for (int i = 0; i < listMap.size(); ++i) {
                Y9FlowChartModel y9FlowChartModel = (Y9FlowChartModel)listMap.get(i);
                int currNum = y9FlowChartModel.getNum();
                if (currNum == 0) {
                    parentId = y9FlowChartModel.getId();
                    y9FlowChartModel.setParentId("");
                }
                if (currNum == oldNum) continue;
                y9FlowChartModel.setParentId(parentId);
                if (newNum == 0) {
                    newNum = currNum;
                }
                if (newNum == currNum) continue;
                oldNum = newNum;
                newNum = currNum;
                parentId = ((Y9FlowChartModel)listMap.get(i - 1)).getId();
                y9FlowChartModel.setParentId(parentId);
            }
            parentId = "0";
            ArrayList<Y9FlowChartModel> childrenMap = new ArrayList<Y9FlowChartModel>();
            for (int i = listMap.size() - 1; i >= 0; --i) {
                Y9FlowChartModel y9FlowChartModel = (Y9FlowChartModel)listMap.get(i);
                String id = y9FlowChartModel.getId();
                if (StringUtils.isNotBlank((CharSequence)parentId) && !parentId.equals(id)) {
                    parentId = y9FlowChartModel.getParentId();
                    childrenMap.add(y9FlowChartModel);
                    continue;
                }
                y9FlowChartModel.setChildren(childrenMap);
                y9FlowChartModel.setCollapsed(false);
                parentId = y9FlowChartModel.getParentId();
                childrenMap = new ArrayList();
                childrenMap.add(y9FlowChartModel);
                if (!"".equals(parentId)) continue;
                flowChartModel = y9FlowChartModel;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6d41\u7a0b\u56fe\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return Y9Result.success((Object)flowChartModel);
    }

    public Y9Result<List<FlowableBpmnModel>> getModelList(@RequestParam String tenantId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        ArrayList<FlowableBpmnModel> items = new ArrayList<FlowableBpmnModel>();
        List list = this.modelService.getModelsByModelType(Integer.valueOf(0));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (AbstractModel model : list) {
            FlowableBpmnModel flowableBpmnModel = new FlowableBpmnModel();
            flowableBpmnModel.setId(model.getId());
            flowableBpmnModel.setKey(model.getKey());
            flowableBpmnModel.setName(model.getName());
            flowableBpmnModel.setVersion(0);
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(model.getKey()).latestVersion().singleResult();
            if (null != processDefinition) {
                flowableBpmnModel.setVersion(processDefinition.getVersion());
            }
            flowableBpmnModel.setCreateTime(sdf.format(model.getCreated()));
            flowableBpmnModel.setLastUpdateTime(sdf.format(model.getLastUpdated()));
            items.add(flowableBpmnModel);
        }
        return Y9Result.success(items, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public Y9Result<FlowableBpmnModel> getModelXml(@RequestParam String tenantId, @RequestParam String modelId) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        FlowableBpmnModel flowableBpmnModel = new FlowableBpmnModel();
        try {
            Model model = this.modelService.getModel(modelId);
            flowableBpmnModel.setKey(model.getKey());
            flowableBpmnModel.setName(model.getName());
            byte[] bpmnBytes = this.modelService.getBpmnXML((AbstractModel)model);
            if (null != bpmnBytes) {
                flowableBpmnModel.setXml(new String(bpmnBytes, StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6d41\u7a0b\u8bbe\u8ba1\u6a21\u578bxml\u5931\u8d25", (Throwable)e);
        }
        return Y9Result.success((Object)flowableBpmnModel);
    }

    public Y9Result<Object> importProcessModel(@RequestParam String tenantId, @RequestParam String userId, @RequestParam MultipartFile file) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        try {
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            InputStreamReader xmlIn = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
            XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
            BpmnXMLConverter bpmnXmlConverter = new BpmnXMLConverter();
            BpmnModel bpmnModel = bpmnXmlConverter.convertToBpmnModel(xtr);
            ProcessValidator validator = new ProcessValidatorFactory().createDefaultProcessValidator();
            List errors = validator.validate(bpmnModel);
            if (!errors.isEmpty()) {
                StringBuffer es = new StringBuffer();
                errors.forEach(ve -> es.append(ve.toString()).append("/n"));
                return Y9Result.failure((String)("\u5bfc\u5165\u5931\u8d25\uff1a\u6a21\u677f\u9a8c\u8bc1\u5931\u8d25\uff0c\u539f\u56e0: " + es));
            }
            if (bpmnModel.getProcesses().isEmpty()) {
                return Y9Result.failure((String)"\u5bfc\u5165\u5931\u8d25\uff1a \u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u4e0d\u5b58\u5728\u6d41\u7a0b\u7684\u4fe1\u606f");
            }
            if (bpmnModel.getLocationMap().isEmpty()) {
                BpmnAutoLayout bpmnLayout = new BpmnAutoLayout(bpmnModel);
                bpmnLayout.execute();
            }
            BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
            ObjectNode modelNode = bpmnJsonConverter.convertToJson(bpmnModel);
            Process process = bpmnModel.getMainProcess();
            String name = process.getId();
            if (StringUtils.isNotEmpty((CharSequence)process.getName())) {
                name = process.getName();
            }
            String description = process.getDocumentation();
            Model newModel = new Model();
            List models = this.modelRepository.findByKeyAndType(process.getId(), Integer.valueOf(0));
            if (!models.isEmpty()) {
                Model updateModel = (Model)models.get(0);
                newModel.setId(updateModel.getId());
            }
            newModel.setName(name);
            newModel.setKey(process.getId());
            newModel.setModelType(Integer.valueOf(0));
            newModel.setCreated(Calendar.getInstance().getTime());
            newModel.setCreatedBy(orgUnit.getName());
            newModel.setDescription(description);
            newModel.setModelEditorJson(modelNode.toString());
            newModel.setLastUpdated(Calendar.getInstance().getTime());
            newModel.setLastUpdatedBy(orgUnit.getName());
            newModel.setTenantId(tenantId);
            this.modelService.createModel(newModel, userId);
            return Y9Result.success();
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u6d41\u7a0b\u6a21\u578b\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u5bfc\u5165\u5931\u8d25");
        }
    }

    public Y9Result<Object> saveModelXml(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String modelId, @RequestParam MultipartFile file) {
        FlowableTenantInfoHolder.setTenantId(tenantId);
        try {
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            InputStreamReader xmlIn = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
            XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
            BpmnXMLConverter bpmnXmlConverter = new BpmnXMLConverter();
            BpmnModel bpmnModel = bpmnXmlConverter.convertToBpmnModel(xtr);
            ProcessValidator validator = new ProcessValidatorFactory().createDefaultProcessValidator();
            List errors = validator.validate(bpmnModel);
            if (!errors.isEmpty()) {
                StringBuilder es = new StringBuilder();
                errors.forEach(ve -> es.append(ve.toString()).append("/n"));
                return Y9Result.failure((String)("\u4fdd\u5b58\u5931\u8d25\uff1a\u6a21\u677f\u9a8c\u8bc1\u5931\u8d25\uff0c\u539f\u56e0: " + es));
            }
            if (bpmnModel.getProcesses().isEmpty()) {
                return Y9Result.failure((String)"\u4fdd\u5b58\u5931\u8d25\uff1a \u6587\u4ef6\u4e2d\u4e0d\u5b58\u5728\u6d41\u7a0b\u7684\u4fe1\u606f");
            }
            if (bpmnModel.getLocationMap().isEmpty()) {
                BpmnAutoLayout bpmnLayout = new BpmnAutoLayout(bpmnModel);
                bpmnLayout.execute();
            }
            BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
            ObjectNode modelNode = bpmnJsonConverter.convertToJson(bpmnModel);
            Process process = bpmnModel.getMainProcess();
            String name = process.getId();
            if (StringUtils.isNotEmpty((CharSequence)process.getName())) {
                name = process.getName();
            }
            String description = process.getDocumentation();
            ModelRepresentation model = this.modelService.getModelRepresentation(modelId);
            model.setKey(process.getId());
            model.setName(name);
            model.setDescription(description);
            model.setModelType(Integer.valueOf(0));
            Model newModel = new Model();
            List models = this.modelRepository.findByKeyAndType(model.getKey(), model.getModelType());
            if (!models.isEmpty()) {
                Model updateModel = (Model)models.get(0);
                newModel.setId(updateModel.getId());
            }
            newModel.setName(model.getName());
            newModel.setKey(model.getKey());
            newModel.setModelType(model.getModelType());
            newModel.setCreated(Calendar.getInstance().getTime());
            newModel.setCreatedBy(orgUnit.getName());
            newModel.setDescription(model.getDescription());
            newModel.setModelEditorJson(modelNode.toString());
            newModel.setLastUpdated(Calendar.getInstance().getTime());
            newModel.setLastUpdatedBy(orgUnit.getName());
            newModel.setTenantId(tenantId);
            this.modelService.createModel(newModel, userId);
            return Y9Result.success();
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u6a21\u578bxml\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @Generated
    public BpmnModelApiImpl(CustomHistoricProcessService customHistoricProcessService, CustomHistoricTaskService customHistoricTaskService, CustomHistoricVariableService customHistoricVariableService, TaskService taskService, RuntimeService runtimeService, CustomHistoricActivityService customHistoricActivityService, RepositoryService repositoryService, OrgUnitApi orgUnitApi, OfficeDoneInfoApi officeDoneInfoManager, ProcessParamApi processParamManager, ProcessTrackApi processTrackManager, ModelService modelService, ModelRepository modelRepository) {
        this.customHistoricProcessService = customHistoricProcessService;
        this.customHistoricTaskService = customHistoricTaskService;
        this.customHistoricVariableService = customHistoricVariableService;
        this.taskService = taskService;
        this.runtimeService = runtimeService;
        this.customHistoricActivityService = customHistoricActivityService;
        this.repositoryService = repositoryService;
        this.orgUnitApi = orgUnitApi;
        this.officeDoneInfoManager = officeDoneInfoManager;
        this.processParamManager = processParamManager;
        this.processTrackManager = processTrackManager;
        this.modelService = modelService;
        this.modelRepository = modelRepository;
    }
}

