/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.manager.tenant.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.risesoft.exception.ErrorCode;
import net.risesoft.exception.TenantErrorCodeEnum;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.platform.TenantSystem;
import net.risesoft.util.Y9PublishServiceUtil;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.exception.util.Y9ExceptionUtil;
import net.risesoft.y9.pubsub.event.Y9EventCommon;
import net.risesoft.y9.pubsub.message.Y9MessageCommon;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.resource.Y9System;
import net.risesoft.y9public.entity.tenant.Y9DataSource;
import net.risesoft.y9public.entity.tenant.Y9Tenant;
import net.risesoft.y9public.entity.tenant.Y9TenantSystem;
import net.risesoft.y9public.manager.resource.Y9SystemManager;
import net.risesoft.y9public.manager.tenant.Y9DataSourceManager;
import net.risesoft.y9public.manager.tenant.Y9TenantManager;
import net.risesoft.y9public.manager.tenant.Y9TenantSystemManager;
import net.risesoft.y9public.manager.tenant.impl.Y9TenantSystemManagerImpl$AjcClosure1;
import net.risesoft.y9public.manager.tenant.impl.Y9TenantSystemManagerImpl$AjcClosure3;
import net.risesoft.y9public.manager.tenant.impl.Y9TenantSystemManagerImpl$AjcClosure5;
import net.risesoft.y9public.manager.tenant.impl.Y9TenantSystemManagerImpl$AjcClosure7;
import net.risesoft.y9public.manager.tenant.impl.Y9TenantSystemManagerImpl$AjcClosure9;
import net.risesoft.y9public.repository.tenant.Y9TenantSystemRepository;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
@Transactional(value="rsPublicTransactionManager", readOnly=true)
public class Y9TenantSystemManagerImpl
implements Y9TenantSystemManager {
    @Generated
    private static final Logger LOGGER;
    private final Y9TenantSystemRepository y9TenantSystemRepository;
    private final Y9SystemManager y9SystemManager;
    private final Y9TenantManager y9TenantManager;
    private final Y9DataSourceManager y9DataSourceManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    @Override
    @Transactional(readOnly=false)
    public void deleteBySystemId(String systemId) {
        String string = systemId;
        Object[] objectArray = new Object[]{this, string};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9TenantSystemManagerImpl$AjcClosure1(objectArray), ajc$tjp_0);
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(String id) {
        String string = id;
        Object[] objectArray = new Object[]{this, string};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9TenantSystemManagerImpl$AjcClosure3(objectArray), ajc$tjp_1);
    }

    @Override
    public String getDataSourceIdByTenantIdAndSystemId(String tenantId, String systemId) {
        String string = tenantId;
        String string2 = systemId;
        Object[] objectArray = new Object[]{this, string, string2};
        return (String)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9TenantSystemManagerImpl$AjcClosure5(objectArray), ajc$tjp_2);
    }

    @Override
    @Transactional(readOnly=false)
    public Y9TenantSystem save(Y9TenantSystem y9TenantSystem) {
        Y9TenantSystem y9TenantSystem2 = y9TenantSystem;
        Object[] objectArray = new Object[]{this, y9TenantSystem2};
        return (Y9TenantSystem)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9TenantSystemManagerImpl$AjcClosure7(objectArray), ajc$tjp_3);
    }

    @Override
    @Transactional(readOnly=false)
    public Y9TenantSystem saveTenantSystem(String systemId, String tenantId) {
        String string = systemId;
        String string2 = tenantId;
        Object[] objectArray = new Object[]{this, string, string2};
        return (Y9TenantSystem)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9TenantSystemManagerImpl$AjcClosure9(objectArray), ajc$tjp_4);
    }

    @Generated
    public Y9TenantSystemManagerImpl(Y9TenantSystemRepository y9TenantSystemRepository, Y9SystemManager y9SystemManager, Y9TenantManager y9TenantManager, Y9DataSourceManager y9DataSourceManager) {
        this.y9TenantSystemRepository = y9TenantSystemRepository;
        this.y9SystemManager = y9SystemManager;
        this.y9TenantManager = y9TenantManager;
        this.y9DataSourceManager = y9DataSourceManager;
    }

    static {
        Y9TenantSystemManagerImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(Y9TenantSystemManagerImpl.class);
    }

    static final /* synthetic */ void deleteBySystemId_aroundBody0(Y9TenantSystemManagerImpl ajc$this, String systemId) {
        List y9TenantSystemList = ajc$this.y9TenantSystemRepository.findBySystemId(systemId);
        for (Y9TenantSystem t : y9TenantSystemList) {
            ajc$this.delete(t.getId());
        }
    }

    static final /* synthetic */ void delete_aroundBody2(Y9TenantSystemManagerImpl ajc$this, String id) {
        final Y9TenantSystem y9TenantSystem = (Y9TenantSystem)ajc$this.y9TenantSystemRepository.findById((Object)id).orElseThrow(() -> Y9ExceptionUtil.notFoundException((ErrorCode)TenantErrorCodeEnum.TENANT_SYSTEM_NOT_EXISTS, (Object[])new Object[]{id}));
        ajc$this.y9TenantSystemRepository.delete((Object)y9TenantSystem);
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    Optional<Y9System> y9SystemOptional = Y9TenantSystemManagerImpl.this.y9SystemManager.findById(y9TenantSystem.getSystemId());
                    if (y9SystemOptional.isPresent()) {
                        Y9MessageCommon syncDataSourceEvent = new Y9MessageCommon();
                        syncDataSourceEvent.setEventTarget(y9SystemOptional.get().getName());
                        syncDataSourceEvent.setEventObject((Serializable)((Object)"TENANT_DATASOURCE_SYNC"));
                        syncDataSourceEvent.setEventType("TENANT_DATASOURCE_SYNC");
                        Y9PublishServiceUtil.publishMessageCommon(syncDataSourceEvent);
                        LOGGER.debug("\u79fb\u9664\u79df\u6237\u7cfb\u7edf\u540e\u53d1\u9001\u79df\u6237\u6570\u636e\u6e90\u540c\u6b65\u4e8b\u4ef6\uff1a{}", (Object)syncDataSourceEvent);
                    }
                }
            });
        }
    }

    static final /* synthetic */ String getDataSourceIdByTenantIdAndSystemId_aroundBody4(Y9TenantSystemManagerImpl ajc$this, String tenantId, String systemId) {
        return ajc$this.y9TenantSystemRepository.findByTenantIdAndSystemId(tenantId, systemId).map(Y9TenantSystem::getTenantDataSource).orElse(null);
    }

    static final /* synthetic */ Y9TenantSystem save_aroundBody6(Y9TenantSystemManagerImpl ajc$this, Y9TenantSystem y9TenantSystem) {
        if (StringUtils.isBlank((CharSequence)y9TenantSystem.getId())) {
            y9TenantSystem.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
        } else {
            Optional y9TenantSystemOptional = ajc$this.y9TenantSystemRepository.findById((Object)y9TenantSystem.getId());
            if (y9TenantSystemOptional.isPresent() && !Objects.equals(y9TenantSystem.getTenantDataSource(), ((Y9TenantSystem)y9TenantSystemOptional.get()).getTenantDataSource())) {
                y9TenantSystem.setInitialized(Boolean.valueOf(false));
            }
        }
        y9TenantSystem = (Y9TenantSystem)ajc$this.y9TenantSystemRepository.save((Object)y9TenantSystem);
        final Y9System y9System = ajc$this.y9SystemManager.getById(y9TenantSystem.getSystemId());
        final TenantSystem tenantSystem = (TenantSystem)Y9ModelConvertUtil.convert((Object)y9TenantSystem, TenantSystem.class);
        if (Objects.equals(Y9Context.getSystemName(), y9System.getName())) {
            Y9EventCommon tenantSystemRegisteredEvent = new Y9EventCommon();
            tenantSystemRegisteredEvent.setEventType("TENANT_SYSTEM_REGISTERED");
            tenantSystemRegisteredEvent.setEventObject((Object)tenantSystem);
            tenantSystemRegisteredEvent.setTarget(y9System.getName());
            Y9Context.publishEvent((ApplicationEvent)tenantSystemRegisteredEvent);
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    Y9MessageCommon tenantSystemRegisteredEvent = new Y9MessageCommon();
                    tenantSystemRegisteredEvent.setEventObject((Serializable)tenantSystem);
                    tenantSystemRegisteredEvent.setEventTarget(y9System.getName());
                    tenantSystemRegisteredEvent.setEventType("TENANT_SYSTEM_REGISTERED");
                    Y9PublishServiceUtil.publishMessageCommon(tenantSystemRegisteredEvent);
                    LOGGER.debug("\u6dfb\u52a0\u79df\u6237\u7cfb\u7edf\u540e\u53d1\u9001\u79df\u6237\u79df\u7528\u7cfb\u7edf\u4e8b\u4ef6\uff1a{}", (Object)tenantSystemRegisteredEvent);
                }
            });
        }
        return y9TenantSystem;
    }

    static final /* synthetic */ Y9TenantSystem saveTenantSystem_aroundBody8(Y9TenantSystemManagerImpl ajc$this, String systemId, String tenantId) {
        Y9Tenant tenant = ajc$this.y9TenantManager.getById(tenantId);
        Y9System y9System = ajc$this.y9SystemManager.getById(systemId);
        Optional y9TenantSystemOptional = ajc$this.y9TenantSystemRepository.findByTenantIdAndSystemId(tenantId, systemId);
        if (y9TenantSystemOptional.isPresent()) {
            return (Y9TenantSystem)y9TenantSystemOptional.get();
        }
        Y9TenantSystem y9TenantSystem = new Y9TenantSystem();
        y9TenantSystem.setTenantId(tenantId);
        y9TenantSystem.setTenantDataSource(tenant.getDefaultDataSourceId());
        y9TenantSystem.setSystemId(systemId);
        y9TenantSystem.setInitialized(Boolean.valueOf(false));
        if (Boolean.TRUE.equals(y9System.getSingleDatasource())) {
            String datasoureId = tenant.getDefaultDataSourceId();
            try {
                Y9DataSource y9DataSource = ajc$this.y9DataSourceManager.createTenantDefaultDataSource(tenant.getShortName(), tenant.getTenantType(), y9System.getName());
                datasoureId = y9DataSource.getId();
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            y9TenantSystem.setTenantDataSource(datasoureId);
        }
        return ajc$this.save(y9TenantSystem);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Y9TenantSystemManagerImpl.java", Y9TenantSystemManagerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteBySystemId", "net.risesoft.y9public.manager.tenant.impl.Y9TenantSystemManagerImpl", "java.lang.String", "systemId", "", "void"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "net.risesoft.y9public.manager.tenant.impl.Y9TenantSystemManagerImpl", "java.lang.String", "id", "", "void"), 68);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDataSourceIdByTenantIdAndSystemId", "net.risesoft.y9public.manager.tenant.impl.Y9TenantSystemManagerImpl", "java.lang.String:java.lang.String", "tenantId:systemId", "", "java.lang.String"), 95);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "net.risesoft.y9public.manager.tenant.impl.Y9TenantSystemManagerImpl", "net.risesoft.y9public.entity.tenant.Y9TenantSystem", "y9TenantSystem", "", "net.risesoft.y9public.entity.tenant.Y9TenantSystem"), 102);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveTenantSystem", "net.risesoft.y9public.manager.tenant.impl.Y9TenantSystemManagerImpl", "java.lang.String:java.lang.String", "systemId:tenantId", "", "net.risesoft.y9public.entity.tenant.Y9TenantSystem"), 150);
    }
}

