/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.manager.tenant.impl;

import com.alibaba.druid.DbType;
import com.alibaba.druid.pool.DruidDataSource;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.enums.platform.DataSourceTypeEnum;
import net.risesoft.enums.platform.TenantTypeEnum;
import net.risesoft.exception.DataSourceErrorCodeEnum;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.y9.configuration.app.y9platform.Y9PlatformProperties;
import net.risesoft.y9.exception.Y9BusinessException;
import net.risesoft.y9.util.Y9StringUtil;
import net.risesoft.y9.util.base64.Y9Base64Util;
import net.risesoft.y9public.entity.tenant.Y9DataSource;
import net.risesoft.y9public.manager.tenant.Y9DataSourceManager;
import net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl$AjcClosure1;
import net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl$AjcClosure11;
import net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl$AjcClosure13;
import net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl$AjcClosure3;
import net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl$AjcClosure5;
import net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl$AjcClosure7;
import net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl$AjcClosure9;
import net.risesoft.y9public.repository.tenant.Y9DataSourceRepository;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@Service
@Transactional(value="rsPublicTransactionManager", readOnly=true)
public class Y9DataSourceManagerImpl
implements Y9DataSourceManager {
    @Generated
    private static final Logger LOGGER;
    private final JdbcTemplate jdbcTemplate4Public;
    private final Y9PlatformProperties y9PlatformProperties;
    private final Y9DataSourceRepository datasourceRepository;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public Y9DataSourceManagerImpl(@Qualifier(value="jdbcTemplate4Public") JdbcTemplate jdbcTemplate4Public, Y9PlatformProperties y9PlatformProperties, Y9DataSourceRepository datasourceRepository) {
        this.jdbcTemplate4Public = jdbcTemplate4Public;
        this.y9PlatformProperties = y9PlatformProperties;
        this.datasourceRepository = datasourceRepository;
    }

    public static String generateRandomString() {
        String characters = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int length = 4;
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(characters.length());
            char randomChar = characters.charAt(index);
            sb.append(randomChar);
        }
        return sb.toString();
    }

    private static String replaceSchemaNameInJdbcUrlParam(String originalJdbcUrl, String newSchemaName) {
        int paramStart = originalJdbcUrl.indexOf("?") + 1;
        if (paramStart > 0) {
            String jdbcUrl = originalJdbcUrl.substring(0, paramStart);
            String originalParams = originalJdbcUrl.substring(paramStart);
            String newParams = Arrays.stream(StringUtils.split((String)originalParams, (String)"&")).map(param -> {
                if (param.startsWith("currentSchema=")) {
                    return "currentSchema=" + newSchemaName;
                }
                return param;
            }).collect(Collectors.joining("&"));
            return jdbcUrl + newParams;
        }
        return originalJdbcUrl + "?currentSchema=" + newSchemaName;
    }

    @Override
    public String buildDataSourceName(String shortName, TenantTypeEnum tenantType, String systemName) {
        String string = shortName;
        TenantTypeEnum tenantTypeEnum = tenantType;
        String string2 = systemName;
        Object[] objectArray = new Object[]{this, string, tenantTypeEnum, string2};
        return (String)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceManagerImpl$AjcClosure1(objectArray), ajc$tjp_0);
    }

    @Override
    @Transactional(readOnly=false)
    public Y9DataSource createTenantDefaultDataSource(String shortName, TenantTypeEnum tenantType, String systemName) {
        String string = shortName;
        TenantTypeEnum tenantTypeEnum = tenantType;
        String string2 = systemName;
        Object[] objectArray = new Object[]{this, string, tenantTypeEnum, string2};
        return (Y9DataSource)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceManagerImpl$AjcClosure3(objectArray), ajc$tjp_1);
    }

    @Override
    @Transactional(readOnly=false)
    public Y9DataSource createTenantDefaultDataSource(String dbName) {
        String string = dbName;
        Object[] objectArray = new Object[]{this, string};
        return (Y9DataSource)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceManagerImpl$AjcClosure5(objectArray), ajc$tjp_2);
    }

    @Override
    @Transactional(readOnly=false)
    public Y9DataSource createTenantDefaultDataSource(String dbName, String specifyId) {
        String string = dbName;
        String string2 = specifyId;
        Object[] objectArray = new Object[]{this, string, string2};
        return (Y9DataSource)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceManagerImpl$AjcClosure7(objectArray), ajc$tjp_3);
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(String id) {
        String string = id;
        Object[] objectArray = new Object[]{this, string};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceManagerImpl$AjcClosure9(objectArray), ajc$tjp_4);
    }

    @Override
    @Transactional(readOnly=false)
    public void dropTenantDefaultDataSource(String dataSourceId, String dbName) {
        String string = dataSourceId;
        String string2 = dbName;
        Object[] objectArray = new Object[]{this, string, string2};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceManagerImpl$AjcClosure11(objectArray), ajc$tjp_5);
    }

    @Override
    @Transactional(readOnly=false)
    public Y9DataSource save(Y9DataSource y9DataSource) {
        Y9DataSource y9DataSource2 = y9DataSource;
        Object[] objectArray = new Object[]{this, y9DataSource2};
        return (Y9DataSource)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9DataSourceManagerImpl$AjcClosure13(objectArray), ajc$tjp_6);
    }

    private String replaceDatabaseNameInJdbcUrl(String originalJdbcUrl, String newDatabaseName) {
        int dbNameStart = originalJdbcUrl.lastIndexOf("/") + 1;
        int dbNameEnd = originalJdbcUrl.indexOf("?");
        if (dbNameStart > 0) {
            String oldDatabaseName = dbNameEnd > dbNameStart ? originalJdbcUrl.substring(dbNameStart, dbNameEnd) : originalJdbcUrl.substring(dbNameStart);
            return originalJdbcUrl.replace(oldDatabaseName, newDatabaseName);
        }
        return originalJdbcUrl;
    }

    static {
        Y9DataSourceManagerImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(Y9DataSourceManagerImpl.class);
    }

    static final /* synthetic */ String buildDataSourceName_aroundBody0(Y9DataSourceManagerImpl ajc$this, String shortName, TenantTypeEnum tenantType, String systemName) {
        Object dataSourceName = shortName;
        if (Objects.equals(tenantType, TenantTypeEnum.TENANT) && !"default".equals(shortName)) {
            dataSourceName = "yt_" + Y9DataSourceManagerImpl.generateRandomString() + "_" + shortName;
        }
        if (StringUtils.isNotBlank((CharSequence)systemName)) {
            dataSourceName = (String)dataSourceName + "_" + systemName;
        }
        return dataSourceName;
    }

    static final /* synthetic */ Y9DataSource createTenantDefaultDataSource_aroundBody2(Y9DataSourceManagerImpl ajc$this, String shortName, TenantTypeEnum tenantType, String systemName) {
        String dataSourceName = ajc$this.buildDataSourceName(shortName, tenantType, systemName);
        return ajc$this.createTenantDefaultDataSource(dataSourceName, null);
    }

    static final /* synthetic */ Y9DataSource createTenantDefaultDataSource_aroundBody4(Y9DataSourceManagerImpl ajc$this, String dbName) {
        return ajc$this.createTenantDefaultDataSource(dbName, null);
    }

    static final /* synthetic */ Y9DataSource createTenantDefaultDataSource_aroundBody6(Y9DataSourceManagerImpl ajc$this, String dbName, String specifyId) {
        String sql1;
        Optional y9DataSourceOptional;
        if (StringUtils.isNotBlank((CharSequence)specifyId) && (y9DataSourceOptional = ajc$this.datasourceRepository.findById((Object)specifyId)).isPresent()) {
            return (Y9DataSource)y9DataSourceOptional.get();
        }
        y9DataSourceOptional = ajc$this.datasourceRepository.findByJndiName(dbName);
        if (y9DataSourceOptional.isPresent()) {
            return (Y9DataSource)y9DataSourceOptional.get();
        }
        DruidDataSource dds = (DruidDataSource)ajc$this.jdbcTemplate4Public.getDataSource();
        String dbType = dds.getDbType();
        Object url = null;
        String username = null;
        String password = null;
        if (Objects.equals(DbType.mysql.name(), dbType) || Objects.equals(DbType.mariadb.name(), dbType)) {
            url = ajc$this.replaceDatabaseNameInJdbcUrl(dds.getUrl(), dbName);
            username = dds.getUsername();
            password = dds.getPassword();
            String sql = Y9StringUtil.format((String)"CREATE DATABASE IF NOT EXISTS {} DEFAULT CHARACTER SET UTF8 COLLATE UTF8_BIN", (Object[])new Object[]{dbName});
            ajc$this.jdbcTemplate4Public.update(sql);
        }
        if (DbType.oracle.name().equals(dbType)) {
            url = dds.getUrl();
            username = dbName.toUpperCase();
            password = dds.getPassword();
            String tableSpace = username + "_DATA";
            String dataFile = ajc$this.y9PlatformProperties.getNewTableSpacePath() + tableSpace + ".DBF";
            String sql12 = Y9StringUtil.format((String)"CREATE TABLESPACE {} DATAFILE '{}' SIZE 100M AUTOEXTEND ON NEXT 10M MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL", (Object[])new Object[]{tableSpace, dataFile});
            String sql2 = Y9StringUtil.format((String)"CREATE USER {} IDENTIFIED BY {} ACCOUNT UNLOCK DEFAULT TABLESPACE {} TEMPORARY TABLESPACE TEMP PROFILE DEFAULT", (Object[])new Object[]{username, password, tableSpace});
            String sql3 = Y9StringUtil.format((String)"GRANT DBA TO {} WITH ADMIN OPTION", (Object[])new Object[]{username});
            String sql4 = Y9StringUtil.format((String)"ALTER USER {} DEFAULT ROLE DBA", (Object[])new Object[]{username});
            ajc$this.jdbcTemplate4Public.update(sql12);
            ajc$this.jdbcTemplate4Public.update(sql2);
            ajc$this.jdbcTemplate4Public.update(sql3);
            ajc$this.jdbcTemplate4Public.update(sql4);
        }
        if (DbType.postgresql.name().equals(dbType)) {
            url = ajc$this.replaceDatabaseNameInJdbcUrl(dds.getUrl(), dbName);
            username = dds.getUsername();
            password = dds.getPassword();
            dbName = dbName.toLowerCase();
            sql1 = Y9StringUtil.format((String)"CREATE DATABASE {} WITH ENCODING = 'UTF8' OWNER = {}", (Object[])new Object[]{dbName, username});
            String sql2 = Y9StringUtil.format((String)"GRANT ALL PRIVILEGES ON DATABASE {} TO {}", (Object[])new Object[]{dbName, username});
            ajc$this.jdbcTemplate4Public.update(sql1);
            ajc$this.jdbcTemplate4Public.update(sql2);
        }
        if (DbType.dm.equals(dbType)) {
            String upperCaseDbName;
            url = dds.getUrl();
            username = upperCaseDbName = dbName.toUpperCase();
            password = dds.getPassword();
            String tableSpace = upperCaseDbName + "_DATA";
            String dataFile = ajc$this.y9PlatformProperties.getNewTableSpacePath() + tableSpace + ".DBF";
            String sql13 = Y9StringUtil.format((String)"create tablespace {} datafile '{}' size 32 autoextend on next 32 CACHE = NORMAL;", (Object[])new Object[]{tableSpace, dataFile});
            String sql2 = Y9StringUtil.format((String)"create user {} identified by {} password_policy 0 PROFILE \"DEFAULT\" default tablespace {}", (Object[])new Object[]{username, password, tableSpace});
            String sql3 = Y9StringUtil.format((String)"grant \"DBA\" to {}", (Object[])new Object[]{username});
            ajc$this.jdbcTemplate4Public.update(sql13);
            ajc$this.jdbcTemplate4Public.update(sql2);
            ajc$this.jdbcTemplate4Public.update(sql3);
        }
        if (DbType.kingbase.name().equals(dbType)) {
            url = Y9DataSourceManagerImpl.replaceSchemaNameInJdbcUrlParam(dds.getUrl(), dbName);
            username = dds.getUsername();
            password = dds.getPassword();
            sql1 = Y9StringUtil.format((String)"CREATE SCHEMA {}", (Object[])new Object[]{dbName});
            ajc$this.jdbcTemplate4Public.update(sql1);
        }
        if (DbType.h2.name().equals(dbType)) {
            url = "jdbc:h2:mem:" + dbName;
            username = dds.getUsername();
            password = dds.getPassword();
        }
        if (url == null) {
            throw new Y9BusinessException(DataSourceErrorCodeEnum.DATABASE_NOT_FULLY_SUPPORTED.getCode(), DataSourceErrorCodeEnum.DATABASE_NOT_FULLY_SUPPORTED.getDescription());
        }
        Y9DataSource y9DataSource = new Y9DataSource();
        y9DataSource.setJndiName(dbName);
        y9DataSource.setUrl((String)url);
        y9DataSource.setType(DataSourceTypeEnum.DRUID);
        y9DataSource.setUsername(username);
        y9DataSource.setPassword(password);
        y9DataSource.setInitialSize(Integer.valueOf(dds.getInitialSize()));
        y9DataSource.setMaxActive(Integer.valueOf(dds.getMaxActive()));
        y9DataSource.setMinIdle(Integer.valueOf(dds.getMinIdle()));
        y9DataSource.setId(Optional.ofNullable(specifyId).orElse(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE)));
        return ajc$this.save(y9DataSource);
    }

    static final /* synthetic */ void delete_aroundBody8(Y9DataSourceManagerImpl ajc$this, String id) {
        ajc$this.datasourceRepository.deleteById((Object)id);
    }

    static final /* synthetic */ void dropTenantDefaultDataSource_aroundBody10(Y9DataSourceManagerImpl ajc$this, String dataSourceId, String dbName) {
        DruidDataSource dds;
        if (StringUtils.isNotBlank((CharSequence)dataSourceId)) {
            ajc$this.delete(dataSourceId);
        }
        if (StringUtils.isNotBlank((CharSequence)dbName) && (dds = (DruidDataSource)ajc$this.jdbcTemplate4Public.getDataSource()) != null) {
            if (DbType.mysql.name().equals(dds.getDbType())) {
                String sql = "DROP DATABASE IF EXISTS " + dbName;
                ajc$this.jdbcTemplate4Public.execute(sql);
            } else if (DbType.oracle.name().equals(dds.getDbType())) {
                String username = dbName.toUpperCase();
                String sql1 = "DROP USER " + username + " CASCADE";
                String sql2 = "DROP TABLESPACE " + username + "_DATA INCLUDING CONTENTS AND DATAFILES";
                ajc$this.jdbcTemplate4Public.execute(sql1);
                ajc$this.jdbcTemplate4Public.execute(sql2);
            } else if (DbType.kingbase.name().equals(dds.getDbType())) {
                String username = dbName.toUpperCase();
                String sql1 = "DROP SCHEMA " + username + " CASCADE;";
                ajc$this.jdbcTemplate4Public.execute(sql1);
            } else if (DbType.postgresql.name().equals(dds.getDbType())) {
                String username = dbName.toUpperCase();
                String sql1 = "DROP DATABASE IF EXISTS " + username;
                ajc$this.jdbcTemplate4Public.execute(sql1);
            }
        }
    }

    static final /* synthetic */ Y9DataSource save_aroundBody12(Y9DataSourceManagerImpl ajc$this, Y9DataSource y9DataSource) {
        if (StringUtils.isBlank((CharSequence)y9DataSource.getId())) {
            y9DataSource.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
        }
        if (y9DataSource.getPassword() != null) {
            y9DataSource.setPassword(Y9Base64Util.encode((String)y9DataSource.getPassword()));
        }
        return (Y9DataSource)ajc$this.datasourceRepository.save((Object)y9DataSource);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Y9DataSourceManagerImpl.java", Y9DataSourceManagerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildDataSourceName", "net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl", "java.lang.String:net.risesoft.enums.platform.TenantTypeEnum:java.lang.String", "shortName:tenantType:systemName", "", "java.lang.String"), 97);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTenantDefaultDataSource", "net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl", "java.lang.String:net.risesoft.enums.platform.TenantTypeEnum:java.lang.String", "shortName:tenantType:systemName", "", "net.risesoft.y9public.entity.tenant.Y9DataSource"), 110);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTenantDefaultDataSource", "net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl", "java.lang.String", "dbName", "", "net.risesoft.y9public.entity.tenant.Y9DataSource"), 117);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTenantDefaultDataSource", "net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl", "java.lang.String:java.lang.String", "dbName:specifyId", "", "net.risesoft.y9public.entity.tenant.Y9DataSource"), 123);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl", "java.lang.String", "id", "", "void"), 262);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dropTenantDefaultDataSource", "net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl", "java.lang.String:java.lang.String", "dataSourceId:dbName", "", "void"), 268);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "net.risesoft.y9public.manager.tenant.impl.Y9DataSourceManagerImpl", "net.risesoft.y9public.entity.tenant.Y9DataSource", "y9DataSource", "", "net.risesoft.y9public.entity.tenant.Y9DataSource"), 299);
    }
}

