/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lombok.Generated;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(StringUtil.class);

    public static String getRandomNum(int length) {
        Random r = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= length; ++i) {
            sb.append(r.nextInt(10));
        }
        return sb.toString();
    }

    public static String parseXmlStr(String tagName1, List<Map<String, Object>> list1, String[] proNames1, String tagName2, List<Map<String, Object>> list2, String[] proNames2) {
        String value;
        Map<String, Object> map;
        int i;
        StringBuilder str = new StringBuilder();
        str.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        str.append("<root>\n");
        for (i = 0; i < list1.size(); ++i) {
            str.append("\t<" + tagName1 + " id=\"" + tagName1 + "_" + (i + 1) + "\">\n");
            map = list1.get(i);
            for (String name : proNames1) {
                value = (String)map.get(name);
                if (value != null && value.length() > 0) {
                    str.append("\t\t<" + name + ">" + value + "</" + name + ">\n");
                    continue;
                }
                str.append("\t\t<" + name + "/>\n");
            }
            str.append("\t</" + tagName1 + ">\n");
        }
        for (i = 0; i < list2.size(); ++i) {
            str.append("\t<" + tagName2 + " id=\"" + tagName2 + "_" + (i + 1) + "\">\n");
            map = list2.get(i);
            for (String name : proNames2) {
                value = (String)map.get(name);
                if (value != null && value.length() > 0) {
                    str.append("\t\t<" + name + ">" + value + "</" + name + ">\n");
                    continue;
                }
                str.append("\t\t<" + name + "/>\n");
            }
            str.append("\t</" + tagName2 + ">\n");
        }
        str.append("</root>");
        return str.toString();
    }

    public static String replaceAll(String str, String target, String replacement) {
        while (str.indexOf(target) >= 0) {
            str = str.replace(target, replacement);
        }
        return str;
    }

    public static String strChangeToXml(byte[] str) {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read((InputStream)new ByteArrayInputStream(str));
        }
        catch (DocumentException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        StringWriter writer = new StringWriter();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        XMLWriter xmlwriter = new XMLWriter((Writer)writer, format);
        try {
            xmlwriter.write(document);
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return writer.toString();
    }
}

