/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risesoft.entity.Y9Department;
import net.risesoft.entity.Y9Group;
import net.risesoft.entity.Y9Manager;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Organization;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9Position;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.Group;
import net.risesoft.model.platform.Manager;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.model.platform.Resource;
import net.risesoft.model.platform.Role;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9BeanUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.resource.Y9ResourceBase;
import net.risesoft.y9public.entity.role.Y9Role;
import org.apache.commons.lang3.StringUtils;

public class ModelConvertUtil
extends Y9ModelConvertUtil {
    public static List<OrgUnit> orgBaseToOrgUnit(List<Y9OrgBase> y9OrgBaseList) {
        ArrayList<OrgUnit> orgUnitList = new ArrayList<OrgUnit>();
        for (Y9OrgBase y9OrgBase : y9OrgBaseList) {
            orgUnitList.add(ModelConvertUtil.orgBaseToOrgUnit(y9OrgBase));
        }
        return orgUnitList;
    }

    public static OrgUnit orgBaseToOrgUnit(Y9OrgBase base) {
        OrgUnit orgUnit;
        if (base == null) {
            return null;
        }
        if (OrgTypeEnum.PERSON.equals((Object)base.getOrgType())) {
            Y9Person person = (Y9Person)base;
            orgUnit = (OrgUnit)ModelConvertUtil.convert((Object)person, Person.class);
        } else if (OrgTypeEnum.MANAGER.equals((Object)base.getOrgType())) {
            Y9Manager manager = (Y9Manager)base;
            orgUnit = (OrgUnit)ModelConvertUtil.convert((Object)manager, Manager.class);
        } else if (OrgTypeEnum.DEPARTMENT.equals((Object)base.getOrgType())) {
            Y9Department dept = (Y9Department)base;
            orgUnit = (OrgUnit)ModelConvertUtil.convert((Object)dept, Department.class);
        } else if (OrgTypeEnum.GROUP.equals((Object)base.getOrgType())) {
            Y9Group group = (Y9Group)base;
            orgUnit = (OrgUnit)ModelConvertUtil.convert((Object)group, Group.class);
        } else if (OrgTypeEnum.POSITION.equals((Object)base.getOrgType())) {
            Y9Position position = (Y9Position)base;
            orgUnit = (OrgUnit)ModelConvertUtil.convert((Object)position, Position.class);
        } else {
            Y9Organization org = (Y9Organization)base;
            orgUnit = (OrgUnit)ModelConvertUtil.convert((Object)org, Organization.class);
        }
        return orgUnit;
    }

    public static Person orgPersonToPerson(Y9Person y9Person) {
        Person person = (Person)ModelConvertUtil.convert((Object)y9Person, Person.class);
        person.setPassword(null);
        return person;
    }

    public static Resource resourceBaseToResource(Y9ResourceBase y9ResourceBase) {
        if (y9ResourceBase == null) {
            return null;
        }
        Resource resource = new Resource();
        Y9BeanUtil.copyProperties((Object)y9ResourceBase, (Object)resource);
        return resource;
    }

    public static Role y9RoleToRole(Y9Role y9Role) {
        if (y9Role == null) {
            return null;
        }
        Role role = new Role();
        Y9BeanUtil.copyProperties((Object)y9Role, (Object)role);
        if (StringUtils.isNotEmpty((CharSequence)y9Role.getProperties())) {
            HashMap values = Y9JsonUtil.readHashMap((String)y9Role.getProperties(), String.class, String.class);
            role.setValues((Map)values);
        }
        return role;
    }
}

