/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.scheduled;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import net.risesoft.api.log.UserLoginInfoApi;
import net.risesoft.entity.Y9Manager;
import net.risesoft.entity.Y9Organization;
import net.risesoft.enums.platform.TenantTypeEnum;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.log.LogLevelEnum;
import net.risesoft.log.OperationTypeEnum;
import net.risesoft.log.service.AsyncSaveLogInfo;
import net.risesoft.model.log.AccessLog;
import net.risesoft.model.userlogininfo.LoginInfo;
import net.risesoft.service.identity.IdentityResourceCalculator;
import net.risesoft.service.identity.IdentityRoleCalculator;
import net.risesoft.service.org.Y9ManagerService;
import net.risesoft.service.org.Y9OrganizationService;
import net.risesoft.util.Y9PlatformUtil;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.InetAddressUtil;
import net.risesoft.y9public.entity.tenant.Y9Tenant;
import net.risesoft.y9public.service.tenant.Y9TenantService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ScheduledTask {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledTask.class);
    private final String serverIp = InetAddressUtil.getLocalAddress().getHostAddress();
    private final UserLoginInfoApi userLoginInfoApi;
    private final Y9ManagerService y9ManagerService;
    private final Y9OrganizationService y9OrganizationService;
    private final Y9TenantService y9TenantService;
    private final IdentityResourceCalculator identityResourceCalculator;
    private final IdentityRoleCalculator identityRoleCalculator;
    private AsyncSaveLogInfo asyncSaveLogInfo;

    @Scheduled(cron="0 0 1 * * ?")
    @SchedulerLock(name="checkManagerLogReviewLock", lockAtLeastFor="PT30M")
    public void checkManagerLogReview() {
        LOGGER.info("********************\u68c0\u67e5\u4e09\u5458\u5ba1\u67e5\u60c5\u51b5-\u5f00\u59cb**********************");
        long start = System.nanoTime();
        String systemName = Y9Context.getSystemName();
        List tenantIds = Y9PlatformUtil.getTenantIds();
        for (String tenantId : tenantIds) {
            Y9LoginUserHolder.setTenantId((String)tenantId);
            List<Y9Manager> y9ManagerList = this.y9ManagerService.listAll();
            for (Y9Manager y9Manager : y9ManagerList) {
                int reviewLogCycle = this.y9ManagerService.getReviewLogCycle(y9Manager.getManagerLevel());
                if (0 == reviewLogCycle) continue;
                LoginInfo loginInfo = this.userLoginInfoApi.getTopByTenantIdAndUserId(y9Manager.getTenantId(), y9Manager.getId());
                Date checkTime = loginInfo == null ? new Date() : loginInfo.getLoginTime();
                try {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(checkTime);
                    calendar.add(5, reviewLogCycle);
                    long now = System.currentTimeMillis();
                    if (calendar.getTimeInMillis() < now) {
                        long end = System.nanoTime();
                        long elapsedTime = end - start;
                        AccessLog log = new AccessLog();
                        log.setLogLevel(LogLevelEnum.MANAGERLOG.toString());
                        log.setLogTime(new Date());
                        log.setElapsedTime(String.valueOf(elapsedTime));
                        log.setSuccess("\u6210\u529f");
                        log.setManagerLevel(y9Manager.getManagerLevel().getValue().toString());
                        log.setLogMessage(y9Manager.getName() + "\u5df2\u8d85\u8fc7" + reviewLogCycle + "\u5929\u672a\u767b\u5f55\u7cfb\u7edf\u5ba1\u67e5\u3002");
                        log.setTenantId(tenantId);
                        log.setId(Y9IdGenerator.genId());
                        log.setServerIp(this.serverIp);
                        log.setUserHostIp(this.serverIp);
                        log.setSystemName(systemName);
                        log.setMethodName("checkManagerLogReview");
                        log.setModularName("\u6570\u5b57\u5e95\u5ea7");
                        log.setOperateName("\u68c0\u67e5\u4e09\u5458\u5ba1\u67e5\u60c5\u51b5");
                        log.setOperateType(OperationTypeEnum.CHECK.getValue());
                        if (this.asyncSaveLogInfo != null) {
                            this.asyncSaveLogInfo.asyncSave(log);
                        }
                    }
                    this.y9ManagerService.updateCheckTime(y9Manager.getId(), checkTime);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        LOGGER.info("********************\u68c0\u67e5\u4e09\u5458\u5ba1\u67e5\u60c5\u51b5-\u7ed3\u675f**********************");
    }

    @Scheduled(cron="0 0 1 * * ?")
    @SchedulerLock(name="checkManagerPasswordModificationLock", lockAtLeastFor="PT30M")
    public void checkManagerPasswordModification() {
        LOGGER.info("********************\u68c0\u67e5\u4e09\u5458\u5bc6\u7801\u4fee\u6539\u60c5\u51b5-\u5f00\u59cb**********************");
        long start = System.nanoTime();
        String systemName = Y9Context.getSystemName();
        List tenantIds = Y9PlatformUtil.getTenantIds();
        for (String tenantId : tenantIds) {
            Y9LoginUserHolder.setTenantId((String)tenantId);
            List<Y9Manager> y9ManagerList = this.y9ManagerService.listAll();
            for (Y9Manager y9Manager : y9ManagerList) {
                int modifyPasswordCycle = this.y9ManagerService.getPasswordModifiedCycle(y9Manager.getManagerLevel());
                Date modifyPwdTime = y9Manager.getLastModifyPasswordTime();
                boolean saveLog = false;
                if (modifyPwdTime == null) {
                    saveLog = true;
                } else {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(modifyPwdTime);
                    calendar.add(5, modifyPasswordCycle);
                    long now = System.currentTimeMillis();
                    if (calendar.getTimeInMillis() < now) {
                        saveLog = true;
                    }
                }
                if (!saveLog) continue;
                long end = System.nanoTime();
                long elapsedTime = end - start;
                AccessLog log = new AccessLog();
                log.setLogLevel(LogLevelEnum.MANAGERLOG.toString());
                log.setLogTime(new Date());
                log.setElapsedTime(String.valueOf(elapsedTime));
                log.setSuccess("\u6210\u529f");
                log.setManagerLevel(y9Manager.getManagerLevel().getValue().toString());
                log.setLogMessage(y9Manager.getName() + "\u5df2\u8d85\u8fc7" + modifyPasswordCycle + "\u5929\u672a\u4fee\u6539\u5bc6\u7801\u3002");
                log.setTenantId(tenantId);
                log.setId(Y9IdGenerator.genId());
                log.setServerIp(this.serverIp);
                log.setUserHostIp(this.serverIp);
                log.setSystemName(systemName);
                log.setMethodName("checkManagerPasswordModification");
                log.setModularName("\u6570\u5b57\u5e95\u5ea7");
                log.setOperateName("\u68c0\u67e5\u4e09\u5458\u5bc6\u7801\u4fee\u6539");
                log.setOperateType(OperationTypeEnum.CHECK.getValue());
                if (this.asyncSaveLogInfo == null) continue;
                this.asyncSaveLogInfo.asyncSave(log);
            }
        }
        LOGGER.info("********************\u68c0\u67e5\u4e09\u5458\u5bc6\u7801\u4fee\u6539\u60c5\u51b5-\u7ed3\u675f**********************");
    }

    @Autowired(required=false)
    public void setAsyncSaveLogInfo(AsyncSaveLogInfo asyncSaveLogInfo) {
        this.asyncSaveLogInfo = asyncSaveLogInfo;
    }

    @Scheduled(cron="0 0 2 * * ?")
    @SchedulerLock(name="syncIdentityResourceLock", lockAtLeastFor="PT30M")
    public void syncIdentityResource() {
        List<Y9Tenant> y9TenantList = this.y9TenantService.listByTenantType(TenantTypeEnum.TENANT);
        for (Y9Tenant y9Tenant : y9TenantList) {
            Y9LoginUserHolder.setTenantId((String)y9Tenant.getId());
            for (Y9Organization y9Organization : this.y9OrganizationService.list()) {
                this.identityResourceCalculator.recalculateByOrgUnitId(y9Organization.getId());
            }
        }
        LOGGER.info("\u540c\u6b65\u6388\u6743\u4e3b\u4f53\u7684\u8d44\u6e90\u6743\u9650\u7ed3\u675f");
    }

    @Scheduled(cron="0 0 4 * * ?")
    @SchedulerLock(name="syncIdentityRoleLock", lockAtLeastFor="PT30M")
    public void syncIdentityRole() {
        List<Y9Tenant> y9TenantList = this.y9TenantService.listByTenantType(TenantTypeEnum.TENANT);
        for (Y9Tenant y9Tenant : y9TenantList) {
            Y9LoginUserHolder.setTenantId((String)y9Tenant.getId());
            for (Y9Organization y9Organization : this.y9OrganizationService.list()) {
                this.identityRoleCalculator.recalculateByOrgUnitId(y9Organization.getId());
            }
        }
        LOGGER.info("\u540c\u6b65\u6388\u6743\u4e3b\u4f53\u7684\u89d2\u8272\u7ed3\u675f");
    }

    @Generated
    public ScheduledTask(UserLoginInfoApi userLoginInfoApi, Y9ManagerService y9ManagerService, Y9OrganizationService y9OrganizationService, Y9TenantService y9TenantService, IdentityResourceCalculator identityResourceCalculator, IdentityRoleCalculator identityRoleCalculator) {
        this.userLoginInfoApi = userLoginInfoApi;
        this.y9ManagerService = y9ManagerService;
        this.y9OrganizationService = y9OrganizationService;
        this.y9TenantService = y9TenantService;
        this.identityResourceCalculator = identityResourceCalculator;
        this.identityRoleCalculator = identityRoleCalculator;
    }
}

