/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.dataio.org;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.risesoft.dataio.org.Y9OrgTreeDataHandler;
import net.risesoft.entity.Y9Department;
import net.risesoft.entity.Y9DepartmentProp;
import net.risesoft.entity.Y9Group;
import net.risesoft.entity.Y9Organization;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9PersonExt;
import net.risesoft.entity.Y9Position;
import net.risesoft.entity.relation.Y9PersonsToGroups;
import net.risesoft.entity.relation.Y9PersonsToPositions;
import net.risesoft.entity.relation.Y9PositionsToGroups;
import net.risesoft.enums.platform.GroupTypeEnum;
import net.risesoft.enums.platform.MaritalStatusEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.enums.platform.SexEnum;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9DepartmentPropService;
import net.risesoft.service.org.Y9DepartmentService;
import net.risesoft.service.org.Y9GroupService;
import net.risesoft.service.org.Y9OrganizationService;
import net.risesoft.service.org.Y9PersonExtService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.org.Y9PositionService;
import net.risesoft.service.relation.Y9PersonsToGroupsService;
import net.risesoft.service.relation.Y9PersonsToPositionsService;
import net.risesoft.service.relation.Y9PositionsToGroupsService;
import net.risesoft.util.StringUtil;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9EnumUtil;
import net.risesoft.y9.util.base64.Y9Base64Util;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="y9OrgTreeXmlDataHandler")
public class Y9OrgTreeXmlDataHandlerImpl
implements Y9OrgTreeDataHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Y9OrgTreeXmlDataHandlerImpl.class);
    private final Y9OrganizationService y9OrganizationService;
    private final Y9DepartmentService y9DepartmentService;
    private final Y9DepartmentPropService y9DepartmentPropService;
    private final Y9GroupService y9GroupService;
    private final Y9PersonsToGroupsService y9PersonsToGroupsService;
    private final Y9PositionsToGroupsService y9PositionsToGroupsService;
    private final Y9PersonService y9PersonService;
    private final Y9PersonsToPositionsService y9PersonsToPositionsService;
    private final Y9PositionService y9PositionService;
    private final Y9PersonExtService y9PersonExtService;
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final SimpleDateFormat fmt2 = new SimpleDateFormat("yyyy-MM-dd");
    String errorMsg = "";
    private String createTime = "";
    private String updateTime = "";

    private Element buildDeptElement(Element rootElement, Y9Department orgdepartment) {
        Element orgDepartment = rootElement.addElement(OrgTypeEnum.DEPARTMENT.getEnName());
        orgDepartment.addAttribute("uid", orgdepartment.getId());
        orgDepartment.addAttribute("name", orgdepartment.getName());
        orgDepartment.addElement("UID").addText(orgdepartment.getId());
        this.createTime = this.fmt.format(orgdepartment.getCreateTime());
        this.updateTime = this.fmt.format(orgdepartment.getUpdateTime() == null ? new Date() : orgdepartment.getUpdateTime());
        orgDepartment.addElement("createTime").addText(this.createTime);
        orgDepartment.addElement("updateTime").addText(this.updateTime);
        orgDepartment.addElement("description").addText(orgdepartment.getDescription() == null ? "" : orgdepartment.getDescription());
        orgDepartment.addElement("customId").addText(orgdepartment.getCustomId() == null ? "" : orgdepartment.getCustomId());
        orgDepartment.addElement("disabled").addText(Boolean.toString(orgdepartment.getDisabled()));
        orgDepartment.addElement("dn").addText(orgdepartment.getDn() == null ? "" : orgdepartment.getDn());
        orgDepartment.addElement("orgType").addText(orgdepartment.getOrgType() == null ? "" : orgdepartment.getOrgType().getEnName());
        orgDepartment.addElement("tabIndex").addText((String)(orgdepartment.getTabIndex() == null ? "" : "" + orgdepartment.getTabIndex()));
        orgDepartment.addElement("aliasName").addText(orgdepartment.getAliasName() == null ? "" : orgdepartment.getAliasName());
        orgDepartment.addElement("deptAddress").addText(orgdepartment.getDeptAddress() == null ? "" : orgdepartment.getDeptAddress());
        orgDepartment.addElement("deptFax").addText(orgdepartment.getDeptFax() == null ? "" : orgdepartment.getDeptFax());
        orgDepartment.addElement("deptGivenName").addText(orgdepartment.getDeptGivenName() == null ? "" : orgdepartment.getDeptGivenName());
        orgDepartment.addElement("deptOffice").addText(orgdepartment.getDeptOffice() == null ? "" : orgdepartment.getDeptOffice());
        orgDepartment.addElement("deptPhone").addText(orgdepartment.getDeptPhone() == null ? "" : orgdepartment.getDeptPhone());
        orgDepartment.addElement("deptType").addText(orgdepartment.getDeptType() == null ? "" : orgdepartment.getDeptType());
        orgDepartment.addElement("divisionCode").addText(orgdepartment.getDivisionCode() == null ? "" : orgdepartment.getDivisionCode());
        orgDepartment.addElement("enName").addText(orgdepartment.getEnName() == null ? "" : orgdepartment.getEnName());
        orgDepartment.addElement("establishDate").addText(orgdepartment.getEstablishDate() == null ? "" : this.fmt2.format(orgdepartment.getEstablishDate()));
        orgDepartment.addElement("gradeCode").addText(orgdepartment.getGradeCode() == null ? "" : orgdepartment.getGradeCode());
        orgDepartment.addElement("tenantId").addText(orgdepartment.getTenantId() == null ? "" : orgdepartment.getTenantId());
        orgDepartment.addElement("version").addText((String)(orgdepartment.getVersion() == null ? "" : "" + orgdepartment.getVersion()));
        orgDepartment.addElement("zipCode").addText(orgdepartment.getZipCode() == null ? "" : orgdepartment.getZipCode());
        orgDepartment.addElement("parentId").addText(orgdepartment.getParentId() == null ? "" : orgdepartment.getParentId());
        orgDepartment.addElement("deptTypeName").addText(orgdepartment.getDeptTypeName() == null ? "" : orgdepartment.getDeptTypeName());
        orgDepartment.addElement("gradeCodeName").addText(orgdepartment.getGradeCodeName() == null ? "" : orgdepartment.getGradeCodeName());
        orgDepartment.addElement("bureau").addText(Boolean.toString(orgdepartment.getBureau()));
        Element pElements = orgDepartment.addElement("properties");
        String properties = orgdepartment.getProperties();
        if (StringUtils.isNotBlank((CharSequence)properties)) {
            this.buildPropertyElement(properties, pElements);
        }
        return orgDepartment;
    }

    private Element buildIncludeElement(Element rootElement, Element element, String orgBaseId) {
        Element include = element.addElement("include");
        List<Y9Department> departmentList = this.y9DepartmentService.listByParentId(orgBaseId, false);
        for (Y9Department y9Department : departmentList) {
            include.addElement(OrgTypeEnum.DEPARTMENT.getEnName()).addText(y9Department.getId());
        }
        List<Y9DepartmentProp> propList = this.y9DepartmentPropService.listByDeptId(orgBaseId);
        for (Y9DepartmentProp y9DepartmentProp : propList) {
            include.addElement("DepartmentProp").addText(y9DepartmentProp.getId());
            Element element2 = rootElement.addElement("DepartmentProp");
            element2.addAttribute("uid", y9DepartmentProp.getId());
            element2.addElement("UID").addText(y9DepartmentProp.getId());
            element2.addElement("deptId").addText(y9DepartmentProp.getDeptId() == null ? "" : y9DepartmentProp.getDeptId());
            element2.addElement("orgBaseId").addText(y9DepartmentProp.getOrgBaseId() == null ? "" : y9DepartmentProp.getOrgBaseId());
            element2.addElement("category").addText(Integer.toString(y9DepartmentProp.getCategory()));
            element2.addElement("tabIndex").addText((String)(y9DepartmentProp.getTabIndex() == null ? "" : "" + y9DepartmentProp.getTabIndex()));
        }
        List<Y9Group> list = this.y9GroupService.listByParentId(orgBaseId, false);
        for (Y9Group y9Group : list) {
            include.addElement(OrgTypeEnum.GROUP.getEnName()).addText(y9Group.getId());
            Element groupElement = rootElement.addElement(OrgTypeEnum.GROUP.getEnName());
            groupElement.addAttribute("uid", y9Group.getId());
            groupElement.addAttribute("name", y9Group.getName() == null ? "" : y9Group.getName());
            groupElement.addElement("UID").addText(y9Group.getId());
            this.createTime = this.fmt.format(y9Group.getCreateTime() == null ? new Date() : y9Group.getCreateTime());
            this.updateTime = this.fmt.format(y9Group.getUpdateTime() == null ? new Date() : y9Group.getUpdateTime());
            groupElement.addElement("createTime").addText(this.createTime);
            groupElement.addElement("updateTime").addText(this.updateTime);
            groupElement.addElement("description").addText(y9Group.getDescription() == null ? "" : y9Group.getDescription());
            groupElement.addElement("customId").addText(y9Group.getCustomId() == null ? "" : y9Group.getCustomId());
            groupElement.addElement("disabled").addText(Boolean.toString(y9Group.getDisabled()));
            groupElement.addElement("dn").addText(y9Group.getDn() == null ? "" : y9Group.getDn());
            groupElement.addElement("orgType").addText(y9Group.getOrgType() == null ? "" : y9Group.getOrgType().getEnName());
            groupElement.addElement("type").addText(y9Group.getType() == null ? "" : y9Group.getType().getValue());
            groupElement.addElement("tabIndex").addText((String)(y9Group.getTabIndex() == null ? "" : "" + y9Group.getTabIndex()));
            groupElement.addElement("parentId").addText(y9Group.getParentId() == null ? "" : y9Group.getParentId());
            Element pElements = groupElement.addElement("properties");
            String properties = y9Group.getProperties();
            if (StringUtils.isNotBlank((CharSequence)properties)) {
                this.buildPropertyElement(properties, pElements);
            }
            Element groupInclude = groupElement.addElement("include");
            List<Y9PersonsToGroups> orgPersonsGroupsList = this.y9PersonsToGroupsService.listByGroupId(y9Group.getId());
            for (Y9PersonsToGroups y9PersonsToGroups : orgPersonsGroupsList) {
                groupInclude.addElement(OrgTypeEnum.PERSON.getEnName()).addText(y9PersonsToGroups.getPersonId());
            }
            List<Y9PositionsToGroups> y9PositionsToGroupsList = this.y9PositionsToGroupsService.listByGroupId(y9Group.getId());
            for (Y9PositionsToGroups positionsToGroup : y9PositionsToGroupsList) {
                groupInclude.addElement(OrgTypeEnum.POSITION.getEnName()).addText(positionsToGroup.getPositionId());
            }
        }
        List<Y9Position> list2 = this.y9PositionService.listByParentId(orgBaseId, false);
        for (Y9Position y9Position : list2) {
            include.addElement(OrgTypeEnum.POSITION.getEnName()).addText(y9Position.getId());
            Element positionElement = rootElement.addElement(OrgTypeEnum.POSITION.getEnName());
            positionElement.addAttribute("uid", y9Position.getId());
            positionElement.addAttribute("name", y9Position.getName() == null ? "" : y9Position.getName());
            positionElement.addElement("UID").addText(y9Position.getId());
            this.createTime = this.fmt.format(y9Position.getCreateTime() == null ? new Date() : y9Position.getCreateTime());
            this.updateTime = this.fmt.format(y9Position.getUpdateTime() == null ? new Date() : y9Position.getUpdateTime());
            positionElement.addElement("createTime").addText(this.createTime);
            positionElement.addElement("updateTime").addText(this.updateTime);
            positionElement.addElement("description").addText(y9Position.getDescription() == null ? "" : y9Position.getDescription());
            positionElement.addElement("customId").addText(y9Position.getCustomId() == null ? "" : y9Position.getCustomId());
            positionElement.addElement("disabled").addText(Boolean.toString(y9Position.getDisabled()));
            positionElement.addElement("dn").addText(y9Position.getDn() == null ? "" : y9Position.getDn());
            positionElement.addElement("orgType").addText(y9Position.getOrgType() == null ? "" : y9Position.getOrgType().getEnName());
            positionElement.addElement("tabIndex").addText((String)(y9Position.getTabIndex() == null ? "" : "" + y9Position.getTabIndex()));
            positionElement.addElement("parentId").addText(y9Position.getParentId() == null ? "" : y9Position.getParentId());
            Element pElements = positionElement.addElement("properties");
            String properties = y9Position.getProperties();
            if (StringUtils.isNotBlank((CharSequence)properties)) {
                this.buildPropertyElement(properties, pElements);
            }
            Element positionInclude = positionElement.addElement("include");
            List<Y9PersonsToPositions> orgPositionsPersonsList = this.y9PersonsToPositionsService.listByPositionId(y9Position.getId());
            for (Y9PersonsToPositions y9PersonsToPositions : orgPositionsPersonsList) {
                positionInclude.addElement(OrgTypeEnum.PERSON.getEnName()).addText(y9PersonsToPositions.getPersonId());
            }
        }
        List<Y9Person> list3 = this.y9PersonService.listByParentId(orgBaseId, false);
        for (Y9Person person : list3) {
            include.addElement(OrgTypeEnum.PERSON.getEnName()).addText(person.getId());
            Element personElement = rootElement.addElement(OrgTypeEnum.PERSON.getEnName());
            personElement.addAttribute("uid", person.getId());
            personElement.addAttribute("name", person.getName() == null ? "" : person.getName());
            personElement.addElement("UID").addText(person.getId());
            this.createTime = this.fmt.format(person.getCreateTime() == null ? new Date() : person.getCreateTime());
            this.updateTime = this.fmt.format(person.getUpdateTime() == null ? new Date() : person.getUpdateTime());
            personElement.addElement("createTime").addText(this.createTime);
            personElement.addElement("updateTime").addText(this.updateTime);
            personElement.addElement("description").addText(person.getDescription() == null ? "" : person.getDescription());
            personElement.addElement("customId").addText(person.getCustomId() == null ? "" : person.getCustomId());
            personElement.addElement("disabled").addText(Boolean.toString(person.getDisabled()));
            personElement.addElement("dn").addText(person.getDn() == null ? "" : person.getDn());
            personElement.addElement("orgType").addText(person.getOrgType() == null ? "" : person.getOrgType().getEnName());
            personElement.addElement("tabIndex").addText((String)(person.getTabIndex() == null ? "" : "" + person.getTabIndex()));
            personElement.addElement("avator").addText(person.getAvator() == null ? "" : person.getAvator());
            personElement.addElement("caid").addText(person.getCaid() == null ? "" : person.getCaid());
            personElement.addElement("email").addText(person.getEmail() == null ? "" : person.getEmail());
            personElement.addElement("loginName").addText(person.getLoginName() == null ? "" : person.getLoginName());
            personElement.addElement("mobile").addText(person.getMobile() == null ? "" : person.getMobile());
            personElement.addElement("officeAddress").addText(person.getOfficeAddress() == null ? "" : person.getOfficeAddress());
            personElement.addElement("officeFax").addText(person.getOfficeFax() == null ? "" : person.getOfficeFax());
            personElement.addElement("officePhone").addText(person.getOfficePhone() == null ? "" : person.getOfficePhone());
            personElement.addElement("official").addText((String)(person.getOfficial() == null ? "" : "" + person.getOfficial()));
            personElement.addElement("officialType").addText(person.getOfficialType() == null ? "" : person.getOfficialType());
            personElement.addElement("password").addText(person.getPassword() == null ? "" : person.getPassword());
            personElement.addElement("sex").addText((String)(person.getSex() == null ? "" : "" + person.getSex().getValue()));
            personElement.addElement("tenantId").addText(person.getTenantId() == null ? "" : person.getTenantId());
            personElement.addElement("version").addText((String)(person.getVersion() == null ? "" : "" + person.getVersion()));
            personElement.addElement("parentId").addText(person.getParentId() == null ? "" : person.getParentId());
            personElement.addElement("guidPath").addText(person.getGuidPath() == null ? "" : person.getParentId());
            personElement.addElement("original").addText((String)(person.getOriginal() == null ? "true" : "" + person.getOriginal()));
            personElement.addElement("originalId").addText(person.getOriginalId() == null ? "" : person.getOriginalId());
            Optional<Y9PersonExt> optionalY9PersonExt = this.y9PersonExtService.findByPersonId(person.getId());
            if (optionalY9PersonExt.isPresent()) {
                Y9PersonExt ext = optionalY9PersonExt.get();
                personElement.addElement("city").addText(ext.getCity() == null ? "" : ext.getCity());
                personElement.addElement("country").addText(ext.getCountry() == null ? "" : ext.getCountry());
                personElement.addElement("education").addText(ext.getEducation() == null ? "" : ext.getEducation());
                personElement.addElement("homeAddress").addText(ext.getHomeAddress() == null ? "" : ext.getHomeAddress());
                personElement.addElement("homePhone").addText(ext.getHomePhone() == null ? "" : ext.getHomePhone());
                personElement.addElement("idNum").addText(ext.getIdNum() == null ? "" : ext.getIdNum());
                personElement.addElement("idType").addText(ext.getIdType() == null ? "" : ext.getIdType());
                personElement.addElement("maritalStatus").addText((String)(ext.getMaritalStatus() == null ? "" : "" + ext.getMaritalStatus()));
                personElement.addElement("policitalStatus").addText(ext.getPoliticalStatus() == null ? "" : ext.getPoliticalStatus());
                personElement.addElement("professional").addText(ext.getProfessional() == null ? "" : ext.getProfessional());
                personElement.addElement("province").addText(ext.getProvince() == null ? "" : ext.getProvince());
                personElement.addElement("sign").addText(ext.getSign() == null ? "" : new String(ext.getSign()));
                personElement.addElement("photo").addText(ext.getPhoto() == null ? "" : Y9Base64Util.encode((byte[])ext.getPhoto()));
                if (null != ext.getWorkTime()) {
                    personElement.addElement("worktime").addText(this.fmt2.format(ext.getWorkTime()));
                }
                if (null != ext.getBirthday()) {
                    personElement.addElement("birthday").addText(this.fmt2.format(ext.getBirthday()));
                }
            }
            Element pElements = personElement.addElement("properties");
            String properties = person.getProperties();
            if (!StringUtils.isNotBlank((CharSequence)properties)) continue;
            this.buildPropertyElement(properties, pElements);
        }
        return rootElement;
    }

    private Element buildOrgElement(Element rootElement, String orgId) {
        Y9Organization y9Organization = this.y9OrganizationService.getById(orgId);
        Element orgElement = rootElement.addElement(OrgTypeEnum.ORGANIZATION.getEnName());
        orgElement.addAttribute("uid", y9Organization.getId());
        orgElement.addAttribute("name", y9Organization.getName());
        orgElement.addElement("UID").addText(y9Organization.getId());
        this.createTime = this.fmt.format(y9Organization.getCreateTime() == null ? new Date() : y9Organization.getCreateTime());
        this.updateTime = this.fmt.format(y9Organization.getUpdateTime() == null ? new Date() : y9Organization.getUpdateTime());
        orgElement.addElement("createTime").addText(this.createTime);
        orgElement.addElement("updateTime").addText(this.updateTime);
        orgElement.addElement("description").addText(y9Organization.getDescription() != null ? y9Organization.getDescription() : "");
        orgElement.addElement("customId").addText(y9Organization.getCustomId() != null ? y9Organization.getCustomId() : "");
        orgElement.addElement("disabled").addText(Boolean.toString(y9Organization.getDisabled()));
        orgElement.addElement("dn").addText(y9Organization.getDn() != null ? y9Organization.getDn() : "");
        orgElement.addElement("orgType").addText(y9Organization.getOrgType() != null ? y9Organization.getOrgType().getEnName() : "");
        orgElement.addElement("tabIndex").addText((String)(y9Organization.getTabIndex() != null ? "" + y9Organization.getTabIndex() : ""));
        orgElement.addElement("enName").addText(y9Organization.getEnName() != null ? y9Organization.getEnName() : "");
        orgElement.addElement("organizationCode").addText(y9Organization.getOrganizationCode() != null ? y9Organization.getOrganizationCode() : "");
        orgElement.addElement("organizationType").addText(y9Organization.getOrganizationType() != null ? y9Organization.getOrganizationType() : "");
        orgElement.addElement("tenantId").addText(y9Organization.getTenantId() != null ? y9Organization.getTenantId() : "");
        orgElement.addElement("version").addText((String)(y9Organization.getVersion() != null ? "" + y9Organization.getVersion() : ""));
        orgElement.addElement("virtual").addText(Boolean.toString(y9Organization.getVirtual()));
        Element pElements = orgElement.addElement("properties");
        String properties = y9Organization.getProperties();
        if (StringUtils.isNotBlank((CharSequence)properties)) {
            this.buildPropertyElement(properties, pElements);
        }
        return orgElement;
    }

    private void buildPropertyElement(String properties, Element pElements) {
        HashMap map = null;
        try {
            map = (HashMap)Y9JsonUtil.objectMapper.readValue(properties, (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, String.class));
            for (Map.Entry entry : map.entrySet()) {
                Element pElement = pElements.addElement("property");
                pElement.addAttribute("name", (String)entry.getKey());
                pElement.addAttribute("value", (String)entry.getValue());
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    private Element buildSubElement(Element rootElement, String parentId) {
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.listByParentId(parentId, false);
        for (Y9Department orgdepartment : y9DepartmentList) {
            Element orgDepartment = this.buildDeptElement(rootElement, orgdepartment);
            this.buildIncludeElement(rootElement, orgDepartment, orgdepartment.getId());
            this.buildSubElement(rootElement, orgdepartment.getId());
        }
        return rootElement;
    }

    @Override
    public void exportOrgTree(String orgBaseId, OutputStream outputStream) {
        String xmlString = this.xmlExport(orgBaseId);
        xmlString = StringUtil.strChangeToXml(xmlString.getBytes(StandardCharsets.UTF_8));
        try (ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8));){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf, 0, 1024)) != -1) {
                outputStream.write(buf, 0, len);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void exportPerson(String orgBaseId, OutputStream outputStream) {
    }

    @Override
    public Y9Result<Object> importOrgTree(InputStream inputStream, String orgId) {
        DocumentFactory factory = DocumentFactory.getInstance();
        SAXReader saxReader = new SAXReader(factory);
        Document document = null;
        try {
            String[] uids;
            this.errorMsg = "";
            saxReader.setEncoding("UTF-8");
            document = saxReader.read(inputStream);
            String level = "";
            Element root = document.getRootElement();
            String uid = root.attributeValue("uid");
            String y9 = root.attributeValue("y9");
            boolean y9Version = "true".equals(y9);
            for (String id : uids = uid.split(",")) {
                this.recursiveRun(document, level, id, y9Version);
            }
        }
        catch (DocumentException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return Y9Result.failure((String)this.getPrintStackTrace((Exception)((Object)e)));
        }
        return Y9Result.success((Object)"", (String)this.errorMsg);
    }

    @Override
    public Y9Result<Object> importPerson(InputStream inputStream, String orgId) {
        return null;
    }

    private List<String> getPersons(Element currentNode) {
        List nodes;
        ArrayList<String> persons = new ArrayList<String>();
        Element include = currentNode.element("include");
        if (include != null && (nodes = include.elements()) != null && !nodes.isEmpty()) {
            for (Element element : nodes) {
                String guid = element.getText();
                if (!StringUtils.isNotBlank((CharSequence)guid) || !OrgTypeEnum.PERSON.getEnName().equals(element.getName())) continue;
                persons.add(guid);
            }
        }
        return persons;
    }

    private List<String> getPositions(Element currentNode) {
        List nodes;
        ArrayList<String> positions = new ArrayList<String>();
        Element include = currentNode.element("include");
        if (include != null && (nodes = include.elements()) != null && nodes.size() > 0) {
            for (Element element : nodes) {
                String guid = element.getText();
                if (!StringUtils.isNotBlank((CharSequence)guid) || !OrgTypeEnum.POSITION.getEnName().equals(element.getName())) continue;
                positions.add(guid);
            }
        }
        return positions;
    }

    private String getPrintStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recursiveRun(Document document, String level, String uid, boolean y9Version) {
        List nodes;
        SimpleDateFormat fmt2 = new SimpleDateFormat("yyyy-MM-dd");
        Element currentNode = (Element)document.selectSingleNode("/org/*[@uid=\"" + uid + "\"]");
        String nodeName = currentNode.getName();
        String name = currentNode.attributeValue("name");
        String description = currentNode.elementText("description");
        String customId = currentNode.elementText("customId");
        if (StringUtils.isBlank((CharSequence)customId)) {
            customId = currentNode.elementText("customID");
        }
        String disabled = currentNode.elementText("disabled");
        String properties = "";
        Element propertiesElement = currentNode.element("properties");
        if (propertiesElement != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            nodes = propertiesElement.elements();
            for (Element node : nodes) {
                String key = node.attributeValue("name");
                String value = node.attributeValue("value");
                map.put(key, value);
            }
            properties = Y9JsonUtil.writeValueAsString(map);
        }
        if (OrgTypeEnum.ORGANIZATION.getEnName().equals(nodeName)) {
            Y9Organization org = null;
            try {
                String enName = currentNode.elementText("enName");
                String organizationCode = currentNode.elementText("organizationCode");
                String organizationType = currentNode.elementText("organizationType");
                String virtual = currentNode.elementText("virtual");
                Optional<Y9Organization> y9OrganizationOptional = this.y9OrganizationService.findById(uid);
                if (y9OrganizationOptional.isEmpty()) {
                    org = new Y9Organization();
                    org.setId(uid);
                } else {
                    org = y9OrganizationOptional.get();
                }
                org.setDescription(description == null ? "" : description);
                org.setCustomId(customId == null ? "" : customId);
                org.setName(name == null ? "" : name);
                org.setEnName(enName == null ? "" : enName);
                org.setOrganizationCode(organizationCode == null ? "" : organizationCode);
                org.setOrganizationType(organizationType == null ? "" : organizationType);
                org.setProperties(properties);
                org.setVirtual(Boolean.valueOf(Boolean.parseBoolean(virtual)));
                this.y9OrganizationService.saveOrUpdate(org);
                Element include = currentNode.element("include");
                if (include == null || (nodes = include.elements()) == null || nodes.size() <= 0) return;
                for (Element element : nodes) {
                    String guid = element.getText();
                    if (guid == null || guid.trim().length() <= 0) continue;
                    this.recursiveRun(document, level + "--", element.getText(), y9Version);
                }
                return;
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                Object message = "\u5bfc\u5165\u7ec4\u7ec7\u673a\u6784\u5b9e\u4f53\u51fa\u9519:";
                message = (String)message + "\r\n\u7ec4\u7ec7\u540d\u79f0:" + org.getName();
                message = (String)message + "\r\n\u9519\u8bef\u63cf\u8ff0:" + this.getPrintStackTrace(e);
                this.errorMsg = this.errorMsg + (String)message;
                return;
            }
        }
        if (OrgTypeEnum.DEPARTMENT.getEnName().equals(nodeName)) {
            Y9Department dept = null;
            try {
                String aliasName = currentNode.elementText("aliasName");
                String deptAddress = currentNode.elementText("deptAddress");
                String deptFax = currentNode.elementText("deptFax");
                String deptGivenName = currentNode.elementText("deptGivenName");
                String deptOffice = currentNode.elementText("deptOffice");
                String deptPhone = currentNode.elementText("deptPhone");
                String deptType = currentNode.elementText("deptType");
                String divisionCode = currentNode.elementText("divisionCode");
                String enName = currentNode.elementText("enName");
                String establishDate = currentNode.elementText("establishDate");
                String gradeCode = currentNode.elementText("gradeCode");
                String zipCode = currentNode.elementText("zipCode");
                String deptTypeName = currentNode.elementText("deptTypeName");
                String gradeCodeName = currentNode.elementText("gradeCodeName");
                String bureau = currentNode.elementText("bureau");
                String tabIndex = currentNode.elementText("tabIndex");
                Element parentNode = (Element)document.selectSingleNode("/org/*[include/Department=\"" + uid + "\"]");
                String pid = parentNode.attributeValue("uid");
                Optional<Y9Department> y9DepartmentOptional = this.y9DepartmentService.findById(uid);
                if (y9DepartmentOptional.isEmpty()) {
                    dept = new Y9Department();
                    dept.setId(uid);
                } else {
                    dept = y9DepartmentOptional.get();
                }
                dept.setParentId(pid);
                dept.setName(name == null ? "" : name);
                dept.setDescription(description == null ? "" : description);
                dept.setCustomId(customId == null ? "" : customId);
                dept.setAliasName(aliasName == null ? "" : aliasName);
                dept.setDeptAddress(deptAddress);
                dept.setDeptFax(deptFax == null ? "" : deptFax);
                dept.setDeptGivenName(deptGivenName == null ? "" : deptGivenName);
                dept.setDeptOffice(deptOffice == null ? "" : deptOffice);
                dept.setDeptPhone(deptPhone == null ? "" : deptPhone);
                dept.setDeptType(deptTypeName == null ? "" : deptType);
                dept.setDivisionCode(divisionCode == null ? "" : divisionCode);
                dept.setEnName(enName == null ? "" : enName);
                dept.setEstablishDate(StringUtils.isBlank((CharSequence)establishDate) ? new Date() : fmt2.parse(establishDate));
                dept.setGradeCode(gradeCodeName == null ? "" : gradeCode);
                dept.setZipCode(zipCode == null ? "" : zipCode);
                dept.setDeptTypeName(deptTypeName == null ? "" : deptTypeName);
                dept.setGradeCodeName(gradeCodeName == null ? "" : gradeCodeName);
                dept.setProperties(properties);
                dept.setTabIndex(tabIndex != null ? Integer.valueOf(Integer.parseInt(tabIndex)) : null);
                if (y9Version) {
                    dept.setBureau(Boolean.valueOf(bureau != null && Boolean.valueOf(bureau) != false));
                }
                this.y9DepartmentService.saveOrUpdate(dept);
                Element include = currentNode.element("include");
                if (include == null || (nodes = include.elements()) == null || nodes.size() <= 0) return;
                for (Element element : nodes) {
                    String guid = element.getText();
                    if (guid == null || guid.trim().length() <= 0) continue;
                    this.recursiveRun(document, level + "--", guid, y9Version);
                }
                return;
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                Object message = "\u5bfc\u5165\u90e8\u95e8\u51fa\u9519:";
                message = (String)message + "\r\n\u90e8\u95e8\u540d\u79f0:" + dept.getName();
                message = (String)message + "\r\n\u9519\u8bef\u63cf\u8ff0:" + this.getPrintStackTrace(e);
                this.errorMsg = this.errorMsg + (String)message;
                return;
            }
        }
        if ("DepartmentProp".equals(nodeName)) {
            Y9DepartmentProp prop = null;
            try {
                String deptId = currentNode.elementText("deptId");
                String orgBaseId = currentNode.elementText("orgBaseId");
                String category = currentNode.elementText("category");
                String tabIndex = currentNode.elementText("tabIndex");
                Optional<Y9DepartmentProp> y9DepartmentPropOptional = this.y9DepartmentPropService.findById(uid);
                if (y9DepartmentPropOptional.isEmpty()) {
                    prop = new Y9DepartmentProp();
                    prop.setId(uid);
                } else {
                    prop = y9DepartmentPropOptional.get();
                }
                prop.setDeptId(deptId == null ? "" : deptId);
                prop.setOrgBaseId(orgBaseId == null ? "" : orgBaseId);
                prop.setCategory(category != null ? Integer.valueOf(Integer.parseInt(category)) : null);
                prop.setTabIndex(tabIndex != null ? Integer.valueOf(Integer.parseInt(tabIndex)) : null);
                this.y9DepartmentPropService.saveOrUpdate(prop);
                return;
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                Object message = "\u5bfc\u5165\u90e8\u95e8\u914d\u7f6e\u51fa\u9519:";
                message = (String)message + "\r\n\u90e8\u95e8ID:" + prop.getDeptId();
                message = (String)message + "\r\norgBaseId:" + prop.getOrgBaseId();
                message = (String)message + "\r\n\u9519\u8bef\u63cf\u8ff0:" + this.getPrintStackTrace(e);
                this.errorMsg = this.errorMsg + (String)message;
            }
            return;
        }
        if (OrgTypeEnum.GROUP.getEnName().equals(nodeName)) {
            Y9Group group = null;
            String type = "";
            try {
                List<String> positions;
                Element parentNode = (Element)document.selectSingleNode("/org/Organization[include/Group=\"" + uid + "\"] | /org/Department[include/Group=\"" + uid + "\"]");
                String tabIndex = currentNode.elementText("tabIndex");
                type = currentNode.elementText("type");
                String pid = parentNode.attributeValue("uid");
                group = this.y9GroupService.findById(uid).orElse(new Y9Group());
                group.setId(uid);
                group.setParentId(pid);
                group.setType(type == null ? GroupTypeEnum.PERSON : (GroupTypeEnum)Y9EnumUtil.valueOf(GroupTypeEnum.class, (Object)type));
                group.setName(name == null ? "" : name);
                group.setDescription(description == null ? "" : description);
                group.setCustomId(customId == null ? "" : customId);
                group.setProperties(properties);
                group.setTabIndex(tabIndex != null ? Integer.valueOf(Integer.parseInt(tabIndex)) : null);
                this.y9GroupService.saveOrUpdate(group);
                List<String> persons = this.getPersons(currentNode);
                if (persons != null && !persons.isEmpty()) {
                    this.y9PersonsToGroupsService.addPersons(uid, persons.toArray(new String[0]));
                }
                if ((positions = this.getPositions(currentNode)) == null || positions.isEmpty()) return;
                this.y9PositionsToGroupsService.saveGroupPosition(uid, persons.toArray(new String[0]));
                return;
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                Object message = "\u5bfc\u5165\u7528\u6237\u7ec4\u51fa\u9519:";
                message = (String)message + "\r\n\u7528\u6237\u7ec4\u540d\u79f0:" + group.getName();
                message = (String)message + "\r\n\u7528\u6237\u7ec4ID:" + group.getId();
                message = (String)message + "\r\n\u9519\u8bef\u63cf\u8ff0:" + this.getPrintStackTrace(e);
                this.errorMsg = this.errorMsg + (String)message;
            }
            return;
        }
        if (OrgTypeEnum.POSITION.getEnName().equals(nodeName)) {
            Y9Position position = null;
            try {
                String duty = currentNode.elementText("duty");
                String dutyLevel = currentNode.elementText("dutyLevel");
                String dutyLevelName = currentNode.elementText("dutyLevelName");
                String dutyType = currentNode.elementText("dutyType");
                String parentId = currentNode.elementText("parentId");
                if (StringUtils.isBlank((CharSequence)parentId)) {
                    parentId = currentNode.elementText("parentID");
                }
                String tabIndex = currentNode.elementText("tabIndex");
                Element parentNode = (Element)document.selectSingleNode("/org/Organization[include/Position=\"" + uid + "\"] | /org/Department[include/Position=\"" + uid + "\"]");
                String pid = parentNode.attributeValue("uid");
                Optional<Y9Position> y9PositionOptional = this.y9PositionService.findById(uid);
                if (y9PositionOptional.isEmpty()) {
                    position = new Y9Position();
                    position.setId(uid);
                } else {
                    position = y9PositionOptional.get();
                }
                position.setName(name == null ? "" : name);
                position.setDescription(description == null ? "" : description);
                position.setCustomId(customId == null ? "" : customId);
                position.setTabIndex(tabIndex != null ? Integer.valueOf(Integer.parseInt(tabIndex)) : null);
                position.setProperties(properties);
                position.setParentId(pid);
                return;
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                Object message = "\u5bfc\u5165\u5c97\u4f4d\u51fa\u9519:";
                message = (String)message + "\r\n\u5c97\u4f4d\u540d\u79f0:" + position.getName();
                message = (String)message + "\r\n\u5c97\u4f4dID:" + position.getId();
                message = (String)message + "\r\n\u9519\u8bef\u63cf\u8ff0:" + this.getPrintStackTrace(e);
                this.errorMsg = this.errorMsg + (String)message;
            }
            return;
        }
        if (OrgTypeEnum.PERSON.getEnName().equals(nodeName)) {
            Y9Person person = null;
            try {
                String avator = currentNode.elementText("avator");
                String birthday = currentNode.elementText("birthday");
                String caid = currentNode.elementText("caid");
                String city = currentNode.elementText("city");
                String country = currentNode.elementText("country");
                String education = currentNode.elementText("education");
                String email = currentNode.elementText("email");
                String homeAddress = currentNode.elementText("homeAddress");
                String homePhone = currentNode.elementText("homePhone");
                String idNum = currentNode.elementText("idNum");
                String idType = currentNode.elementText("idType");
                String loginName = currentNode.elementText("loginName");
                String maritalStatus = currentNode.elementText("maritalStatus");
                String mobile = currentNode.elementText("mobile");
                String officeAddress = currentNode.elementText("officeAddress");
                String officeFax = currentNode.elementText("officeFax");
                String officePhone = currentNode.elementText("officePhone");
                String official = currentNode.elementText("official");
                String officialType = currentNode.elementText("officialType");
                String password = currentNode.elementText("password");
                String photo = currentNode.elementText("photo");
                String policitalStatus = currentNode.elementText("policitalStatus");
                String professional = currentNode.elementText("professional");
                String province = currentNode.elementText("province");
                String sex = currentNode.elementText("sex");
                String sign = currentNode.elementText("sign");
                String worktime = currentNode.elementText("workTime");
                String tabIndex = currentNode.elementText("tabIndex");
                String original = currentNode.elementText("original");
                String originalId = currentNode.elementText("originalId");
                if (!y9Version) {
                    sex = "0".equals(sex) ? "1" : "0";
                }
                Element parentNode = (Element)document.selectSingleNode("/org/Organization[include/Person=\"" + uid + "\"] | /org/Department[include/Person=\"" + uid + "\"]");
                String pid = parentNode.attributeValue("uid");
                Optional<Y9Person> y9PersonOptional = this.y9PersonService.findById(uid);
                if (y9PersonOptional.isEmpty()) {
                    person = new Y9Person();
                    person.setId(uid);
                } else {
                    person = y9PersonOptional.get();
                }
                person.setParentId(pid);
                person.setName(name == null ? "" : name);
                person.setDescription(description == null ? "" : description);
                person.setCustomId(customId == null ? "" : customId);
                person.setDisabled(Boolean.valueOf(disabled == null ? "false" : disabled));
                person.setAvator(avator == null ? "" : avator);
                person.setCaid(caid == null ? "" : caid);
                person.setEmail(email);
                person.setLoginName(loginName == null ? "" : loginName);
                person.setMobile(mobile == null ? "" : mobile);
                person.setOfficeAddress(officeAddress == null ? "" : officeAddress);
                person.setOfficeFax(officeFax == null ? "" : officeFax);
                person.setOfficePhone(officePhone == null ? "" : officePhone);
                person.setOfficial(Integer.valueOf(official == null ? 0 : Integer.valueOf(official)));
                person.setOfficialType(officialType == null ? "" : officialType);
                person.setPassword(password == null ? "" : password);
                person.setSex(sex == null ? SexEnum.FEMALE : (SexEnum)Y9EnumUtil.valueOf(SexEnum.class, (Object)Integer.valueOf(sex)));
                person.setProperties(properties);
                person.setTabIndex(tabIndex != null ? Integer.valueOf(Integer.parseInt(tabIndex)) : null);
                if (StringUtils.isBlank((CharSequence)original) || "1".equals(original)) {
                    original = "true";
                } else if ("0".equals(original)) {
                    original = "false";
                }
                person.setOriginal(Boolean.valueOf(original));
                person.setOriginalId(originalId);
                Y9PersonExt ext = this.y9PersonExtService.findByPersonId(uid).orElse(new Y9PersonExt());
                ext.setBirthday(birthday == null ? null : fmt2.parse(birthday));
                ext.setMaritalStatus(maritalStatus == null ? MaritalStatusEnum.SECRET : (MaritalStatusEnum)Y9EnumUtil.valueOf(MaritalStatusEnum.class, (Object)Integer.valueOf(maritalStatus)));
                ext.setHomeAddress(homeAddress == null ? "" : homeAddress);
                ext.setHomePhone(homePhone == null ? "" : homePhone);
                ext.setIdNum(idNum == null ? "" : idNum);
                ext.setIdType(idType == null ? "" : idType);
                ext.setCountry(country == null ? "" : country);
                ext.setEducation(education == null ? "" : education);
                ext.setCity(city == null ? "" : city);
                ext.setPoliticalStatus(policitalStatus == null ? "" : policitalStatus);
                ext.setProfessional(professional == null ? "" : professional);
                ext.setProvince(province == null ? "" : province);
                if (StringUtils.isNotBlank((CharSequence)photo)) {
                    ext.setPhoto(Y9Base64Util.decodeAsBytes((String)photo));
                }
                ext.setSign(sign == null ? "".getBytes() : sign.getBytes());
                ext.setWorkTime(worktime == null ? null : fmt2.parse(worktime));
                if (y9Version) {
                    this.y9PersonService.saveOrUpdate4ImpOrg(person, ext);
                    return;
                }
                this.y9PersonService.saveOrUpdate(person, ext);
                return;
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                Object message = "\u5bfc\u5165\u4eba\u5458\u51fa\u9519:";
                message = (String)message + "\r\n\u4eba\u5458\u540d\u79f0:" + person.getName();
                message = (String)message + "\r\n\u4eba\u5458ID:" + person.getId();
                message = (String)message + "\r\n\u9519\u8bef\u63cf\u8ff0:" + this.getPrintStackTrace(e);
                this.errorMsg = this.errorMsg + (String)message;
            }
            return;
        }
        String message = "y9\u4e0d\u80fd\u8bc6\u522b\u7684\u8282\u70b9:" + nodeName;
        this.errorMsg = this.errorMsg + message;
    }

    private String xmlExport(String orgBaseId) {
        Document document = DocumentHelper.createDocument();
        document.setXMLEncoding("utf-8");
        Element rootElement = document.addElement("org");
        rootElement.addAttribute("y9", "true");
        Y9Organization y9Organization = this.y9OrganizationService.getById(orgBaseId);
        if (y9Organization != null) {
            rootElement.addAttribute("uid", y9Organization.getId());
            Element orgElement = this.buildOrgElement(rootElement, orgBaseId);
            this.buildIncludeElement(rootElement, orgElement, orgBaseId);
            document.setRootElement(this.buildSubElement(rootElement, orgBaseId));
        } else {
            y9Organization = this.compositeOrgBaseService.getOrgUnitOrganization(orgBaseId);
            rootElement.addAttribute("uid", y9Organization.getId());
            Element orgElement = this.buildOrgElement(rootElement, y9Organization.getId());
            Element include = orgElement.addElement("include");
            include.addElement(OrgTypeEnum.DEPARTMENT.getEnName()).addText(orgBaseId);
            Element deptElement = this.buildDeptElement(rootElement, this.y9DepartmentService.getById(orgBaseId));
            document.setRootElement(this.buildIncludeElement(rootElement, deptElement, orgBaseId));
        }
        return document.asXML();
    }

    @Generated
    public Y9OrgTreeXmlDataHandlerImpl(Y9OrganizationService y9OrganizationService, Y9DepartmentService y9DepartmentService, Y9DepartmentPropService y9DepartmentPropService, Y9GroupService y9GroupService, Y9PersonsToGroupsService y9PersonsToGroupsService, Y9PositionsToGroupsService y9PositionsToGroupsService, Y9PersonService y9PersonService, Y9PersonsToPositionsService y9PersonsToPositionsService, Y9PositionService y9PositionService, Y9PersonExtService y9PersonExtService, CompositeOrgBaseService compositeOrgBaseService) {
        this.y9OrganizationService = y9OrganizationService;
        this.y9DepartmentService = y9DepartmentService;
        this.y9DepartmentPropService = y9DepartmentPropService;
        this.y9GroupService = y9GroupService;
        this.y9PersonsToGroupsService = y9PersonsToGroupsService;
        this.y9PositionsToGroupsService = y9PositionsToGroupsService;
        this.y9PersonService = y9PersonService;
        this.y9PersonsToPositionsService = y9PersonsToPositionsService;
        this.y9PositionService = y9PositionService;
        this.y9PersonExtService = y9PersonExtService;
        this.compositeOrgBaseService = compositeOrgBaseService;
    }
}

