/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.v0.resource;

import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.v0.resource.ResourceApi;
import net.risesoft.enums.platform.ResourceTypeEnum;
import net.risesoft.model.platform.Resource;
import net.risesoft.util.ModelConvertUtil;
import net.risesoft.y9.util.Y9EnumUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.resource.Y9App;
import net.risesoft.y9public.entity.resource.Y9Menu;
import net.risesoft.y9public.entity.resource.Y9ResourceBase;
import net.risesoft.y9public.entity.resource.Y9System;
import net.risesoft.y9public.repository.resource.Y9AppRepository;
import net.risesoft.y9public.service.resource.CompositeResourceService;
import net.risesoft.y9public.service.resource.Y9MenuService;
import net.risesoft.y9public.service.resource.Y9SystemService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController(value="v0ResourceApiImpl")
@RequestMapping(value={"/services/rest/resource"}, produces={"application/json"})
@Deprecated
public class ResourceApiImpl
implements ResourceApi {
    private final CompositeResourceService compositeResourceService;
    private final Y9SystemService y9SystemService;
    private final Y9AppRepository y9AppRepository;
    private final Y9MenuService y9MenuService;

    public Resource createMenuResource(@RequestParam(value="resourceId") @NotBlank String resourceId, @RequestParam(value="resourceName") @NotBlank String resourceName, @RequestParam(value="parentResourceId") @NotBlank String parentResourceId, @RequestParam(value="customId") @NotBlank String customId) {
        Y9Menu y9Menu;
        Y9ResourceBase parentResource = this.compositeResourceService.findById(parentResourceId);
        Optional y9MenuOptional = this.y9MenuService.findById(resourceId);
        if (y9MenuOptional.isEmpty()) {
            y9Menu = new Y9Menu();
            y9Menu.setId(resourceId);
        } else {
            y9Menu = (Y9Menu)y9MenuOptional.get();
        }
        if (parentResource != null) {
            y9Menu.setAppId(parentResource.getAppId());
            y9Menu.setSystemId(parentResource.getSystemId());
            y9Menu.setParentId(parentResourceId);
        }
        y9Menu.setName(resourceName);
        y9Menu.setInherit(Boolean.FALSE);
        y9Menu.setHidden(Boolean.FALSE);
        y9Menu.setEnabled(Boolean.TRUE);
        if (StringUtils.isNotBlank((CharSequence)customId)) {
            y9Menu.setCustomId(customId);
        }
        y9Menu = this.y9MenuService.saveOrUpdate(y9Menu);
        return ModelConvertUtil.resourceBaseToResource((Y9ResourceBase)y9Menu);
    }

    public Resource findByCustomIdAndParentId(@RequestParam(value="customId") @NotBlank String customId, @RequestParam(value="parentId") @NotBlank String parentId, @RequestParam(value="resourceType") Integer resourceType) {
        Y9ResourceBase y9ResourceBase = this.compositeResourceService.findByCustomIdAndParentId(customId, parentId, (ResourceTypeEnum)Y9EnumUtil.valueOf(ResourceTypeEnum.class, (Object)resourceType)).orElse(null);
        return ModelConvertUtil.resourceBaseToResource(y9ResourceBase);
    }

    public Resource getParentResource(@RequestParam(value="resourceId") @NotBlank String resourceId) {
        Y9ResourceBase acResource = this.compositeResourceService.findById(resourceId);
        if (acResource == null) {
            return null;
        }
        Y9ResourceBase parent = this.compositeResourceService.findById(acResource.getParentId());
        return ModelConvertUtil.resourceBaseToResource(parent);
    }

    public Resource getResource(@RequestParam(value="resourceId") @NotBlank String resourceId) {
        Y9ResourceBase acResource = this.compositeResourceService.findById(resourceId);
        return ModelConvertUtil.resourceBaseToResource(acResource);
    }

    public Resource getRootResourceBySystemName(@RequestParam(value="systemName") @NotBlank String systemName) {
        Optional<Y9System> y9SystemOptional = this.y9SystemService.findByName(systemName);
        if (y9SystemOptional.isPresent()) {
            Y9App app = this.y9AppRepository.findBySystemIdAndCustomId(y9SystemOptional.get().getId(), systemName).orElse(null);
            return ModelConvertUtil.resourceBaseToResource((Y9ResourceBase)app);
        }
        return null;
    }

    public List<Resource> listSubMenus(@RequestParam(value="resourceId") @NotBlank String resourceId) {
        List<Y9Menu> y9MenuList = this.y9MenuService.findByParentId(resourceId);
        return Y9ModelConvertUtil.convert(y9MenuList, Resource.class);
    }

    public List<Resource> listSubResources(@RequestParam(value="resourceId") @NotBlank String resourceId) {
        List<Y9ResourceBase> y9ResourceBaseList = this.compositeResourceService.listRootResourceBySystemId(resourceId);
        return Y9ModelConvertUtil.convert(y9ResourceBaseList, Resource.class);
    }

    @Generated
    public ResourceApiImpl(CompositeResourceService compositeResourceService, Y9SystemService y9SystemService, Y9AppRepository y9AppRepository, Y9MenuService y9MenuService) {
        this.compositeResourceService = compositeResourceService;
        this.y9SystemService = y9SystemService;
        this.y9AppRepository = y9AppRepository;
        this.y9MenuService = y9MenuService;
    }
}

