/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.v0.permission;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.v0.permission.RoleApi;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.relation.Y9OrgBasesToRoles;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.enums.platform.RoleTypeEnum;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Role;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.relation.Y9OrgBasesToRolesService;
import net.risesoft.util.ModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9EnumUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.role.Y9Role;
import net.risesoft.y9public.service.role.Y9RoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController(value="v0RoleApiImpl")
@RequestMapping(value={"/services/rest/role"}, produces={"application/json"})
@Deprecated
public class RoleApiImpl
implements RoleApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleApiImpl.class);
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final Y9OrgBasesToRolesService y9OrgBasesToRolesService;
    private final Y9PersonService y9PersonService;
    private final Y9RoleService y9RoleService;

    public boolean addPerson(@RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="roleId") @NotBlank String roleId, @RequestParam(value="tenantId") @NotBlank String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9OrgBasesToRolesService.addOrgUnitsForRole(roleId, Collections.singletonList(personId), Boolean.TRUE);
        return true;
    }

    public Role createRole(@RequestParam(value="roleId") String roleId, @RequestParam(value="roleName") String roleName, @RequestParam(value="parentId") String parentId, @RequestParam(value="customId") String customId, @RequestParam(value="type") String type) {
        Y9Role roleNode;
        Optional<Y9Role> y9RoleOptional = this.y9RoleService.findByCustomIdAndParentId(customId, parentId);
        if (y9RoleOptional.isEmpty()) {
            roleNode = new Y9Role();
            roleNode.setId(roleId);
            roleNode.setCustomId(customId);
            roleNode.setParentId(parentId);
            roleNode.setType((RoleTypeEnum)Y9EnumUtil.valueOf(RoleTypeEnum.class, (Object)type));
        } else {
            roleNode = y9RoleOptional.get();
        }
        roleNode.setName(roleName);
        roleNode = this.y9RoleService.saveOrUpdate(roleNode);
        return ModelConvertUtil.y9RoleToRole(roleNode);
    }

    public Boolean deleteRole(@RequestParam(value="roleId") @NotBlank String roleId) {
        this.y9RoleService.delete(roleId);
        return true;
    }

    public Role findByCustomIdAndParentId(@RequestParam(value="customId") @NotBlank String customId, @RequestParam(value="parentId") @NotBlank String parentId) {
        Y9Role roleNode = this.y9RoleService.findByCustomIdAndParentId(customId, parentId).orElse(null);
        return ModelConvertUtil.y9RoleToRole(roleNode);
    }

    public Role getRole(@RequestParam(value="roleId") @NotBlank String roleId) {
        Y9Role y9Role = this.y9RoleService.findById(roleId).orElse(null);
        return ModelConvertUtil.y9RoleToRole(y9Role);
    }

    public List<OrgUnit> listOrgUnitsById(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="roleId") @NotBlank String roleId, @RequestParam(value="orgType") @NotBlank String orgType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBasesToRoles> roleMappingList = this.y9OrgBasesToRolesService.listByRoleId(roleId);
        ArrayList<Y9OrgBase> y9OrgBaseList = new ArrayList<Y9OrgBase>();
        for (Y9OrgBasesToRoles roleMapping : roleMappingList) {
            Y9OrgBase y9OrgBase;
            if (Boolean.TRUE.equals(roleMapping.getNegative()) || (y9OrgBase = this.compositeOrgBaseService.getOrgUnit(roleMapping.getOrgId())) == null || !orgType.equals(y9OrgBase.getOrgType().getEnName())) continue;
            y9OrgBaseList.add(y9OrgBase);
        }
        Collections.sort(y9OrgBaseList);
        return ModelConvertUtil.orgBaseToOrgUnit(y9OrgBaseList);
    }

    public List<Person> listPersonsById(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="roleId") @NotBlank String roleId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBasesToRoles> roleMappingList = this.y9OrgBasesToRolesService.listByRoleId(roleId);
        ArrayList<Person> persons = new ArrayList<Person>();
        for (Y9OrgBasesToRoles roleMapping : roleMappingList) {
            Y9OrgBase y9OrgBase;
            if (Boolean.TRUE.equals(roleMapping.getNegative()) || (y9OrgBase = this.compositeOrgBaseService.getOrgUnit(roleMapping.getOrgId())) == null || !OrgTypeEnum.PERSON.equals((Object)y9OrgBase.getOrgType())) continue;
            Y9Person y9Person = this.y9PersonService.getById(roleMapping.getOrgId());
            persons.add((Person)Y9ModelConvertUtil.convert((Object)y9Person, Person.class));
        }
        return persons;
    }

    public List<Role> listRoleByParentId(@RequestParam(value="roleId") @NotBlank String roleId) {
        List<Y9Role> y9RoleList = this.y9RoleService.listByParentId(roleId);
        ArrayList<Role> roleList = new ArrayList<Role>();
        for (Y9Role y9Role : y9RoleList) {
            roleList.add(ModelConvertUtil.y9RoleToRole(y9Role));
        }
        return roleList;
    }

    public boolean removePerson(@RequestParam(value="personId") @NotBlank String personId, @RequestParam(value="roleId") @NotBlank String roleId, @RequestParam(value="tenantId") @NotBlank String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        try {
            this.y9OrgBasesToRolesService.removeOrgBases(roleId, Collections.singletonList(personId));
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Generated
    public RoleApiImpl(CompositeOrgBaseService compositeOrgBaseService, Y9OrgBasesToRolesService y9OrgBasesToRolesService, Y9PersonService y9PersonService, Y9RoleService y9RoleService) {
        this.compositeOrgBaseService = compositeOrgBaseService;
        this.y9OrgBasesToRolesService = y9OrgBasesToRolesService;
        this.y9PersonService = y9PersonService;
        this.y9RoleService = y9RoleService;
    }
}

