/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.v0.org;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.v0.org.PositionApi;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9Position;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.org.Y9PositionService;
import net.risesoft.service.relation.Y9PersonsToPositionsService;
import net.risesoft.util.ModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController(value="v0PositionApiImpl")
@RequestMapping(value={"/services/rest/position"}, produces={"application/json"})
@Deprecated
public class PositionApiImpl
implements PositionApi {
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final Y9PersonService orgPersonService;
    private final Y9PositionService y9PositionService;
    private final Y9PersonsToPositionsService orgPositionsPersonsService;

    public boolean addPerson(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String personId) {
        if (StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)positionId) || StringUtils.isBlank((CharSequence)personId)) {
            return false;
        }
        Y9LoginUserHolder.setTenantId((String)tenantId);
        if (this.y9PositionService.existsById(positionId) && this.orgPersonService.existsById(personId)) {
            this.orgPositionsPersonsService.addPersons(positionId, new String[]{personId});
            return true;
        }
        return false;
    }

    public Position createPosition(@RequestParam String tenantId, @RequestParam String positionJson) {
        if (StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)positionJson)) {
            return null;
        }
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Position y9Position = (Y9Position)Y9JsonUtil.readValue((String)positionJson, Y9Position.class);
        y9Position = this.y9PositionService.create(y9Position);
        return (Position)Y9ModelConvertUtil.convert((Object)y9Position, Position.class);
    }

    public boolean deletePosition(@RequestParam String tenantId, @RequestParam String positionId) {
        if (StringUtils.isBlank((CharSequence)positionId)) {
            return false;
        }
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9PositionService.deleteById(positionId);
        return true;
    }

    public OrgUnit getParent(@RequestParam String tenantId, @RequestParam String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgBase parent = this.compositeOrgBaseService.findOrgUnitParent(positionId).orElse(null);
        return ModelConvertUtil.orgBaseToOrgUnit(parent);
    }

    public Position getPosition(@RequestParam String tenantId, @RequestParam String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Position y9Position = this.y9PositionService.findById(positionId).orElse(null);
        return (Position)Y9ModelConvertUtil.convert((Object)y9Position, Position.class);
    }

    public boolean hasPosition(@RequestParam String tenantId, @RequestParam String positionName, @RequestParam String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.y9PositionService.hasPosition(positionName, personId);
    }

    public List<Position> listByParentId(@RequestParam String tenantId, @RequestParam String parentId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Position> y9PositionList = this.y9PositionService.listByParentId(parentId, false);
        return Y9ModelConvertUtil.convert(y9PositionList, Position.class);
    }

    public List<Position> listByPersonId(@RequestParam String tenantId, @RequestParam String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Position> y9PositionList = this.y9PositionService.listByPersonId(personId, Boolean.FALSE);
        return Y9ModelConvertUtil.convert(y9PositionList, Position.class);
    }

    public List<Person> listPersons(@RequestParam String tenantId, @RequestParam String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.orgPersonService.listByPositionId(positionId, Boolean.FALSE);
        return Y9ModelConvertUtil.convert(y9PersonList, Person.class);
    }

    public boolean removePerson(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        if (this.y9PositionService.existsById(positionId) && this.orgPersonService.existsById(personId)) {
            this.orgPositionsPersonsService.deletePersons(positionId, new String[]{personId});
            return true;
        }
        return false;
    }

    public Position updatePosition(@RequestParam String tenantId, @RequestParam String positionJson) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Position y9Position = (Y9Position)Y9JsonUtil.readValue((String)positionJson, Y9Position.class);
        y9Position = this.y9PositionService.saveOrUpdate(y9Position);
        return (Position)Y9ModelConvertUtil.convert((Object)y9Position, Position.class);
    }

    @Generated
    public PositionApiImpl(CompositeOrgBaseService compositeOrgBaseService, Y9PersonService orgPersonService, Y9PositionService y9PositionService, Y9PersonsToPositionsService orgPositionsPersonsService) {
        this.compositeOrgBaseService = compositeOrgBaseService;
        this.orgPersonService = orgPersonService;
        this.y9PositionService = y9PositionService;
        this.orgPositionsPersonsService = orgPositionsPersonsService;
    }
}

