/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.v0.org;

import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.v0.org.OrgUnitApi;
import net.risesoft.entity.Y9Department;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Organization;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9DepartmentService;
import net.risesoft.util.ModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9EnumUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController(value="v0OrgUnitApiImpl")
@RequestMapping(value={"/services/rest/orgUnit"}, produces={"application/json"})
@Deprecated
public class OrgUnitApiImpl
implements OrgUnitApi {
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final Y9DepartmentService y9DepartmentService;

    public OrgUnit getBureau(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return ModelConvertUtil.orgBaseToOrgUnit(this.compositeOrgBaseService.findOrgUnitBureau(orgUnitId).orElse(null));
    }

    public List<Department> getDeptTrees(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Department> y9DepartmentList = this.y9DepartmentService.listRecursivelyByParentId(orgUnitId, Boolean.FALSE);
        return Y9ModelConvertUtil.convert(y9DepartmentList, Department.class);
    }

    public OrgUnit getOrgUnit(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return ModelConvertUtil.orgBaseToOrgUnit(this.compositeOrgBaseService.findOrgUnit(orgUnitId).orElse(null));
    }

    public OrgUnit getOrgUnitDeletedById(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return ModelConvertUtil.orgBaseToOrgUnit(this.compositeOrgBaseService.findOrgUnitDeleted(orgUnitId).orElse(null));
    }

    public Organization getOrganization(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Organization y9OrgBase = this.compositeOrgBaseService.getOrgUnitOrganization(orgUnitId);
        return (Organization)Y9ModelConvertUtil.convert((Object)y9OrgBase, Organization.class);
    }

    public OrgUnit getParent(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgBase parent = this.compositeOrgBaseService.findOrgUnitParent(orgUnitId).orElse(null);
        return ModelConvertUtil.orgBaseToOrgUnit(parent);
    }

    public List<OrgUnit> getSubTree(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="orgUnitId") @NotBlank String orgUnitId, @RequestParam(value="treeType") @NotBlank String treeType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBase> y9OrgBaseList = this.compositeOrgBaseService.getTree(orgUnitId, (OrgTreeTypeEnum)Y9EnumUtil.valueOf(OrgTreeTypeEnum.class, (Object)treeType), false);
        return ModelConvertUtil.orgBaseToOrgUnit(y9OrgBaseList);
    }

    public List<OrgUnit> treeSearch(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="name") @NotBlank String name, @RequestParam(value="treeType") @NotBlank String treeType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBase> y9OrgBaseList = this.compositeOrgBaseService.treeSearch(name, (OrgTreeTypeEnum)Y9EnumUtil.valueOf(OrgTreeTypeEnum.class, (Object)treeType), false);
        return ModelConvertUtil.orgBaseToOrgUnit(y9OrgBaseList);
    }

    public List<OrgUnit> treeSearchByDn(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="name") @NotBlank String name, @RequestParam(value="treeType") @NotBlank String treeType, @RequestParam(value="dnName") @NotBlank String dnName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9OrgBase> y9OrgBaseList = this.compositeOrgBaseService.treeSearch(name, (OrgTreeTypeEnum)Y9EnumUtil.valueOf(OrgTreeTypeEnum.class, (Object)treeType), dnName, false);
        return ModelConvertUtil.orgBaseToOrgUnit(y9OrgBaseList);
    }

    @Generated
    public OrgUnitApiImpl(CompositeOrgBaseService compositeOrgBaseService, Y9DepartmentService y9DepartmentService) {
        this.compositeOrgBaseService = compositeOrgBaseService;
        this.y9DepartmentService = y9DepartmentService;
    }
}

