/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.v0.org;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.v0.org.OrgSyncApi;
import net.risesoft.entity.Y9Department;
import net.risesoft.entity.Y9Group;
import net.risesoft.entity.Y9Organization;
import net.risesoft.entity.Y9Person;
import net.risesoft.entity.Y9Position;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.Group;
import net.risesoft.model.platform.MessageOrg;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9DepartmentService;
import net.risesoft.service.org.Y9GroupService;
import net.risesoft.service.org.Y9OrganizationService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.org.Y9PositionService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.event.Y9PublishedEvent;
import net.risesoft.y9public.entity.event.Y9PublishedEventSyncHistory;
import net.risesoft.y9public.service.event.Y9PublishedEventService;
import net.risesoft.y9public.service.event.Y9PublishedEventSyncHistoryService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController(value="v0OrgSyncApiImpl")
@RequestMapping(value={"/services/rest/orgSync"}, produces={"application/json"})
@Deprecated
public class OrgSyncApiImpl
implements OrgSyncApi {
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final Y9DepartmentService orgDepartmentService;
    private final Y9GroupService orgGroupService;
    private final Y9OrganizationService orgOrganizationService;
    private final Y9PersonService orgPersonService;
    private final Y9PositionService orgPositionService;
    private final Y9PublishedEventService y9PublishedEventService;
    private final Y9PublishedEventSyncHistoryService y9PublishedEventSyncHistoryService;

    public Y9Result<MessageOrg> fullSync(@RequestParam(value="appName") @NotBlank String appName, @RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="organizationId") @NotBlank String organizationId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Date syncTime = new Date();
        HashMap<String, Serializable> dateMap = this.compositeOrgBaseService.getSyncMap(organizationId, OrgTypeEnum.ORGANIZATION, 1);
        MessageOrg event = new MessageOrg(dateMap, "RISEORGEVENT_TYPE_SYNC", Y9LoginUserHolder.getTenantId());
        this.y9PublishedEventSyncHistoryService.saveOrUpdate(tenantId, appName, syncTime, 1);
        return Y9Result.success((Object)event, (String)"\u83b7\u53d6\u6210\u529f\uff01");
    }

    public Y9Result<List<MessageOrg>> incrSync(@RequestParam(value="appName") @NotBlank String appName, @RequestParam(value="tenantId") @NotBlank String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Date syncTime = new Date();
        Date startTime = null;
        Optional<Y9PublishedEventSyncHistory> y9PublishedEventSyncHistoryOptional = this.y9PublishedEventSyncHistoryService.findByTenantIdAndAppName(tenantId, appName);
        if (y9PublishedEventSyncHistoryOptional.isPresent()) {
            startTime = y9PublishedEventSyncHistoryOptional.get().getLastSyncTime();
        }
        List<Y9PublishedEvent> list = this.y9PublishedEventService.listByTenantId(tenantId, startTime);
        ArrayList<MessageOrg> eventList = new ArrayList<MessageOrg>();
        for (Y9PublishedEvent event : list) {
            if (StringUtils.isBlank((CharSequence)event.getEntityJson())) {
                OrgUnit org = this.getOrgBase(event.getEventType(), event.getObjId());
                MessageOrg riseEvent = new MessageOrg((Serializable)((Object)Y9JsonUtil.writeValueAsString((Object)org)), event.getEventType(), tenantId);
                eventList.add(riseEvent);
                continue;
            }
            MessageOrg riseEvent = new MessageOrg((Serializable)((Object)event.getEntityJson()), event.getEventType(), tenantId);
            eventList.add(riseEvent);
        }
        this.y9PublishedEventSyncHistoryService.saveOrUpdate(tenantId, appName, syncTime, 1);
        return Y9Result.success(eventList, (String)"\u83b7\u53d6\u6210\u529f\uff01");
    }

    private OrgUnit getOrgBase(String eventType, String objId) {
        if (StringUtils.isBlank((CharSequence)objId)) {
            return null;
        }
        if ("RISEORGEVENT_TYPE_ADD_ORGANIZATION".equals(eventType)) {
            Y9Organization org = this.orgOrganizationService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)org, Organization.class);
        }
        if ("RISEORGEVENT_TYPE_ADD_DEPARTMENT".equals(eventType)) {
            Y9Department dept = this.orgDepartmentService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)dept, Department.class);
        }
        if ("RISEORGEVENT_TYPE_ADD_PERSON".equals(eventType)) {
            Y9Person person = this.orgPersonService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)person, Person.class);
        }
        if ("RISEORGEVENT_TYPE_UPDATE_ORGANIZATION".equals(eventType)) {
            Y9Organization org = this.orgOrganizationService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)org, Organization.class);
        }
        if ("RISEORGEVENT_TYPE_UPDATE_DEPARTMENT".equals(eventType)) {
            Y9Department dept = this.orgDepartmentService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)dept, Department.class);
        }
        if ("RISEORGEVENT_TYPE_UPDATE_PERSON".equals(eventType)) {
            Y9Person person = this.orgPersonService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)person, Person.class);
        }
        if ("RISEORGEVENT_TYPE_DELETE_ORGANIZATION".equals(eventType)) {
            Y9Organization org = this.orgOrganizationService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)org, Organization.class);
        }
        if ("RISEORGEVENT_TYPE_DELETE_DEPARTMENT".equals(eventType)) {
            Y9Department dept = this.orgDepartmentService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)dept, Department.class);
        }
        if ("RISEORGEVENT_TYPE_DELETE_PERSON".equals(eventType)) {
            Y9Person person = this.orgPersonService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)person, Person.class);
        }
        if ("RISEORGEVENT_TYPE_ADD_GROUP".equals(eventType)) {
            Y9Group group = this.orgGroupService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)group, Group.class);
        }
        if ("RISEORGEVENT_TYPE_ADD_POSITION".equals(eventType)) {
            Y9Position position = this.orgPositionService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)position, Position.class);
        }
        if ("RISEORGEVENT_TYPE_UPDATE_GROUP".equals(eventType)) {
            Y9Group group = this.orgGroupService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)group, Group.class);
        }
        if ("RISEORGEVENT_TYPE_UPDATE_POSITION".equals(eventType)) {
            Y9Position position = this.orgPositionService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)position, Position.class);
        }
        if ("RISEORGEVENT_TYPE_DELETE_GROUP".equals(eventType)) {
            Y9Group group = this.orgGroupService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)group, Group.class);
        }
        if ("RISEORGEVENT_TYPE_DELETE_POSITION".equals(eventType)) {
            Y9Position position = this.orgPositionService.getById(objId);
            return (OrgUnit)Y9ModelConvertUtil.convert((Object)position, Position.class);
        }
        return null;
    }

    @Generated
    public OrgSyncApiImpl(CompositeOrgBaseService compositeOrgBaseService, Y9DepartmentService orgDepartmentService, Y9GroupService orgGroupService, Y9OrganizationService orgOrganizationService, Y9PersonService orgPersonService, Y9PositionService orgPositionService, Y9PublishedEventService y9PublishedEventService, Y9PublishedEventSyncHistoryService y9PublishedEventSyncHistoryService) {
        this.compositeOrgBaseService = compositeOrgBaseService;
        this.orgDepartmentService = orgDepartmentService;
        this.orgGroupService = orgGroupService;
        this.orgOrganizationService = orgOrganizationService;
        this.orgPersonService = orgPersonService;
        this.orgPositionService = orgPositionService;
        this.y9PublishedEventService = y9PublishedEventService;
        this.y9PublishedEventSyncHistoryService = y9PublishedEventSyncHistoryService;
    }
}

