/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.v0.org;

import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.v0.org.GroupApi;
import net.risesoft.entity.Y9Group;
import net.risesoft.entity.Y9OrgBase;
import net.risesoft.entity.Y9Person;
import net.risesoft.model.platform.Group;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.service.org.CompositeOrgBaseService;
import net.risesoft.service.org.Y9GroupService;
import net.risesoft.service.org.Y9PersonService;
import net.risesoft.service.relation.Y9PersonsToGroupsService;
import net.risesoft.util.ModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController(value="v0GroupApiImpl")
@RequestMapping(value={"/services/rest/group"}, produces={"application/json"})
@Deprecated
public class GroupApiImpl
implements GroupApi {
    private final CompositeOrgBaseService compositeOrgBaseService;
    private final Y9PersonsToGroupsService y9PersonsToGroupsService;
    private final Y9GroupService y9GroupService;
    private final Y9PersonService y9PersonService;

    public boolean addPerson2Group(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupId") @NotBlank String groupId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        if (this.y9GroupService.existsById(groupId) && this.y9PersonService.existsById(personId)) {
            this.y9PersonsToGroupsService.addPersons(groupId, new String[]{personId});
            return true;
        }
        return false;
    }

    public Group createGroup(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupJson") @NotBlank String groupJson) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Group y9Group = (Y9Group)Y9JsonUtil.readValue((String)groupJson, Y9Group.class);
        y9Group = this.y9GroupService.createGroup(y9Group);
        return (Group)Y9ModelConvertUtil.convert((Object)y9Group, Group.class);
    }

    public boolean deleteGroup(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupId") @NotBlank String groupId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9GroupService.delete(groupId);
        return true;
    }

    public Group getGroup(@RequestParam @NotBlank String tenantId, @RequestParam @NotBlank String groupId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Group y9Group = this.y9GroupService.findById(groupId).orElse(null);
        return (Group)Y9ModelConvertUtil.convert((Object)y9Group, Group.class);
    }

    public OrgUnit getParent(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupId") @NotBlank String groupId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9OrgBase parent = this.compositeOrgBaseService.findOrgUnitParent(groupId).orElse(null);
        return ModelConvertUtil.orgBaseToOrgUnit(parent);
    }

    public List<Group> listByDn(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="dn") @NotBlank String dn) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Group> y9GroupList = this.y9GroupService.listByDn(dn, false);
        return Y9ModelConvertUtil.convert(y9GroupList, Group.class);
    }

    public List<Person> listPersons(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupId") @NotBlank String groupId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9Person> y9PersonList = this.y9PersonService.listByGroupId(groupId, Boolean.FALSE);
        return Y9ModelConvertUtil.convert(y9PersonList, Person.class);
    }

    public boolean removePerson(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupId") @NotBlank String groupId, @RequestParam(value="personId") @NotBlank String personId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.y9PersonsToGroupsService.removePersons(groupId, new String[]{personId});
        return true;
    }

    public Group updateGroup(@RequestParam(value="tenantId") @NotBlank String tenantId, @RequestParam(value="groupJson") @NotBlank String groupJson) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9Group y9Group = (Y9Group)Y9JsonUtil.readValue((String)groupJson, Y9Group.class);
        y9Group = this.y9GroupService.saveOrUpdate(y9Group);
        return (Group)Y9ModelConvertUtil.convert((Object)y9Group, Group.class);
    }

    @Generated
    public GroupApiImpl(CompositeOrgBaseService compositeOrgBaseService, Y9PersonsToGroupsService y9PersonsToGroupsService, Y9GroupService y9GroupService, Y9PersonService y9PersonService) {
        this.compositeOrgBaseService = compositeOrgBaseService;
        this.y9PersonsToGroupsService = y9PersonsToGroupsService;
        this.y9GroupService = y9GroupService;
        this.y9PersonService = y9PersonService;
    }
}

