/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.tenant;

import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.platform.tenant.TenantSystemApi;
import net.risesoft.model.platform.System;
import net.risesoft.model.platform.Tenant;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9public.entity.resource.Y9System;
import net.risesoft.y9public.entity.tenant.Y9Tenant;
import net.risesoft.y9public.service.tenant.Y9TenantSystemService;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Primary
@Validated
@RestController
@RequestMapping(value={"/services/rest/v1/tenantSystem"}, produces={"application/json"})
public class TenantSystemApiImpl
implements TenantSystemApi {
    private final Y9TenantSystemService y9TenantSystemService;

    public Y9Result<List<System>> listSystemByTenantId(@RequestParam(value="tenantId") @NotBlank String tenantId) {
        List<Y9System> y9SystemList = this.y9TenantSystemService.listSystemByTenantId(tenantId);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9SystemList, System.class));
    }

    public Y9Result<List<String>> listSystemIdByTenantId(@RequestParam(value="tenantId") @NotBlank String tenantId) {
        return Y9Result.success(this.y9TenantSystemService.listSystemIdByTenantId(tenantId));
    }

    public Y9Result<List<Tenant>> listTenantBySystemId(@RequestParam(value="systemId") @NotBlank String systemId) {
        List<Y9Tenant> y9TenantList = this.y9TenantSystemService.listTenantBySystemId(systemId);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9TenantList, Tenant.class));
    }

    public Y9Result<List<Tenant>> listTenantBySystemName(@RequestParam(value="systemName") @NotBlank String systemName) {
        List<Y9Tenant> y9TenantList = this.y9TenantSystemService.listTenantBySystemName(systemName);
        return Y9Result.success((Object)Y9ModelConvertUtil.convert(y9TenantList, Tenant.class));
    }

    @Generated
    public TenantSystemApiImpl(Y9TenantSystemService y9TenantSystemService) {
        this.y9TenantSystemService = y9TenantSystemService;
    }
}

